# 画面設計書 24-エラー画面

## 概要

本ドキュメントは、WebhookClientアプリケーションのエラー画面の設計仕様を記載する。

### 本画面の処理概要

本画面は、WebhookClientアプリケーションで発生した未処理例外やエラーを表示するための共通エラー画面である。エラー発生時のリクエストIDを表示し、開発者やサポートチームがトラブルシューティングを行う際の手がかりを提供する。

**業務上の目的・背景**：Webアプリケーションでは、予期しないエラーが発生した際にユーザーに適切なフィードバックを提供することが重要である。この画面は、エラー発生時にユーザーに状況を伝え、開発環境での詳細なデバッグ情報の確認方法を案内することで、問題解決を支援する業務課題を解決する。

**画面へのアクセス方法**：アプリケーション内で未処理例外が発生した際に自動的にリダイレクトされる。Program.csのUseExceptionHandlerミドルウェアにより、例外発生時に/Errorへリダイレクトされる設定になっている。

**主要な操作・処理内容**：
1. エラーメッセージの表示
2. リクエストIDの表示（存在する場合）
3. 開発環境での詳細情報表示方法の案内

**画面遷移**：
- 遷移元：任意のページでの例外発生時
- 遷移先：特になし（エラー画面からの遷移は想定されていない）

**権限による表示制御**：本画面に権限による表示制御はない。エラー発生時は認証状態に関わらず表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | ホーム画面 | 補助機能 | エラー発生時の詳細情報表示 |

## 画面種別

エラー表示

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/Error` |
| ルート定義 | `@page "/Error"` |
| 認証要件 | 不要 |

## 入出力項目

本画面に入力フォームはなし。

## 表示項目

| 項目名 | 論理名 | データ型 | 説明 | 表示条件 |
|--------|--------|----------|------|----------|
| Error. | エラータイトル | 固定テキスト | エラー発生を示す見出し | 常時 |
| An error occurred... | エラーメッセージ | 固定テキスト | エラー発生の説明 | 常時 |
| RequestId | リクエストID | string | エラー発生時のリクエスト識別子 | ShowRequestIdがtrue |
| Development Mode | 開発モード案内 | 固定テキスト | 詳細情報表示の案内 | 常時 |

## イベント仕様

### 1-ページ初期化（OnInitialized）

**トリガー**：ページアクセス時

**処理フロー**：
1. Activity.Current?.IdからリクエストIDを取得
2. 取得できない場合、HttpContext?.TraceIdentifierからリクエストIDを取得
3. RequestIdプロパティに設定

**データの流れ**：
```
Activity.Current?.Id ?? HttpContext?.TraceIdentifier → RequestId
                                                          │
                                                          ▼
                                              ShowRequestId (空でなければtrue)
```

### 2-リクエストID表示判定（ShowRequestId）

**トリガー**：ページ描画時

**処理フロー**：
1. RequestIdがnullまたは空でないかチェック
2. 結果に応じてリクエストID表示セクションの表示/非表示を制御

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面からはDBへのアクセスなし |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| エラー | Error. | 常時 |
| エラー | An error occurred while processing your request. | 常時 |
| 情報 | Request ID: {RequestId} | リクエストIDが存在する場合 |
| 案内 | Development Mode | 常時 |
| 案内 | Swapping to Development environment will display more detailed information about the error that occurred. | 常時 |
| 警告 | The Development environment shouldn't be enabled for deployed applications. | 常時 |
| 案内 | For local debugging, enable the Development environment by setting the ASPNETCORE_ENVIRONMENT environment variable to Development and restarting the app. | 常時 |

## 例外処理

本画面自体は例外処理の結果として表示される画面であり、本画面内での例外処理は特に定義されていない。

## 備考

- リクエストIDはActivity（分散トレーシング）またはHttpContext.TraceIdentifierから取得
- 開発環境（Development）ではより詳細な例外情報がASP.NET Coreのデフォルト例外ページで表示される
- Program.csでcreateScopeForErrors: trueが設定されており、エラーページ用に新しいDIスコープが作成される
- 本番環境でのセキュリティを考慮し、詳細な例外情報は表示されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エラーハンドリング設定を理解する

まず、アプリケーション全体のエラーハンドリング設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Program.cs | `src/WebhookClient/Program.cs` | UseExceptionHandlerでのエラーページ設定 |

**読解のコツ**: 14-19行目でIsDevelopmentでない場合にUseExceptionHandler("/Error")が設定されていることを確認。

#### Step 2: エントリーポイントを理解する

処理の起点となるRazorページを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Error.razor | `src/WebhookClient/Components/Pages/Error.razor` | エラー情報の取得と表示ロジック |

**主要処理フロー**:
1. **1行目**: @page "/Error"でルート定義
2. **2行目**: System.DiagnosticsのusingでActivityクラスを使用
3. **27-35行目**: @codeブロックでリクエストID取得ロジック
4. **9-14行目**: ShowRequestIdがtrueの場合にリクエストIDを表示
5. **16-25行目**: 開発モードでの詳細情報表示方法を案内

#### Step 3: リクエストID取得の仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Error.razor (@code) | `src/WebhookClient/Components/Pages/Error.razor` | Activity.CurrentとHttpContext.TraceIdentifierの使い分け |

**主要処理フロー**:
- **34-35行目**: Activity.Current?.IdがnullならHttpContext?.TraceIdentifierを使用

### プログラム呼び出し階層図

```
例外発生
    │
    ├─ 開発環境（IsDevelopment）
    │      └─ ASP.NET Coreデフォルト例外ページ
    │
    └─ 本番環境
           │
           └─ UseExceptionHandler("/Error")
                  │
                  └─ Error.razor (/Error)
                         │
                         ├─ OnInitialized()
                         │      │
                         │      ├─ Activity.Current?.Id
                         │      │      └─ 分散トレーシングID
                         │      │
                         │      └─ HttpContext?.TraceIdentifier
                         │             └─ ASP.NETリクエストID
                         │
                         └─ 画面描画
                                │
                                ├─ エラーメッセージ表示
                                │
                                ├─ RequestId表示（存在時）
                                │
                                └─ 開発モード案内
```

### データフロー図

```
[入力]                     [処理]                           [出力]

例外発生 ─────────────▶ UseExceptionHandler
                               │
                               ▼
                        /Error へリダイレクト
                               │
                               ▼
                        OnInitialized()
                               │
                        ┌──────┴──────┐
                        ▼              ▼
              Activity.Current?.Id   HttpContext?.TraceIdentifier
                        │              │
                        └──────┬───────┘
                               ▼
                           RequestId
                               │
                               ▼
                        ShowRequestId判定
                               │
                    ┌──────────┴──────────┐
                    ▼                      ▼
              true: 表示              false: 非表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Error.razor | `src/WebhookClient/Components/Pages/Error.razor` | ソース | エラー画面メインページ |
| Program.cs | `src/WebhookClient/Program.cs` | ソース | エラーハンドリング設定 |
