# 画面設計書 25-カタログ画面

## 概要

本ドキュメントは、HybridApp（MAUI Blazor Hybrid）のカタログ画面の設計仕様を記載する。

### 本画面の処理概要

本画面は、eShopシステムのMAUI Hybrid版アプリケーションにおけるメインのカタログ表示画面である。ユーザーはこの画面を通じて、商品一覧を閲覧し、ブランドや商品タイプでフィルタリングし、ページネーションで複数ページの商品を閲覧することができる。WebAppのカタログ画面と同等の機能を、ネイティブMAUIアプリケーション内のBlazorコンポーネントとして提供する。

**業務上の目的・背景**：モバイルデバイスやデスクトップアプリケーションからeShopの商品カタログにアクセスしたいユーザーのニーズに応えるため、MAUI Blazor Hybrid技術を使用したネイティブアプリケーションが必要である。この画面は、Webブラウザを使用せずに商品一覧を閲覧・検索できる業務課題を解決し、オフライン対応やネイティブ機能との連携の可能性を提供する。

**画面へのアクセス方法**：HybridAppアプリケーションを起動するとホーム画面として表示される。ルートURL（/）として設定されており、アプリケーションのデフォルト画面となる。

**主要な操作・処理内容**：
1. 商品一覧の表示（9件ずつページネーション）
2. ブランドによるフィルタリング
3. 商品タイプによるフィルタリング
4. ページ切り替え（ページネーション）
5. 商品詳細画面への遷移

**画面遷移**：
- 遷移先：商品詳細画面（/item/{itemId}）

**権限による表示制御**：HybridAppは認証機能が未実装のため、権限による表示制御はない。すべてのユーザーがカタログを閲覧できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | 商品一覧取得 | 主機能 | CatalogServiceで商品一覧を取得・表示 |
| 9 | 商品タイプ一覧取得 | 補助機能 | CatalogSearchでタイプフィルタリング用一覧を取得 |
| 10 | ブランド一覧取得 | 補助機能 | CatalogSearchでブランドフィルタリング用一覧を取得 |
| 60 | HybridAppカタログ | 主機能 | MAUI Blazor Hybrid用カタログ表示機能 |
| 61 | HybridApp商品詳細 | 遷移先機能 | CatalogListItemクリックで商品詳細画面へ遷移 |

## 画面種別

一覧

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/` |
| ルート定義 | `@page "/"` |
| 認証要件 | 不要 |

## 入出力項目

### クエリパラメータ（入力）

| 項目名 | 論理名 | データ型 | 必須 | デフォルト値 | 説明 |
|--------|--------|----------|------|--------------|------|
| page | ページ番号 | int? | いいえ | 1 | 表示するページ番号 |
| brand | ブランドID | int? | いいえ | null（全件） | フィルタリング用ブランドID |
| type | タイプID | int? | いいえ | null（全件） | フィルタリング用商品タイプID |

## 表示項目

### ページヘッダー

| 項目名 | 論理名 | 値 | 説明 |
|--------|--------|-----|------|
| page-header-title | ヘッダータイトル | "Ready for a new adventure?" | メインキャッチコピー |
| page-header-subtitle | ヘッダーサブタイトル | "Start the season with the latest in clothing and equipment." | サブキャッチコピー |

### 商品一覧（CatalogListItem）

| 項目名 | 論理名 | データ型 | 説明 |
|--------|--------|----------|------|
| Item.Name | 商品名 | string | 商品の名前 |
| Item.Price | 価格 | decimal | 商品価格（$表記、小数点以下2桁） |
| ProductImages.GetProductImageUrl(Item.Id) | 商品画像 | string | 商品画像のURL |

### フィルタ（CatalogSearch）

| 項目名 | 論理名 | データ型 | 説明 |
|--------|--------|----------|------|
| catalogBrands | ブランド一覧 | IEnumerable<CatalogBrand> | フィルタリング用ブランド選択肢 |
| catalogItemTypes | タイプ一覧 | IEnumerable<CatalogItemType> | フィルタリング用タイプ選択肢 |

### ページネーション

| 項目名 | 論理名 | データ型 | 説明 |
|--------|--------|----------|------|
| pageIndex | ページインデックス | int | 現在表示中のページ（1始まり） |
| visiblePageIndexes | 表示ページ番号 | IEnumerable<int> | 表示するページリンク一覧 |

## イベント仕様

### 1-パラメータ変更時（OnParametersSetAsync）

**トリガー**：ページアクセス時、またはクエリパラメータ変更時

**処理フロー**：
1. Page、BrandId、ItemTypeIdパラメータを取得
2. CatalogService.GetCatalogItemsを呼び出し
3. catalogResultを更新し画面を再描画

**データの流れ**：
```
クエリパラメータ → CatalogService.GetCatalogItems(pageIndex, pageSize, brand, type)
                          │
                          ▼
                   GET /api/catalog/items?... (Mobile BFF)
                          │
                          ▼
                   catalogResult → 画面表示
```

### 2-フィルタ選択（CatalogSearch）

**トリガー**：ブランドまたはタイプのフィルタタグクリック

**処理フロー**：
1. NavigationManagerでクエリパラメータを更新
2. URLが変更されOnParametersSetAsyncが再実行
3. 新しいフィルタ条件で商品一覧を再取得

### 3-ページリンク押下

**トリガー**：ページ番号リンクのクリック

**処理フロー**：
1. NavigationManager.GetUriWithQueryParameterでpageパラメータを更新
2. URLが変更されOnParametersSetAsyncが再実行
3. 指定ページの商品一覧を取得

### 4-商品選択（CatalogListItem）

**トリガー**：商品カードのクリック

**処理フロー**：
1. ItemHelper.Url(Item)で商品詳細URLを生成
2. /item/{itemId}へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | Catalog | SELECT | 商品一覧取得（API経由） |
| フィルタ選択 | CatalogBrand, CatalogType | SELECT | ブランド・タイプ一覧取得（API経由） |

### 備考

HybridAppアプリケーションはデータベースに直接アクセスせず、Mobile BFF（localhost:11632）のAPIを通じてデータを取得する。実際のデータベースアクセスはCatalog.API側で実行される。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 情報 | Loading... | catalogResultがnullの場合 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| HttpRequestException | Mobile BFFへの接続失敗 | 画面にLoadingが表示され続ける |
| JsonException | APIレスポンスのパースエラー | 例外がスローされる |

## 備考

- ページサイズは9件固定（PageSize = 9）
- Mobile BFFのベースURLはMauiProgram.MobileBffHostで定義（Android: 10.0.2.2:11632, その他: localhost:11632）
- カート機能は未実装（コメントアウトされている）
- WebAppのカタログ画面と同様のUIコンポーネントを使用するが、HybridApp専用のCatalogSearchを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面で扱うデータモデルの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CatalogItem.cs | `src/WebAppComponents/Catalog/CatalogItem.cs` | 商品データ構造（Id, Name, Price, Description等） |
| 1-2 | CatalogItem.cs | `src/WebAppComponents/Catalog/CatalogItem.cs` | CatalogResult, CatalogBrand, CatalogItemTypeのレコード定義 |

**読解のコツ**: C#のrecord型を使用しており、イミュータブルなデータ構造であることを理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるRazorページを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Catalog.razor | `src/HybridApp/Components/Pages/Catalog/Catalog.razor` | ページ構成とデータ取得ロジック |

**主要処理フロー**:
1. **1行目**: @page "/"でルート定義
2. **3行目**: CatalogServiceの依存性注入
3. **10行目**: CatalogSearchコンポーネントの埋め込み
4. **19-24行目**: @foreachで商品一覧をループ表示
5. **26-31行目**: ページネーションリンクの生成
6. **53-60行目**: OnParametersSetAsyncでデータ取得

#### Step 3: フィルタリング機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CatalogSearch.razor | `src/HybridApp/Components/Pages/Catalog/CatalogSearch.razor` | フィルタUIとナビゲーション処理 |

**主要処理フロー**:
- **55-62行目**: OnInitializedAsyncでブランド・タイプ一覧を並列取得
- **64-75行目**: BrandUri/TypeUriでクエリパラメータ付きURLを生成

#### Step 4: 商品一覧表示機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CatalogListItem.razor | `src/WebAppComponents/Catalog/CatalogListItem.razor` | 商品カードの表示とリンク生成 |

**主要処理フロー**:
- **5行目**: ItemHelper.Url(Item)で詳細ページURLを生成
- **7行目**: ProductImages.GetProductImageUrl(Item)で画像URLを取得

#### Step 5: APIクライアントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | CatalogService.cs | `src/HybridApp/Services/CatalogService.cs` | Mobile BFFへのAPI呼び出し |
| 5-2 | MauiProgram.cs | `src/HybridApp/MauiProgram.cs` | HttpClientとベースURL設定 |

**主要処理フロー**:
- **19-24行目（CatalogService.cs）**: GetCatalogItemsでページネーション付き商品一覧取得
- **40-45行目（CatalogService.cs）**: GetBrandsでブランド一覧取得
- **47-52行目（CatalogService.cs）**: GetTypesでタイプ一覧取得
- **9行目（MauiProgram.cs）**: MobileBffHostの定義（プラットフォーム別URL）

### プログラム呼び出し階層図

```
Catalog.razor (/)
    │
    ├─ CatalogSearch.razor
    │      │
    │      ├─ CatalogService.GetBrands()
    │      │      └─ GET /api/catalog/catalogBrands
    │      │
    │      └─ CatalogService.GetTypes()
    │             └─ GET /api/catalog/catalogTypes
    │
    ├─ OnParametersSetAsync()
    │      └─ CatalogService.GetCatalogItems(page, size, brand, type)
    │             └─ GET /api/catalog/items?pageIndex=...&pageSize=...
    │
    └─ CatalogListItem.razor (foreach)
           │
           ├─ ItemHelper.Url(Item) → /item/{itemId}
           │
           └─ ProductImages.GetProductImageUrl(Item.Id)
                  └─ {MobileBffHost}/api/catalog/items/{id}/pic
```

### データフロー図

```
[入力]                     [処理]                           [出力]

クエリパラメータ ────────▶ OnParametersSetAsync
(?page, ?brand, ?type)          │
                                ▼
                    CatalogService.GetCatalogItems()
                                │
                                ▼
                    GET /api/catalog/items (Mobile BFF)
                                │
                                ▼
                          CatalogResult
                                │
                    ┌───────────┼───────────┐
                    ▼           ▼           ▼
              catalogResult.Data   Count    PageIndex
                    │           │           │
                    ▼           ▼           ▼
              CatalogListItem  ページ数計算  ページネーション
              (foreach表示)                 リンク生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Catalog.razor | `src/HybridApp/Components/Pages/Catalog/Catalog.razor` | ソース | カタログ画面メインページ |
| CatalogSearch.razor | `src/HybridApp/Components/Pages/Catalog/CatalogSearch.razor` | ソース | フィルタコンポーネント |
| CatalogListItem.razor | `src/WebAppComponents/Catalog/CatalogListItem.razor` | ソース | 商品カードコンポーネント（共有） |
| CatalogService.cs | `src/HybridApp/Services/CatalogService.cs` | ソース | APIクライアント |
| CatalogItem.cs | `src/WebAppComponents/Catalog/CatalogItem.cs` | ソース | データモデル定義 |
| ProductImageUrlProvider.cs | `src/HybridApp/Services/ProductImageUrlProvider.cs` | ソース | 画像URL生成 |
| MauiProgram.cs | `src/HybridApp/MauiProgram.cs` | ソース | アプリケーション起動・DI設定 |
| MainLayout.razor | `src/HybridApp/Components/Layout/MainLayout.razor` | ソース | レイアウト定義 |
