# 画面設計書 3-カート画面

## 概要

本ドキュメントは、eShop WebAppのカート画面（Shopping Bag）の設計仕様を定義する。ショッピングカートの内容一覧表示、数量変更、合計金額計算、チェックアウトへの遷移機能を提供する画面である。

### 本画面の処理概要

カート画面は、ユーザーがショッピングカートに追加した商品の一覧を表示し、数量変更や購入手続きへの遷移を行うための重要な画面である。

**業務上の目的・背景**：ECサイトにおいて、顧客が購入予定の商品を確認・調整し、最終的な購入手続きへ進むための中間ステップとして機能する。カート内商品の数量変更や削除（数量0設定）により、購入内容の調整を可能にし、合計金額を明示することで購入判断を支援する。

**画面へのアクセス方法**：商品詳細画面の「shopping bag」リンク、ヘッダーのカートアイコン、または直接URL（/cart）にアクセスする。本画面は認証必須（[Authorize]属性）であり、未ログイン時はログイン画面へリダイレクトされる。

**主要な操作・処理内容**：
1. カート内商品一覧の閲覧：商品画像、商品名、単価、数量、小計を確認できる
2. 数量変更：各商品の数量を変更し「Update」ボタンで反映する
3. 商品削除：数量を0に設定して更新することで商品を削除する
4. 合計金額の確認：カート内全商品の合計金額と総数量を確認する
5. チェックアウトへの遷移：「Check out」ボタンでチェックアウト画面へ進む
6. 買い物を続ける：「Continue shopping」リンクでカタログ画面へ戻る

**画面遷移**：
- 遷移元：商品詳細画面（shopping bagリンク）、ヘッダーナビゲーション
- 遷移先：チェックアウト画面（Check outボタン）、カタログ画面（Continue shoppingリンク）

**権限による表示制御**：本画面は認証必須であり、未ログインユーザーはアクセス時に自動的にログイン画面へリダイレクトされる。認証済みユーザーのみがカート内容を閲覧・操作可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | かご取得 | 主機能 | BasketState.GetBasketItemsAsyncでカート内容一覧を取得 |
| 15 | かご更新 | API連携 | UpdateQuantityAsyncでBasketState.SetQuantityAsyncを呼び出し数量変更 |
| 4 | 商品画像取得 | 補助機能 | IProductImageUrlProviderで商品画像URLを取得 |
| 43 | 買い物かご画面 | 主機能 | カート内容表示・数量変更・合計金額計算のUI機能 |
| 44 | チェックアウト画面 | 遷移先機能 | Check outボタンでチェックアウト画面へ遷移 |

## 画面種別

一覧

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/cart` |
| ルートパラメータ | なし |
| クエリパラメータ | なし |
| 認証 | 必須（[Authorize]属性） |

## 入出力項目

### 入力項目（フォームパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| 更新対象商品ID | UpdateQuantityId | int? | 数量更新時必須 | 数量変更対象の商品ID |
| 更新数量 | UpdateQuantityValue | int? | 数量更新時必須 | 変更後の数量（0で削除） |

### 出力項目（API取得データ）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| カート内商品一覧 | IReadOnlyCollection\<BasketItem\> | カート内の商品リスト |
| 合計金額 | decimal | 全商品の合計金額 |
| 合計数量 | decimal | 全商品の合計数量 |

## 表示項目

### カート商品行

| 項目名 | データソース | 表示形式 | 備考 |
|--------|-------------|---------|------|
| 商品画像 | ProductImages.GetProductImageUrl(ProductId) | img要素 | alt属性に商品名 |
| 商品名 | BasketItem.ProductName | テキスト | nameクラス |
| 単価 | BasketItem.UnitPrice | 通貨形式（$0.00） | priceクラス |
| 数量 | BasketItem.Quantity | 数値入力フィールド | min=0 |
| 小計 | UnitPrice × Quantity | 通貨形式（$0.00） | 動的計算 |

### カートサマリー

| 項目名 | データソース | 表示形式 | 備考 |
|--------|-------------|---------|------|
| 商品数バッジ | TotalQuantity | バッジ（filter-badge） | |
| 合計金額 | TotalPrice | 通貨形式（$0.00） | |

### 空カート表示

| 項目名 | 条件 | 表示内容 | 備考 |
|--------|------|---------|------|
| 空メッセージ | basketItems.Count == 0 | "Your shopping bag is empty." | Continue shoppingリンク付き |

## イベント仕様

### 1-数量更新（Updateボタンクリック）

「Update」ボタンをクリックすると、該当商品の数量が更新される。

**トリガー**: formのsubmitイベント（name="update-cart"）
**処理内容**:
1. UpdateQuantityAsyncメソッドが呼び出される
2. Basket.SetQuantityAsync(id, quantity)でカート内数量を更新
3. 数量が0の場合、商品がカートから削除される
4. Basket.GetBasketItemsAsync()でカート内容を再取得
5. 画面が更新され、新しいカート内容と合計が表示される

**データの流れ**:
```
ユーザー → form submit → UpdateQuantityAsync
                            ↓
                      Basket.SetQuantityAsync(id, quantity)
                            ↓
                      BasketService.UpdateBasketAsync
                            ↓
                      Basket.GetBasketItemsAsync
                            ↓
                      basketItems更新 → 画面表示更新
```

### 2-チェックアウト遷移

「Check out」リンクをクリックすると、チェックアウト画面へ遷移する。

**トリガー**: aタグクリック（href="checkout"）
**遷移先**: `/checkout`

### 3-買い物を続ける遷移

「Continue shopping」リンクをクリックすると、カタログ画面へ戻る。

**トリガー**: aタグクリック（href=""）
**遷移先**: `/`（カタログ画面）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | Basket | SELECT | カート内容を取得（Redis経由） |
| 画面表示 | Catalog | SELECT | カート内商品の詳細情報を取得 |
| 数量更新 | Basket | UPDATE | カート内商品の数量を更新（Redis経由） |
| 商品削除（数量0） | Basket | DELETE | カートから商品を削除（Redis経由） |

### テーブル別更新項目詳細

#### Basket（Redis）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SELECT | ProductId, Quantity | BuyerId = {認証ユーザーID} | カート内全商品を取得 |
| UPDATE | Quantity | @UpdateQuantityValue | 指定商品の数量を更新 |
| DELETE | - | Quantity = 0の場合 | 商品をカートから削除 |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|--------------|
| ページタイトル | 常時 | "Shopping Bag \| AdventureWorks" |
| 読み込み中 | basketItemsがnullの間 | "Loading..." |
| 空カート | basketItems.Count == 0 | "Your shopping bag is empty. Continue shopping." |

## 例外処理

| 例外条件 | 挙動 | 備考 |
|---------|------|------|
| 未認証アクセス | ログイン画面へリダイレクト | [Authorize]属性による自動処理 |
| API通信エラー | 例外がスローされる | 上位でハンドリング |

## 備考

- StreamRendering属性が付与されており、サーバーサイドでの段階的レンダリングが有効
- Authorize属性により認証必須画面として動作
- 数量更新中はCurrentOrPendingQuantityメソッドにより、更新値が即座にUIに反映される（楽観的UI更新）
- 数量入力フィールドはmin="0"が設定されており、負の値は入力不可
- TotalPriceとTotalQuantityは計算プロパティとして実装されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面で扱うデータの構造を把握することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BasketItem.cs | `src/WebApp/Services/BasketItem.cs` | カート内商品の構造（ProductId, ProductName, UnitPrice, Quantity等） |

**読解のコツ**: BasketItemはカート内で管理する商品データで、CatalogItemから派生した情報を含む。

#### Step 2: エントリーポイントを理解する

処理の起点となるRazorページを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CartPage.razor | `src/WebApp/Components/Pages/Cart/CartPage.razor` | ルーティング（/cart）、Authorize属性、カート表示・更新ロジック |

**主要処理フロー**:
1. **行1**: `@page "/cart"` - URLルーティング
2. **行6**: `@attribute [Authorize]` - 認証必須設定
3. **行94-97**: `OnInitializedAsync` - カート内容取得
4. **行99-100**: `TotalPrice`, `TotalQuantity` - 計算プロパティ
5. **行104-107**: `CurrentOrPendingQuantity` - 楽観的UI更新のための数量表示
6. **行109-115**: `UpdateQuantityAsync` - 数量更新処理

#### Step 3: カート状態管理を理解する

BasketStateによるカート管理の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BasketState.cs | `src/WebApp/Services/BasketState.cs` | GetBasketItemsAsync、SetQuantityAsyncの実装 |

**主要処理フロー**:
- **行21-24**: `GetBasketItemsAsync` - 認証済みの場合のみカート内容を取得
- **行58-76**: `SetQuantityAsync` - 数量更新（quantity > 0で更新、= 0で削除）
- **行117-148**: `FetchBasketItemsAsync` - BasketServiceとCatalogServiceを組み合わせてBasketItem生成

#### Step 4: フォーム処理を理解する

Blazorのフォーム処理パターンを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CartPage.razor | `src/WebApp/Components/Pages/Cart/CartPage.razor` | SupplyParameterFromForm属性、@formname、@onsubmit |

**主要処理フロー**:
- **行42-52**: 各商品行のフォーム（data-enhance付き）
- **行83**: 空のformタグでsubmitハンドラを定義（@formname="update-cart"）
- **行88-92**: `[SupplyParameterFromForm]`でフォーム値をバインド

### プログラム呼び出し階層図

```
CartPage.razor (ページコンポーネント)
    │
    ├─ OnInitializedAsync
    │      └─ Basket.GetBasketItemsAsync()
    │             └─ FetchBasketItemsAsync()
    │                    ├─ BasketService.GetBasketAsync()
    │                    └─ CatalogService.GetCatalogItems(ids)
    │
    ├─ UpdateQuantityAsync (フォームsubmit)
    │      ├─ Basket.SetQuantityAsync(id, quantity)
    │      │      └─ BasketService.UpdateBasketAsync()
    │      └─ Basket.GetBasketItemsAsync()
    │
    └─ ProductImages.GetProductImageUrl(productId)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

                          CartPage.razor
認証ユーザー ─────────────┬─ OnInitializedAsync
                          │      │
                          │      └─ BasketState ─────────▶ basketItems (カート一覧)
                          │
フォーム送信              │
 - UpdateQuantityId ──────┼─ UpdateQuantityAsync
 - UpdateQuantityValue ───┘      │
                                 ├─ SetQuantityAsync ────▶ カート更新
                                 │
                                 └─ GetBasketItemsAsync ─▶ basketItems更新

計算プロパティ ───────────────────────────────────────────▶ TotalPrice, TotalQuantity
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CartPage.razor | `src/WebApp/Components/Pages/Cart/CartPage.razor` | ソース | カート画面のメインページコンポーネント |
| BasketItem.cs | `src/WebApp/Services/BasketItem.cs` | ソース | カート内商品データモデル定義 |
| BasketState.cs | `src/WebApp/Services/BasketState.cs` | ソース | カート状態管理の実装 |
| BasketService.cs | `src/WebApp/Services/BasketService.cs` | ソース | バスケットAPI通信サービス |
| CatalogService.cs | `src/WebAppComponents/Services/CatalogService.cs` | ソース | カタログAPI通信サービス |
| IProductImageUrlProvider.cs | `src/WebAppComponents/Services/IProductImageUrlProvider.cs` | ソース | 商品画像URL取得インターフェース |
