# 画面設計書 4-チェックアウト画面

## 概要

本ドキュメントは、eShop WebAppのチェックアウト画面の設計仕様を定義する。配送先住所入力フォームを提供し、注文確定処理を実行する画面である。

### 本画面の処理概要

チェックアウト画面は、カート内の商品を購入するための最終確認・注文確定を行う重要な画面である。

**業務上の目的・背景**：ECサイトにおける購入フローの最終段階として、顧客が配送先住所を入力し、注文を確定するための画面である。住所情報はユーザーの認証情報（クレーム）から事前入力され、入力の手間を軽減している。注文確定後は注文履歴画面へ遷移し、注文が正常に処理されたことを確認できる。

**画面へのアクセス方法**：カート画面の「Check out」ボタンをクリックするか、直接URL（/checkout）にアクセスする。本画面は認証必須（[Authorize]属性）であり、未ログイン時はログイン画面へリダイレクトされる。

**主要な操作・処理内容**：
1. 配送先住所の入力：住所（Street）、市区町村（City）、州/県（State）、郵便番号（Zip code）、国（Country）を入力
2. 住所の自動入力：ユーザーのクレーム情報から住所が事前入力される
3. 入力検証：必須項目のバリデーション、カート空チェック
4. 注文確定：「Place order」ボタンで注文を作成し、カートをクリア
5. カートへ戻る：「Back to the shopping bag」リンクでカート画面へ戻る

**画面遷移**：
- 遷移元：カート画面（Check outボタン）
- 遷移先：注文履歴画面（注文確定後）、カート画面（Back to the shopping bagリンク）

**権限による表示制御**：本画面は認証必須であり、未ログインユーザーはアクセス時に自動的にログイン画面へリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | 注文作成 | 主機能 | BasketState.CheckoutAsyncで注文を作成 |
| 14 | かご取得 | 補助機能 | カート内容の存在確認（空チェック） |
| 16 | かご削除 | 補助機能 | 注文完了後にBasketState.DeleteBasketAsyncでカート削除 |
| 44 | チェックアウト画面 | 主機能 | 配送先住所入力・注文確定のUI機能 |
| 45 | 注文履歴画面 | 遷移先機能 | 注文確定後にuser/ordersへリダイレクト |

## 画面種別

登録

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/checkout` |
| ルートパラメータ | なし |
| クエリパラメータ | なし |
| 認証 | 必須（[Authorize]属性） |

## 入出力項目

### 入力項目（フォームパラメータ）

| 項目名 | プロパティ名 | 型 | 必須 | バリデーション | 説明 |
|--------|-------------|-----|------|--------------|------|
| 住所 | Street | string | 必須 | [Required] | 配送先の番地・通り |
| 市区町村 | City | string | 必須 | [Required] | 配送先の市区町村 |
| 州/県 | State | string | 必須 | [Required] | 配送先の州または県 |
| 郵便番号 | ZipCode | string | 必須 | [Required] | 配送先の郵便番号 |
| 国 | Country | string | 必須 | [Required] | 配送先の国 |

### 内部データ（非表示フィールド）

| 項目名 | プロパティ名 | 型 | 説明 |
|--------|-------------|-----|------|
| リクエストID | RequestId | Guid | 二重注文防止用の一意識別子 |
| カードタイプID | CardTypeId | int | 固定値（1） |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| バリデーションメッセージ | string | 入力エラーの内容 |
| カート空エラー | string | カートが空の場合のエラーメッセージ |

## 表示項目

### 配送先住所フォーム

| 項目名 | 入力タイプ | 初期値 | 備考 |
|--------|---------|--------|------|
| Address | InputText | クレーム「address_street」 | 必須入力 |
| City | InputText | クレーム「address_city」 | 必須入力 |
| State | InputText | クレーム「address_state」 | 必須入力 |
| Zip code | InputText | クレーム「address_zip_code」 | 必須入力 |
| Country | InputText | クレーム「address_country」 | 必須入力 |

### アクションボタン

| 項目名 | タイプ | 遷移先/動作 | 備考 |
|--------|------|------------|------|
| Back to the shopping bag | リンク | /cart | 矢印アイコン付き |
| Place order | 送信ボタン | 注文処理実行 | プライマリボタン |

## イベント仕様

### 1-注文確定（Place orderボタンクリック）

「Place order」ボタンをクリックすると、注文が作成される。

**トリガー**: EditFormのOnSubmitイベント
**処理内容**:
1. HandleSubmitAsyncメソッドが呼び出される
2. PerformCustomValidationAsyncでカスタムバリデーション実行
   - カートが空の場合、エラーメッセージを追加
3. editContext.Validate()で標準バリデーション実行
4. バリデーション成功時、HandleValidSubmitAsyncを実行
   - CardTypeIdを1に設定
   - Basket.CheckoutAsync(Info)で注文作成
   - Nav.NavigateTo("user/orders")で注文履歴画面へ遷移

**データの流れ**:
```
ユーザー → Place order → HandleSubmitAsync
                            ↓
                      PerformCustomValidationAsync
                            ↓ (カート空チェック)
                      editContext.Validate()
                            ↓ (フォームバリデーション)
                      HandleValidSubmitAsync
                            ↓
                      Basket.CheckoutAsync
                            ├─ OrderingService.CreateOrder
                            └─ Basket.DeleteBasketAsync
                            ↓
                      Nav.NavigateTo("user/orders")
```

### 2-カート画面への戻り

「Back to the shopping bag」リンクをクリックすると、カート画面へ戻る。

**トリガー**: aタグクリック（href="cart"）
**遷移先**: `/cart`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| バリデーション | Basket | SELECT | カート内容の存在確認（Redis経由） |
| 注文確定 | Orders | INSERT | 注文を作成（Ordering.API経由） |
| 注文確定 | OrderItems | INSERT | 注文明細を作成（Ordering.API経由） |
| 注文確定 | Basket | DELETE | カートをクリア（Redis経由） |

### テーブル別更新項目詳細

#### Orders（Ordering.API経由）

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|--------|------|
| INSERT | UserId | 認証ユーザーID | |
| INSERT | UserName | 認証ユーザー名 | |
| INSERT | City | @Info.City | |
| INSERT | Street | @Info.Street | |
| INSERT | State | @Info.State | |
| INSERT | Country | @Info.Country | |
| INSERT | ZipCode | @Info.ZipCode | |

#### Basket（Redis）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SELECT | ProductId, Quantity | BuyerId = {認証ユーザーID} | 空チェック用 |
| DELETE | - | BuyerId = {認証ユーザーID} | 注文確定後にカートクリア |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|--------------|
| ページタイトル | 常時 | "Checkout \| AdventureWorks" |
| バリデーションエラー | 必須項目未入力 | "The {項目名} field is required." |
| カート空エラー | カート内商品0件 | "Your cart is empty" |

## 例外処理

| 例外条件 | 挙動 | 備考 |
|---------|------|------|
| 未認証アクセス | ログイン画面へリダイレクト | [Authorize]属性による自動処理 |
| カート空状態 | バリデーションエラー表示 | ValidationSummaryに表示 |
| API通信エラー | 例外がスローされる | 上位でハンドリング |

## 備考

- フォームにはEnhance属性が付与されており、Blazor拡張フォームとして動作
- DataAnnotationsValidatorによる標準バリデーションとカスタムバリデーション（カート空チェック）を併用
- 住所情報はユーザーのクレームから事前入力される（address_street, address_city等）
- RequestIdはGuidとして生成され、二重注文防止に使用される
- CardTypeIdは固定値1が設定される（支払い方法の詳細は省略されている）
- カード情報（CardNumber等）はコード上ハードコーディングされたテスト値が使用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面で扱うデータの構造を把握することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BasketCheckoutInfo.cs | `src/WebApp/Services/BasketCheckoutInfo.cs` | チェックアウト情報の構造（Street, City, State等）とバリデーション属性 |
| 1-2 | OrderingService.cs | `src/WebApp/Services/OrderingService.cs` | CreateOrderRequestとOrderRecordの構造 |

**読解のコツ**: BasketCheckoutInfoは[Required]属性によるバリデーションが設定されている。カード情報のプロパティは存在するが、本画面では使用されない。

#### Step 2: エントリーポイントを理解する

処理の起点となるRazorページを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Checkout.razor | `src/WebApp/Components/Pages/Checkout/Checkout.razor` | ルーティング、EditForm、バリデーション、注文確定処理 |

**主要処理フロー**:
1. **行1**: `@page "/checkout"` - URLルーティング
2. **行6**: `@attribute [Authorize]` - 認証必須設定
3. **行12**: `<EditForm>` - Blazorフォームコンポーネント
4. **行74-83**: `OnInitialized` - フォーム初期化、クレームからの住所事前入力
5. **行101-109**: `HandleSubmitAsync` - フォーム送信処理
6. **行111-116**: `HandleValidSubmitAsync` - 注文作成・画面遷移
7. **行118-125**: `PerformCustomValidationAsync` - カート空チェック

#### Step 3: バスケット状態管理を理解する

注文作成処理の詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BasketState.cs | `src/WebApp/Services/BasketState.cs` | CheckoutAsyncの実装（注文作成、カート削除） |

**主要処理フロー**:
- **行78-109**: `CheckoutAsync`
  - RequestIdの設定（未設定時は新規生成）
  - buyerId、userNameの取得
  - カート内商品の取得
  - CreateOrderRequestの生成
  - OrderingService.CreateOrderの呼び出し
  - DeleteBasketAsyncでカートクリア

#### Step 4: 注文サービスを理解する

注文APIとの通信処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | OrderingService.cs | `src/WebApp/Services/OrderingService.cs` | CreateOrderメソッド、HTTPリクエスト構築 |

**主要処理フロー**:
- **行12-18**: `CreateOrder`
  - POST /api/Orders/へリクエスト
  - x-requestidヘッダーでリクエストIDを送信

### プログラム呼び出し階層図

```
Checkout.razor (ページコンポーネント)
    │
    ├─ OnInitialized
    │      └─ PopulateFormWithDefaultInfo()
    │             └─ HttpContext.User.Claims (クレーム読み取り)
    │
    └─ HandleSubmitAsync (フォーム送信)
           ├─ PerformCustomValidationAsync()
           │      └─ Basket.GetBasketItemsAsync()
           │
           ├─ editContext.Validate()
           │
           └─ HandleValidSubmitAsync()
                  ├─ Basket.CheckoutAsync(Info)
                  │      ├─ FetchBasketItemsAsync()
                  │      ├─ OrderingService.CreateOrder() → POST /api/Orders/
                  │      └─ DeleteBasketAsync()
                  │
                  └─ Nav.NavigateTo("user/orders")
```

### データフロー図

```
[入力]                    [処理]                           [出力]

HttpContext.User.Claims
 - address_street ─────┐
 - address_city ───────┤
 - address_state ──────┼─ PopulateFormWithDefaultInfo ──▶ Info (事前入力)
 - address_country ────┤
 - address_zip_code ───┘

フォーム入力
 - Street ─────────────┐
 - City ───────────────┤
 - State ──────────────┼─ HandleSubmitAsync
 - ZipCode ────────────┤      │
 - Country ────────────┘      ├─ Validate ───────────────▶ ValidationMessage
                              │
                              └─ CheckoutAsync
                                    │
                                    ├─ CreateOrder ───────▶ Orders (INSERT)
                                    │
                                    └─ DeleteBasket ──────▶ Basket (DELETE)

                              Nav.NavigateTo ─────────────▶ 注文履歴画面遷移
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Checkout.razor | `src/WebApp/Components/Pages/Checkout/Checkout.razor` | ソース | チェックアウト画面のメインページコンポーネント |
| BasketCheckoutInfo.cs | `src/WebApp/Services/BasketCheckoutInfo.cs` | ソース | チェックアウト情報データモデル |
| BasketState.cs | `src/WebApp/Services/BasketState.cs` | ソース | カート状態管理、CheckoutAsync実装 |
| OrderingService.cs | `src/WebApp/Services/OrderingService.cs` | ソース | 注文API通信サービス |
| BasketService.cs | `src/WebApp/Services/BasketService.cs` | ソース | バスケットAPI通信サービス |
