# 画面設計書 5-注文履歴画面

## 概要

本ドキュメントは、eShop WebAppの注文履歴画面の設計仕様を定義する。ユーザーの過去の注文履歴を一覧表示し、注文番号、日付、金額、ステータスを確認できる画面である。

### 本画面の処理概要

注文履歴画面は、ユーザーが過去に行った注文の履歴を確認するための画面である。リアルタイムでの注文ステータス更新通知機能を備えている。

**業務上の目的・背景**：ECサイトにおいて、顧客が過去の購入履歴を確認し、注文の処理状況を追跡するための画面である。注文確定後に自動的にこの画面へ遷移し、注文が正常に登録されたことを確認できる。また、リアルタイム通知機能により、注文ステータスの変更（出荷、配送完了等）を即座に反映する。

**画面へのアクセス方法**：チェックアウト画面からの注文確定後のリダイレクト、ヘッダーナビゲーション、または直接URL（/user/orders）にアクセスする。本画面は認証必須（[Authorize]属性）であり、未ログイン時はログイン画面へリダイレクトされる。

**主要な操作・処理内容**：
1. 注文履歴一覧の閲覧：注文番号、日付、合計金額、ステータスを一覧形式で確認
2. リアルタイム更新：OrderStatusNotificationServiceにより、注文ステータス変更時に自動更新
3. 買い物を続ける：カタログ画面へ戻る（ナビゲーション経由）

**画面遷移**：
- 遷移元：チェックアウト画面（注文確定後）、ヘッダーナビゲーション
- 遷移先：カタログ画面（買い物を続ける場合、ナビゲーション経由）

**権限による表示制御**：本画面は認証必須であり、未ログインユーザーはアクセス時に自動的にログイン画面へリダイレクトされる。表示される注文は、ログインユーザー自身の注文のみである。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | ユーザー注文履歴取得 | 主機能 | OrderingService.GetOrdersでユーザーの注文履歴を取得 |
| 45 | 注文履歴画面 | 主機能 | 注文一覧表示・リアルタイム更新のUI機能 |

## 画面種別

一覧

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/user/orders` |
| ルートパラメータ | なし |
| クエリパラメータ | なし |
| 認証 | 必須（[Authorize]属性） |

## 入出力項目

### 入力項目

なし（認証情報から自動的にユーザーを特定）

### 出力項目（API取得データ）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 注文一覧 | OrderRecord[] | ユーザーの注文履歴配列 |

## 表示項目

### 注文一覧ヘッダー

| 項目名 | CSSクラス | 備考 |
|--------|---------|------|
| Number | - | 注文番号 |
| Date | - | 注文日 |
| Total | total-header | 合計金額 |
| Status | - | 注文ステータス |

### 注文行

| 項目名 | データソース | 表示形式 | CSSクラス |
|--------|-------------|---------|---------|
| 注文番号 | OrderRecord.OrderNumber | 整数 | order-number |
| 注文日 | OrderRecord.Date | 日時 | order-date |
| 合計金額 | OrderRecord.Total | 通貨形式（$0.00） | order-total |
| ステータス | OrderRecord.Status | テキスト（バッジ） | order-status, status, {Status.ToLower()} |

### 空注文表示

| 項目名 | 条件 | 表示内容 | 備考 |
|--------|------|---------|------|
| 空メッセージ | orders.Length == 0 | "You haven't yet placed any orders." | |

## イベント仕様

### 1-画面初期表示

画面表示時に注文履歴を取得する。

**トリガー**: OnInitializedAsync
**処理内容**:
1. OrderingService.GetOrders()を呼び出し
2. 取得した注文一覧をorders変数に格納
3. 画面がレンダリングされる

### 2-注文ステータス変更通知

バックエンドで注文ステータスが変更された際、画面が自動更新される。

**トリガー**: OrderStatusNotificationService.SubscribeToOrderStatusNotifications
**処理内容**:
1. OrdersRefreshOnStatusChangeコンポーネントがOnAfterRenderAsyncで購読開始
2. buyerIdを取得し、通知サービスに登録
3. ステータス変更通知を受信するとHandleOrderStatusChangedが呼び出される
4. Nav.Refresh()で画面全体を再読み込み

**データの流れ**:
```
バックエンド → OrderStatusNotificationService
                     ↓ (通知)
              HandleOrderStatusChanged
                     ↓
              Nav.Refresh()
                     ↓
              OnInitializedAsync (再実行)
                     ↓
              OrderingService.GetOrders()
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | Orders | SELECT | ユーザーの注文履歴を取得（Ordering.API経由） |

※ 本画面はデータ参照のみであり、INSERT/UPDATE/DELETE操作は発生しない

### テーブル別更新項目詳細

#### Orders（Ordering.API経由、参照のみ）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|---------|------|
| SELECT | OrderNumber, Date, Status, Total | UserId = {認証ユーザーID} | API側でフィルタリング |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|--------------|
| ページタイトル | 常時 | "Orders \| AdventureWorks" |
| 読み込み中 | ordersがnullの間 | "Loading..." |
| 注文なし | orders.Length == 0 | "You haven't yet placed any orders." |

## 例外処理

| 例外条件 | 挙動 | 備考 |
|---------|------|------|
| 未認証アクセス | ログイン画面へリダイレクト | [Authorize]属性による自動処理 |
| API通信エラー | 例外がスローされる | 上位でハンドリング |
| リフレッシュ時例外 | DispatchExceptionAsyncで処理 | 回路を維持しつつエラー処理 |

## 備考

- StreamRendering属性が付与されており、サーバーサイドでの段階的レンダリングが有効
- Authorize属性により認証必須画面として動作
- OrdersRefreshOnStatusChangeコンポーネントはInteractiveServerモードで動作し、リアルタイム通知を受信
- ステータス表示には動的CSSクラス（status.ToLower()）が適用され、ステータスに応じたスタイリングが可能
- IDisposableを実装し、コンポーネント破棄時に通知購読を解除

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面で扱うデータの構造を把握することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OrderingService.cs | `src/WebApp/Services/OrderingService.cs` | OrderRecordの構造（OrderNumber, Date, Status, Total） |

**読解のコツ**: OrderRecordはrecord型で定義され、注文の基本情報のみを保持。注文明細は含まれない。

#### Step 2: エントリーポイントを理解する

処理の起点となるRazorページを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Orders.razor | `src/WebApp/Components/Pages/User/Orders.razor` | ルーティング、注文一覧取得、表示ロジック |

**主要処理フロー**:
1. **行1**: `@page "/user/orders"` - URLルーティング
2. **行2**: `@attribute [Authorize]` - 認証必須設定
3. **行3**: `@attribute [StreamRendering]` - 段階的レンダリング
4. **行8**: `<OrdersRefreshOnStatusChange />` - リアルタイム更新コンポーネント
5. **行54-57**: `OnInitializedAsync` - 注文履歴取得
6. **行28-46**: 注文一覧のレンダリング

#### Step 3: リアルタイム更新機能を理解する

注文ステータス変更通知の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OrdersRefreshOnStatusChange.razor | `src/WebApp/Components/Pages/User/OrdersRefreshOnStatusChange.razor` | 通知購読、画面リフレッシュ |

**主要処理フロー**:
- **行2**: `@rendermode InteractiveServer` - インタラクティブモード
- **行10-21**: `OnAfterRenderAsync` - 初回レンダリング時に通知購読開始
- **行14**: `GetBuyerIdAsync` - ユーザーID取得
- **行17-18**: `SubscribeToOrderStatusNotifications` - 通知購読
- **行23-35**: `HandleOrderStatusChanged` - ステータス変更時のリフレッシュ
- **行37-40**: `Dispose` - 購読解除

#### Step 4: サービス層を理解する

注文APIとの通信処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | OrderingService.cs | `src/WebApp/Services/OrderingService.cs` | GetOrdersメソッド、APIエンドポイント |

**主要処理フロー**:
- **行7-10**: `GetOrders` - GET /api/Orders/で注文一覧取得

### プログラム呼び出し階層図

```
Orders.razor (ページコンポーネント)
    │
    ├─ OnInitializedAsync
    │      └─ OrderingService.GetOrders() → GET /api/Orders/
    │
    └─ OrdersRefreshOnStatusChange.razor (子コンポーネント)
           │
           ├─ OnAfterRenderAsync
           │      ├─ AuthenticationStateProvider.GetBuyerIdAsync()
           │      └─ OrderStatusNotificationService.SubscribeToOrderStatusNotifications()
           │
           ├─ HandleOrderStatusChanged
           │      └─ Nav.Refresh()
           │
           └─ Dispose
                  └─ orderStatusChangedSubscription.Dispose()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

                          Orders.razor
認証ユーザー ─────────────┬─ OnInitializedAsync
                          │      │
                          │      └─ OrderingService.GetOrders()
                          │             │
                          │             └─ GET /api/Orders/ ─────▶ orders配列
                          │
                          │                                        ▼
                          │                                   注文一覧表示
                          │
                          └─ OrdersRefreshOnStatusChange
                                 │
バックエンド通知 ─────────────────┼─ HandleOrderStatusChanged
                                 │      │
                                 │      └─ Nav.Refresh() ───────▶ 画面再読み込み
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Orders.razor | `src/WebApp/Components/Pages/User/Orders.razor` | ソース | 注文履歴画面のメインページコンポーネント |
| OrdersRefreshOnStatusChange.razor | `src/WebApp/Components/Pages/User/OrdersRefreshOnStatusChange.razor` | ソース | リアルタイム更新コンポーネント |
| OrderingService.cs | `src/WebApp/Services/OrderingService.cs` | ソース | 注文API通信サービス |
| OrderStatusNotificationService | - | サービス | 注文ステータス変更通知サービス |
