# 画面設計書 6-ログイン画面

## 概要

本ドキュメントは、eShop WebAppのログイン画面（エントリーポイント）の設計仕様を定義する。この画面はログイン処理のエントリーポイントとして機能し、Identity APIへのリダイレクト後に元のページへ戻る役割を担う。

### 本画面の処理概要

ログイン画面は、WebAppにおけるログインフローの中継点として機能する。直接的なログインフォームは提供せず、[Authorize]属性によりIdentity.APIの認証画面へ自動リダイレクトし、認証成功後に元のページへ戻る。

**業務上の目的・背景**：ECサイトにおいて、認証が必要な操作（カート追加、チェックアウト等）を行う際のログインフローを統一的に管理するためのエントリーポイントである。OpenID Connect/OAuth2のフローに従い、Identity.APIに認証処理を委譲し、認証成功後にユーザーを元の画面へ戻すことで、シームレスな認証体験を提供する。

**画面へのアクセス方法**：商品詳細画面の「Log in to purchase」ボタン、または認証が必要な画面への未認証アクセス時に自動的にこの画面経由でIdentity.APIへリダイレクトされる。

**主要な操作・処理内容**：
1. 認証チェック：[Authorize]属性により、未認証の場合はIdentity.APIへリダイレクト
2. リダイレクト先の保存：ReturnUrlパラメータで元のページのURLを保持
3. 認証後のリダイレクト：認証成功後、OnInitializedAsyncでReturnUrlへナビゲート

**画面遷移**：
- 遷移元：商品詳細画面（未認証時のカート追加）、認証が必要な任意の画面
- 遷移先：Identity.APIログイン画面（認証前）、ReturnUrlで指定された元の画面（認証後）

**権限による表示制御**：本画面自体は[Authorize]属性が付与されており、未認証時はIdentity.APIへ自動リダイレクトされる。認証済みの場合は即座にReturnUrlへリダイレクトする。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ユーザーログイン | 遷移先機能 | Authorize属性によりIdentity.APIへリダイレクト |
| 47 | ログイン画面 | 主機能 | ログイン処理のエントリーポイント・リダイレクト処理 |

## 画面種別

リダイレクト

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/user/login` |
| ルートパラメータ | なし |
| クエリパラメータ | `returnUrl`: 認証後の戻り先URL（省略時は"/"） |
| 認証 | 必須（[Authorize]属性） |

## 入出力項目

### 入力項目（クエリパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| 戻りURL | returnUrl | string | 任意 | 認証成功後のリダイレクト先（省略時は"/"） |

### 出力項目

なし（リダイレクト処理のみ）

## 表示項目

本画面はUIを持たず、認証フローの中継点として機能する。

## イベント仕様

### 1-初期化時のリダイレクト（認証済みの場合）

OnInitializedAsyncで認証後のリダイレクト処理を行う。

**トリガー**: 画面初期化（認証済み状態でアクセス）
**処理内容**:
1. ReturnUrlを取得（省略時は"/"）
2. URLが絶対URIかどうかを判定
3. 絶対URIの場合は"/"へ、相対URIの場合はReturnUrlへナビゲート
4. セキュリティ対策として外部サイトへのオープンリダイレクトを防止

**データの流れ**:
```
ユーザー → /user/login?returnUrl=xxx
                ↓
        [Authorize]チェック
                ↓ (未認証)
        Identity.APIへリダイレクト
                ↓ (認証成功)
        /user/login?returnUrl=xxxに戻る
                ↓
        OnInitializedAsync
                ↓
        Nav.NavigateTo(returnUrl)
```

### 2-未認証時の自動リダイレクト

[Authorize]属性により、未認証の場合はIdentity.APIへ自動リダイレクトされる。

**トリガー**: 未認証状態でのアクセス
**処理内容**:
1. ASP.NET Coreの認証ミドルウェアが未認証を検知
2. OpenID Connect設定に基づきIdentity.APIの認証エンドポイントへリダイレクト
3. 認証成功後、本画面に戻りOnInitializedAsyncが実行される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面はデータベース操作を行わない |

## メッセージ仕様

本画面はUIを持たないため、メッセージ表示はない。

## 例外処理

| 例外条件 | 挙動 | 備考 |
|---------|------|------|
| 不正なReturnUrl（絶対URI） | "/"へリダイレクト | オープンリダイレクト攻撃対策 |

## 備考

- 本画面はログインフォームを持たず、認証フローの中継点として機能する
- [Authorize]属性によりASP.NET Coreの認証ミドルウェアが自動的にIdentity.APIへリダイレクトする
- ReturnUrlが絶対URI（外部サイト）の場合は"/"へリダイレクトし、オープンリダイレクト攻撃を防止
- Url静的メソッドは他のページからログインURLを生成する際に使用される
- Uri.EscapeDataStringでReturnUrlをエンコードし、クエリパラメータとして安全に渡す

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

処理の起点となるRazorページを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LogIn.razor | `src/WebApp/Components/Pages/User/LogIn.razor` | ルーティング、Authorize属性、リダイレクト処理 |

**主要処理フロー**:
1. **行1**: `@page "/user/login"` - URLルーティング
2. **行3**: `@attribute [Authorize]` - 認証必須、未認証時はIdentity.APIへリダイレクト
3. **行5-6**: `[SupplyParameterFromQuery] ReturnUrl` - クエリパラメータからReturnUrlを取得
4. **行11-17**: `OnInitializedAsync` - 認証後のリダイレクト処理
5. **行13**: `ReturnUrl ?? "/"` - ReturnUrl未指定時のデフォルト値
6. **行14**: `new Uri(returnUrl, UriKind.RelativeOrAbsolute)` - URI解析
7. **行15**: `url.IsAbsoluteUri ? "/" : returnUrl` - 絶対URI（外部サイト）対策
8. **行19-20**: `Url静的メソッド` - 他ページからのログインURL生成ヘルパー

**読解のコツ**: この画面はUIを持たないため、[Authorize]属性と認証ミドルウェアの連携を理解することが重要。認証フローはOpenID Connectプロトコルに従う。

#### Step 2: 認証設定を理解する

WebAppの認証設定を確認する（本設計書の範囲外だが参考として）。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Program.cs | `src/WebApp/Program.cs` | OpenID Connect設定、Identity.APIのエンドポイント設定 |

### プログラム呼び出し階層図

```
LogIn.razor (ページコンポーネント)
    │
    ├─ [Authorize]属性
    │      │
    │      └─ (未認証時) ASP.NET Core認証ミドルウェア
    │             └─ Identity.APIへリダイレクト
    │
    └─ OnInitializedAsync (認証後)
           ├─ ReturnUrl取得 (クエリパラメータ)
           ├─ URL検証 (絶対URI判定)
           └─ Nav.NavigateTo(returnUrl or "/")
```

### データフロー図

```
[入力]                    [処理]                           [出力]

クエリパラメータ          LogIn.razor
 - returnUrl ─────────────┬─ [Authorize]属性チェック
                          │      │
                          │      └─ (未認証) ──────────────▶ Identity.APIへリダイレクト
                          │
                          └─ OnInitializedAsync (認証済み)
                                 │
                                 ├─ URI解析
                                 │      │
                                 │      ├─ 絶対URI ────────▶ "/"へリダイレクト
                                 │      │
                                 │      └─ 相対URI ────────▶ returnUrlへリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LogIn.razor | `src/WebApp/Components/Pages/User/LogIn.razor` | ソース | ログインエントリーポイント |
| ItemPage.razor | `src/WebApp/Components/Pages/Item/ItemPage.razor` | ソース | ログイン呼び出し元の例 |
| Program.cs | `src/WebApp/Program.cs` | 設定 | OpenID Connect認証設定 |
