# 画面設計書 7-ログアウト画面

## 概要

本ドキュメントは、eShop WebAppのログアウト画面（エンドポイント）の設計仕様を定義する。この画面はログアウト処理のエンドポイントとして機能し、実際のログアウト処理はUserMenu.razorコンポーネントで行われる。

### 本画面の処理概要

ログアウト画面は、ログアウトフォームのPOSTリクエストを受け付けるエンドポイントとして機能する。画面自体はUIを持たず、フォームアクションの受け口として存在する。

**業務上の目的・背景**：ECサイトにおいて、ユーザーがセッションを終了しセキュリティを確保するためのログアウト機能を提供する。Cookie認証とOpenID Connect認証の両方をクリアし、完全なログアウトを実現する。ログアウトボタンはUserMenuコンポーネントに配置され、ヘッダーのユーザーメニューからアクセスする。

**画面へのアクセス方法**：ヘッダーのユーザーメニュー（ドロップダウン）から「Log out」ボタンをクリックする。フォームはPOSTメソッドでこのエンドポイントにサブミットされる。

**主要な操作・処理内容**：
1. ログアウトフォーム受付：UserMenuからのPOSTリクエストを受け付け
2. Cookie認証のサインアウト：CookieAuthenticationDefaults.AuthenticationScheme
3. OpenID Connect認証のサインアウト：OpenIdConnectDefaults.AuthenticationScheme
4. Identity.APIへのリダイレクト：OpenID Connectのログアウトエンドポイントへ

**画面遷移**：
- 遷移元：UserMenuコンポーネント（ログアウトボタン）
- 遷移先：Identity.APIのログアウト画面→ログアウト完了画面→カタログ画面

**権限による表示制御**：ログアウトボタンはAuthorizeViewの<Authorized>セクション内に配置されており、認証済みユーザーにのみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | ログアウト処理 | 主機能 | UserMenuからのログアウトフォーム送信を受け付け |

## 画面種別

エンドポイント（フォームアクション受付）

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/user/logout` |
| ルートパラメータ | なし |
| クエリパラメータ | なし |
| HTTPメソッド | POST |

## 入出力項目

### 入力項目（フォームパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| CSRF対策トークン | - | AntiforgeryToken | 必須 | CSRF攻撃対策 |

### 出力項目

なし（リダイレクト処理のみ）

## 表示項目

本画面はUIを持たない。ログアウトボタンはUserMenu.razorコンポーネントに実装されている。

### UserMenuコンポーネントでの表示

| 項目名 | 条件 | 表示内容 | 備考 |
|--------|------|---------|------|
| ユーザー名 | 認証済み | context.User.Identity.Name | ヘッダー表示 |
| My orders | 認証済み | 注文履歴へのリンク | ドロップダウンアイテム |
| Log out | 認証済み | ログアウトボタン | フォームサブミット |
| Sign in | 未認証 | ログイン画面へのリンク | アイコンリンク |

## イベント仕様

### 1-ログアウト（Log outボタンクリック）

UserMenuの「Log out」ボタンをクリックすると、ログアウト処理が実行される。

**トリガー**: formのsubmitイベント（action="user/logout"）
**処理内容**:
1. UserMenu.razorのLogOutAsyncメソッドが呼び出される
2. LogOutService.LogOutAsync(HttpContext)を実行
3. Cookie認証をサインアウト（SignOutAsync(CookieAuthenticationDefaults.AuthenticationScheme)）
4. OpenID Connect認証をサインアウト（SignOutAsync(OpenIdConnectDefaults.AuthenticationScheme)）
5. OpenID Connectのログアウトエンドポイント（Identity.API）へリダイレクト

**データの流れ**:
```
ユーザー → Log outボタンクリック
                ↓
        form submit (POST /user/logout)
                ↓
        UserMenu.LogOutAsync
                ↓
        LogOutService.LogOutAsync
                ├─ SignOutAsync(Cookie)
                └─ SignOutAsync(OpenIdConnect)
                        ↓
        Identity.APIログアウトエンドポイント
                ↓
        Identity.APIログアウト完了画面
                ↓
        カタログ画面（リダイレクト）
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面はデータベース操作を行わない |

※ セッション情報の削除は認証ミドルウェアで処理される

## メッセージ仕様

本画面はUIを持たないため、メッセージ表示はない。ログアウト完了メッセージはIdentity.APIのログアウト完了画面で表示される。

## 例外処理

| 例外条件 | 挙動 | 備考 |
|---------|------|------|
| CSRF検証失敗 | 400エラー | AntiforgeryToken検証失敗時 |

## 備考

- 本画面はページとして定義されているが、UIを持たないエンドポイントとして機能する
- 実際のログアウトボタンとフォームはUserMenu.razorコンポーネントに実装されている
- LogOutServiceがCookie認証とOpenID Connect認証の両方をクリアする
- OpenID ConnectのサインアウトによりIdentity.APIへのリダイレクトが発生する
- AntiforgeryTokenによりCSRF攻撃を防止している
- AuthorizeViewにより、認証済みユーザーにのみログアウトボタンが表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

処理の起点となるRazorページを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LogOut.razor | `src/WebApp/Components/Pages/User/LogOut.razor` | ルーティング、コメントによる説明 |

**主要処理フロー**:
1. **行1**: `@page "/user/logout"` - URLルーティング
2. **行2-5**: コメント - このページはUserMenu.razorからのPOSTを受け付けるためのエンドポイントであることを説明

#### Step 2: 実際のログアウト処理を理解する

UserMenuコンポーネントでのログアウト実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UserMenu.razor | `src/WebApp/Components/Layout/UserMenu.razor` | AuthorizeView、ログアウトフォーム、LogOutAsyncメソッド |

**主要処理フロー**:
- **行8-25**: `<AuthorizeView>` - 認証状態による表示切り替え
- **行14**: `My orders`リンク - 注文履歴画面へのナビゲーション
- **行15-18**: ログアウトフォーム - POST /user/logout、AntiforgeryToken付き
- **行31-32**: `LogOutAsync` - LogOutService.LogOutAsync呼び出し

#### Step 3: ログアウトサービスを理解する

認証サインアウト処理の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LogOutService.cs | `src/WebApp/Services/LogOutService.cs` | SignOutAsync、認証スキーム |

**主要処理フロー**:
- **行9-13**: `LogOutAsync`
  - Cookie認証のサインアウト（CookieAuthenticationDefaults.AuthenticationScheme）
  - OpenID Connect認証のサインアウト（OpenIdConnectDefaults.AuthenticationScheme）

### プログラム呼び出し階層図

```
UserMenu.razor (レイアウトコンポーネント)
    │
    ├─ AuthorizeView
    │      ├─ Authorized
    │      │      ├─ ユーザー名表示
    │      │      ├─ My ordersリンク
    │      │      └─ Log outフォーム
    │      │             │
    │      │             └─ form submit → /user/logout
    │      │                    │
    │      │                    └─ @onsubmit → LogOutAsync
    │      │
    │      └─ NotAuthorized
    │             └─ Sign inリンク
    │
    └─ LogOutAsync
           └─ LogOutService.LogOutAsync(HttpContext)
                  ├─ SignOutAsync(Cookie)
                  └─ SignOutAsync(OpenIdConnect)
                         ↓
                  Identity.APIへリダイレクト
```

### データフロー図

```
[入力]                    [処理]                           [出力]

                          UserMenu.razor
Log outボタン ────────────┬─ form submit
                          │      │
                          │      └─ POST /user/logout
                          │
                          └─ LogOutAsync
                                 │
                                 └─ LogOutService.LogOutAsync
                                        │
                                        ├─ SignOutAsync(Cookie) ───▶ Cookie削除
                                        │
                                        └─ SignOutAsync(OIDC) ─────▶ Identity.APIへ
                                                                        │
                                                                        ▼
                                                              ログアウト完了画面
                                                                        │
                                                                        ▼
                                                                カタログ画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LogOut.razor | `src/WebApp/Components/Pages/User/LogOut.razor` | ソース | ログアウトエンドポイント |
| UserMenu.razor | `src/WebApp/Components/Layout/UserMenu.razor` | ソース | ログアウトボタンを含むユーザーメニュー |
| LogOutService.cs | `src/WebApp/Services/LogOutService.cs` | ソース | ログアウト処理サービス |
