# 画面設計書 9-ログイン画面（Identity.API）

## 概要

本ドキュメントは、eShop Identity.APIのログイン画面の設計仕様を定義する。ユーザー名とパスワードによる認証フォームを提供し、IdentityServer4（現Duende IdentityServer）ベースの認証機能を実現する画面である。

### 本画面の処理概要

Identity.APIのログイン画面は、eShopシステム全体の認証を担当する画面であり、OpenID Connect/OAuth2プロトコルに基づいた認証フローを提供する。

**業務上の目的・背景**：eShopシステムにおける統一的な認証機能を提供する。WebApp、WebhookClient等の複数のクライアントアプリケーションが、この認証画面を通じてユーザー認証を行う。シングルサインオン（SSO）機能により、一度のログインで複数のアプリケーションを利用可能にする。

**画面へのアクセス方法**：クライアントアプリケーション（WebApp等）からのOpenID Connect認証リクエストによりリダイレクトされる。直接アクセスも可能だが、通常は認証フローの一部として使用される。

**主要な操作・処理内容**：
1. ユーザー名入力：認証用のユーザー名を入力
2. パスワード入力：認証用のパスワードを入力
3. ログイン記憶：「Remember me」チェックボックスで永続的なログイン状態を維持
4. ログイン実行：「Login」ボタンで認証処理を実行
5. キャンセル：ログインをキャンセルしてクライアントに戻る（アクセス拒否）

**画面遷移**：
- 遷移元：WebAppログイン画面（OpenID Connectリダイレクト）、WebhookClientログイン画面
- 遷移先：ReturnUrlで指定されたクライアントアプリケーション、同意画面（必要な場合）

**権限による表示制御**：本画面は未認証ユーザーがアクセスする画面であり、[AllowAnonymous]属性が付与されている。ローカルログインの有効/無効はクライアント設定により制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | ユーザーログイン | 主機能 | メールアドレス・パスワードによるユーザー認証 |
| 33 | 認証情報検証 | 補助機能 | EFLoginServiceでパスワード検証 |
| 34 | サインイン処理 | 補助機能 | 認証成功時のサインイン状態確立 |

## 画面種別

ログイン

## URL/ルーティング

| 項目 | 値 |
|------|-----|
| URL | `/Account/Login` |
| ルートパラメータ | なし |
| クエリパラメータ | `returnUrl`: 認証後の戻り先URL |
| 認証 | 不要（[AllowAnonymous]） |

## 入出力項目

### 入力項目（フォームパラメータ）

| 項目名 | プロパティ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| ユーザー名 | Username | string | 必須 | 認証用ユーザー名 |
| パスワード | Password | string | 必須 | 認証用パスワード |
| ログイン記憶 | RememberLogin | bool | 任意 | 永続的ログインの有効化 |
| 戻りURL | ReturnUrl | string | 必須 | 認証後のリダイレクト先（hidden） |
| ボタン | button | string | 必須 | "login"または"cancel" |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| バリデーションエラー | ValidationSummary | 認証エラーメッセージ |

## 表示項目

### ログインフォーム

| 項目名 | 条件 | 入力タイプ | 備考 |
|--------|------|---------|------|
| Username | EnableLocalLogin | text | autofocus |
| Password | EnableLocalLogin | password | autocomplete="off" |
| Remember me | AllowRememberLogin | checkbox | |
| デフォルトユーザー案内 | 常時 | 静的テキスト | "alice/bob, password: Pass123$" |

### アクションボタン

| 項目名 | value | 動作 | 備考 |
|--------|------|------|------|
| Login | login | 認証処理実行 | プライマリボタン |

## イベント仕様

### 1-ログイン実行（Loginボタンクリック）

「Login」ボタンをクリックすると、認証処理が実行される。

**トリガー**: フォームPOST（button="login"）
**処理内容**:
1. AccountController.Login(LoginInputModel model)が呼び出される
2. IIdentityServerInteractionService.GetAuthorizationContextAsyncで認可コンテキスト取得
3. SignInManager.PasswordSignInAsyncでパスワード検証
4. 認証成功時：
   - UserManager.FindByNameAsyncでユーザー情報取得
   - UserLoginSuccessEventを発行
   - ReturnUrlへリダイレクト
5. 認証失敗時：
   - UserLoginFailureEventを発行
   - エラーメッセージを表示

**データの流れ**:
```
ユーザー → Login POSTリクエスト
                ↓
        AccountController.Login
                ↓
        GetAuthorizationContextAsync
                ↓
        PasswordSignInAsync
                ├─ (成功) UserLoginSuccessEvent → Redirect(ReturnUrl)
                └─ (失敗) UserLoginFailureEvent → View(ErrorMessage)
```

### 2-キャンセル

キャンセルボタンをクリックすると、認証をキャンセルしてクライアントに戻る。

**トリガー**: フォームPOST（button != "login"）
**処理内容**:
1. 認可コンテキストが存在する場合：
   - DenyAuthorizationAsyncでアクセス拒否を返却
   - ReturnUrlへリダイレクト（アクセス拒否エラー付き）
2. 認可コンテキストが存在しない場合：
   - ホームページへリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ログイン処理 | AspNetUsers | SELECT | ユーザー情報を取得 |
| ログイン成功 | AspNetUsers | UPDATE | AccessFailedCount等を更新（ASP.NET Identity） |
| ログイン失敗 | AspNetUsers | UPDATE | AccessFailedCount等をインクリメント |

### テーブル別更新項目詳細

#### AspNetUsers

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | UserName, PasswordHash等 | UserName = @Username | |
| UPDATE | AccessFailedCount | +1 (失敗時) / 0 (成功時) | ロックアウト制御 |
| UPDATE | LockoutEnd | 設定日時 (ロックアウト時) | |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|--------------|
| ページタイトル | 常時 | "Login" |
| デフォルトユーザー案内 | 常時 | "The default users are alice/bob, password: Pass123$" |
| 認証エラー | 認証失敗時 | AccountOptions.InvalidCredentialsErrorMessage |

## 例外処理

| 例外条件 | 挙動 | 備考 |
|---------|------|------|
| 不正なReturnUrl | 例外スロー | "invalid return URL" |
| ロックアウト | ロックアウトエラー表示 | lockoutOnFailure: true |

## 備考

- IdentityServer4（Duende IdentityServer）のQuickstartテンプレートをベースとしている
- [SecurityHeaders]属性でセキュリティヘッダーが付与される
- lockoutOnFailure: trueにより、連続失敗時のアカウントロックアウトが有効
- AllowRememberLogin、EnableLocalLoginはAccountOptionsで設定可能
- 外部プロバイダー認証（ExternalProviders）にも対応（本画面では非表示）
- ネイティブクライアント向けの特別な処理（LoadingPage）が実装されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面で扱うデータの構造を把握することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LoginViewModel.cs | `src/Identity.API/Quickstart/Account/LoginViewModel.cs` | ビューモデルの構造、AllowRememberLogin、EnableLocalLogin |
| 1-2 | LoginInputModel.cs | `src/Identity.API/Quickstart/Account/LoginInputModel.cs` | 入力モデルの構造（Username, Password, RememberLogin, ReturnUrl） |

**読解のコツ**: LoginViewModelはLoginInputModelを継承し、表示制御用のプロパティを追加している。

#### Step 2: ビューを理解する

実際の画面表示を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Login.cshtml | `src/Identity.API/Views/Account/Login.cshtml` | フォーム構造、Tag Helper、条件付き表示 |

**主要処理フロー**:
- **行7-44**: EnableLocalLoginによる条件付き表示
- **行11-41**: ログインフォーム
- **行12**: hidden fieldでReturnUrl保持
- **行24-34**: AllowRememberLoginによるRemember meチェックボックス表示

#### Step 3: コントローラーを理解する

認証処理のロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AccountController.cs | `src/Identity.API/Quickstart/Account/AccountController.cs` | Login GET/POST、BuildLoginViewModelAsync |

**主要処理フロー**:
- **行39-54**: `Login` (GET) - ビューモデル構築、外部認証のみの場合のリダイレクト
- **行59-140**: `Login` (POST) - 認証処理
  - **行64**: GetAuthorizationContextAsyncで認可コンテキスト取得
  - **行67-91**: キャンセルボタン処理
  - **行95**: PasswordSignInAsyncでパスワード検証
  - **行96-112**: 認証成功時のリダイレクト
  - **行130-131**: 認証失敗イベント発行、エラーメッセージ追加
- **行206-262**: `BuildLoginViewModelAsync` - ビューモデル構築ロジック

### プログラム呼び出し階層図

```
AccountController (コントローラー)
    │
    ├─ Login (GET)
    │      └─ BuildLoginViewModelAsync
    │             ├─ _interaction.GetAuthorizationContextAsync
    │             ├─ _schemeProvider.GetAllSchemesAsync
    │             └─ _clientStore.FindEnabledClientByIdAsync
    │
    └─ Login (POST)
           ├─ _interaction.GetAuthorizationContextAsync
           │
           ├─ (キャンセル時)
           │      └─ _interaction.DenyAuthorizationAsync
           │
           └─ (ログイン時)
                  ├─ _signInManager.PasswordSignInAsync
                  │      └─ (内部でUserManager呼び出し)
                  │
                  ├─ (成功時)
                  │      ├─ _userManager.FindByNameAsync
                  │      └─ _events.RaiseAsync(UserLoginSuccessEvent)
                  │
                  └─ (失敗時)
                         └─ _events.RaiseAsync(UserLoginFailureEvent)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

クエリパラメータ          AccountController
 - returnUrl ─────────────┬─ Login (GET)
                          │      │
                          │      └─ BuildLoginViewModelAsync
                          │             │
                          │             └─ View(LoginViewModel) ─▶ ログインフォーム表示

フォーム入力
 - Username ──────────────┐
 - Password ──────────────┼─ Login (POST)
 - RememberLogin ─────────┤      │
 - button ────────────────┘      ├─ (キャンセル)
                                 │      └─ Redirect(ReturnUrl) ──▶ クライアントへ戻る
                                 │
                                 └─ (ログイン)
                                        │
                                        ├─ PasswordSignInAsync
                                        │      │
                                        │      ├─ (成功) ─────────▶ Redirect(ReturnUrl)
                                        │      │
                                        │      └─ (失敗) ─────────▶ View(ErrorMessage)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Login.cshtml | `src/Identity.API/Views/Account/Login.cshtml` | ビュー | ログイン画面のHTML |
| AccountController.cs | `src/Identity.API/Quickstart/Account/AccountController.cs` | ソース | 認証処理コントローラー |
| LoginViewModel.cs | `src/Identity.API/Quickstart/Account/LoginViewModel.cs` | ソース | ログイン画面ビューモデル |
| LoginInputModel.cs | `src/Identity.API/Quickstart/Account/LoginInputModel.cs` | ソース | ログイン入力モデル |
| AccountOptions.cs | `src/Identity.API/Quickstart/Account/AccountOptions.cs` | ソース | アカウント設定オプション |
