---
generated_at: 2026-01-14 20:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-カタログ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **データベーステーブル名**：CatalogテーブルやCatalogBrand、CatalogTypeの正確なテーブル名は推測に基づく
  2. **StreamRendering属性の効果**：段階的レンダリングの具体的な挙動は検証が必要
  3. **エラーハンドリング詳細**：例外発生時の具体的な挙動はコード上明示されていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Components/Pages/Catalog/Catalog.razor`
- E-02: `src/WebAppComponents/Catalog/CatalogSearch.razor`
- E-03: `src/WebAppComponents/Catalog/CatalogListItem.razor`
- E-04: `src/WebAppComponents/Catalog/CatalogItem.cs`
- E-05: `src/WebAppComponents/Services/ICatalogService.cs`
- E-06: `src/WebAppComponents/Services/CatalogService.cs`
- E-07: `src/WebAppComponents/Services/IProductImageUrlProvider.cs`
- E-08: `src/WebAppComponents/Item/ItemHelper.cs`
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-11: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLルーティングが「/」である | E-01 行1: `@page "/"` | ○ |
| C-02 | ページサイズが9件固定である | E-01 行38: `const int PageSize = 9;` | ○ |
| C-03 | クエリパラメータpage、brand、typeをサポート | E-01 行40-47: `[SupplyParameterFromQuery]`属性 | ○ |
| C-04 | CatalogServiceで商品一覧を取得 | E-01 行56-60、E-06 行17-22 | ○ |
| C-05 | ブランドフィルタリング機能がある | E-02 行14-26、E-06 行52-66 | ○ |
| C-06 | タイプフィルタリング機能がある | E-02 行28-43、E-06 行52-66 | ○ |
| C-07 | ページネーション機能がある | E-01 行27-32、行51-52 | ○ |
| C-08 | 商品カードから詳細画面へ遷移可能 | E-03 行5: `ItemHelper.Url(Item)` | ○ |
| C-09 | 商品画像はIProductImageUrlProviderで取得 | E-03 行7、E-07 | ○ |
| C-10 | 価格は$0.00形式で表示 | E-03 行11: `@Item.Price.ToString("0.00")` | ○ |
| C-11 | Loading...メッセージが表示される | E-01 行15: `<p>Loading...</p>` | ○ |
| C-12 | StreamRendering属性が付与されている | E-01 行4: `@attribute [StreamRendering]` | ○ |
| C-13 | CatalogItemはId,Name,Description,Price等を持つ | E-04 行3-12 | ○ |
| C-14 | CatalogResultはPageIndex,PageSize,Count,Dataを持つ | E-04 行14 | ○ |
| C-15 | CatalogBrandはId,Brandを持つ | E-04 行15 | ○ |
| C-16 | CatalogItemTypeはId,Typeを持つ | E-04 行16 | ○ |
| C-17 | APIエンドポイントは/api/catalog/items | E-06 行9, 65 | ○ |
| C-18 | ブランド一覧APIは/api/catalog/catalogBrands | E-06 行40 | ○ |
| C-19 | タイプ一覧APIは/api/catalog/catalogTypes | E-06 行46 | ○ |
| C-20 | ItemHelperはitem/{id}形式でURLを生成 | E-08 行7-8 | ○ |
| C-21 | フィルタ変更時はページを1にリセット | E-02 行66: `{ "page", null }` | ○ |
| C-22 | 機能No.1,9,10,41,42と関連 | E-10 | ○ |
| C-23 | 認証不要で利用可能 | E-09: 認証必須の記載なし | ○ |
| C-24 | 遷移元・遷移先の画面関係 | E-11 | ○ |
| C-25 | データベーステーブル名がCatalog,CatalogBrand,CatalogType | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- データベーステーブル名の正確な定義
  - 候補：Catalog.API内のEntity定義 / EF Coreのマイグレーション / データベーススキーマドキュメント
- エラー発生時の具体的なUI挙動
  - 候補：エラーバウンダリの実装 / グローバル例外ハンドラ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UIコンポーネントの構造と動作
- 0: 低リスク - APIエンドポイントとデータ取得ロジック
- 1: 中リスク - データベーステーブル名の推測部分

## 6) レビュアーチェックリスト（最小）
- [ ] ページサイズ9件が要件と合致しているか確認
- [ ] フィルタリング条件の組み合わせ（AND/OR）が期待通りか確認
- [ ] データベーステーブル名の正確性を確認（Catalog.API内のEntity定義を参照）
- [ ] StreamRenderingの挙動がパフォーマンス要件を満たすか確認
