---
generated_at: 2026-01-14 21:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-ログアウト画面（Identity.API）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **確認メッセージのtypo**："logut"→"logout"の修正検討
  2. **SignOutIframeUrlの動作**：フェデレーションログアウトの具体的な連携先
  3. **自動リダイレクト設定**：AccountOptions.AutomaticRedirectAfterSignOutの設定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Views/Account/Logout.cshtml`
- E-02: `src/Identity.API/Views/Account/LoggedOut.cshtml`
- E-03: `src/Identity.API/Quickstart/Account/LogoutViewModel.cs`
- E-04: `src/Identity.API/Quickstart/Account/LoggedOutViewModel.cs`
- E-05: `src/Identity.API/Quickstart/Account/AccountController.cs`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LogoutViewModelにShowLogoutPromptがある | E-03 行9 | ○ |
| C-02 | LoggedOutViewModelにPostLogoutRedirectUriがある | E-04 行9 | ○ |
| C-03 | LoggedOutViewModelにAutomaticRedirectAfterSignOutがある | E-04 行13 | ○ |
| C-04 | LoggedOutViewModelにSignOutIframeUrlがある | E-04 行11 | ○ |
| C-05 | TriggerExternalSignoutはExternalAuthenticationSchemeで判定 | E-04 行16 | ○ |
| C-06 | 確認メッセージに"logut"のtypoがある | E-01 行6 | ○ |
| C-07 | logoutIdをhiddenで保持 | E-01 行10 | ○ |
| C-08 | Yesボタンでフォーム送信 | E-01 行12 | ○ |
| C-09 | LoggedOut画面でViewData["signed-out"]設定 | E-02 行5 | ○ |
| C-10 | PostLogoutRedirectUri存在時にリダイレクトリンク表示 | E-02 行14-20 | ○ |
| C-11 | SignOutIframeUrlでiframe表示 | E-02 行22-25 | ○ |
| C-12 | AutomaticRedirectAfterSignOutでJS読み込み | E-02 行30-33 | ○ |
| C-13 | Logout GETでBuildLogoutViewModelAsync | E-05 行150 | ○ |
| C-14 | ShowLogoutPrompt falseで直接ログアウト | E-05 行152-157 | ○ |
| C-15 | Logout POSTでSignOutAsync | E-05 行175 | ○ |
| C-16 | UserLogoutSuccessEvent発行 | E-05 行178 | ○ |
| C-17 | TriggerExternalSignoutで外部IdPへリダイレクト | E-05 行182-191 | ○ |
| C-18 | BuildLogoutViewModelAsyncでShowLogoutPrompt判定 | E-05 行272-294 | ○ |
| C-19 | BuildLoggedOutViewModelAsyncでPostLogoutRedirectUri設定 | E-05 行296-332 | ○ |
| C-20 | 機能No.48と関連 | E-07 | ○ |
| C-21 | 遷移元・遷移先の画面関係 | E-08 | ○ |
| C-22 | View("LoggedOut", vm)で完了画面表示 | E-05 行193 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（すべての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ログアウト確認フロー
- 0: 低リスク - セッションクリア処理
- 0: 低リスク - リダイレクト処理
- 1: 中リスク - Logout.cshtmlのtypo（ユーザー体験への影響）

## 6) レビュアーチェックリスト（最小）
- [ ] "logut"のtypoを"logout"に修正すべきか検討
- [ ] ShowLogoutPromptの判定ロジックが適切か確認（セキュリティ観点）
- [ ] AutomaticRedirectAfterSignOutの設定値が適切か確認
- [ ] SignOutIframeUrlによるフェデレーションログアウトの動作確認
