---
generated_at: 2026-01-14 21:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-ログアウト完了画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Views/Account/LoggedOut.cshtml`
- E-02: `src/Identity.API/Quickstart/Account/AccountController.cs`
- E-03: `src/Identity.API/Quickstart/Account/LoggedOutViewModel.cs`
- E-04: `src/Identity.API/Quickstart/Account/AccountOptions.cs`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログアウト完了画面はIdentityServer4の認証フローでログアウト処理完了後に表示される | E-02 (行193: View("LoggedOut", vm)) | ○ |
| C-02 | ViewModelはLoggedOutViewModelである | E-01 (行1: @model LoggedOutViewModel), E-03 | ○ |
| C-03 | PostLogoutRedirectUriプロパティでクライアント復帰URLを提供 | E-03 (行9), E-01 (行17) | ○ |
| C-04 | ClientNameプロパティでクライアント名を保持 | E-03 (行10), E-01 (行18) | ○ |
| C-05 | SignOutIframeUrlでSLO用iframeを提供 | E-03 (行11), E-01 (行24) | ○ |
| C-06 | AutomaticRedirectAfterSignOutで自動リダイレクト制御 | E-03 (行13), E-01 (行30-33) | ○ |
| C-07 | ViewData["signed-out"]にtrueを設定 | E-01 (行5) | ○ |
| C-08 | AccountController.Logout POSTで処理 | E-02 (行165-194) | ○ |
| C-09 | SignInManager.SignOutAsyncでCookie削除 | E-02 (行175) | ○ |
| C-10 | UserLogoutSuccessEventを発行 | E-02 (行178) | ○ |
| C-11 | BuildLoggedOutViewModelAsyncでViewModel生成 | E-02 (行296-332) | ○ |
| C-12 | GetLogoutContextAsyncでログアウトコンテキスト取得 | E-02 (行299) | ○ |
| C-13 | TriggerExternalSignoutは計算プロパティ | E-03 (行16) | ○ |
| C-14 | AllowAnonymous属性でアクセス制御 | E-02 (行7) | ○ |
| C-15 | 機能No.48 ログアウト処理と関連 | E-06 (行36) | ○ |
| C-16 | 画面遷移：ログアウト画面から遷移 | E-07 (行63-64) | ○ |
| C-17 | AutomaticRedirectAfterSignOutのデフォルトはtrue | E-04 (行13) | ○ |
| C-18 | PostLogoutRedirectUri未設定時は復帰リンク非表示 | E-01 (行14-20: 条件分岐) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] LoggedOut.cshtmlのView構造がドキュメント記載と一致するか確認
- [ ] AccountControllerのLogout処理フローが正確に記載されているか確認
- [ ] 画面遷移図との整合性を確認
