---
generated_at: 2026-01-14 21:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-ホーム画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Views/Home/Index.cshtml`
- E-02: `src/Identity.API/Quickstart/Home/HomeController.cs`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ホーム画面はIdentityServer4のウェルカムページ | E-01 (行10: "Welcome to IdentityServer4") | ○ |
| C-02 | 開発環境でのみ表示される | E-02 (行26-29: IsDevelopment()チェック) | ○ |
| C-03 | 本番環境では404を返す | E-02 (行32-33: return NotFound()) | ○ |
| C-04 | AllowAnonymous属性で認証不要 | E-02 (行7: [AllowAnonymous]) | ○ |
| C-05 | ディスカバリードキュメントへのリンクを提供 | E-01 (行17: `<a href="~/.well-known/openid-configuration">`) | ○ |
| C-06 | 診断画面へのリンクを提供 | E-01 (行21: `<a href="~/diagnostics">`) | ○ |
| C-07 | 権限管理画面へのリンクを提供 | E-01 (行24: `<a href="~/grants">`) | ○ |
| C-08 | GitHubリポジトリへの外部リンクを提供 | E-01 (行28: source code repository) | ○ |
| C-09 | バージョン情報をFileVersionInfoで取得 | E-01 (行4-5) | ○ |
| C-10 | IdentityServerMiddlewareアセンブリからバージョン取得 | E-01 (行4: typeof(Duende.IdentityServer.Hosting.IdentityServerMiddleware)) | ○ |
| C-11 | 本番環境でログ出力 | E-02 (行32: LogInformation) | ○ |
| C-12 | URLは / または /Home/Index | E-02 (HomeControllerのIndex) | ○ |
| C-13 | 機能No.31 ユーザーログインと関連 | E-04 (行38) | ○ |
| C-14 | 画面遷移：診断画面・権限管理画面へ遷移可能 | E-05 (行67-68) | ○ |
| C-15 | ViewModelを使用しない | E-02 (行28: return View()でモデルなし) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Index.cshtmlのナビゲーションリンクがドキュメント記載と一致するか確認
- [ ] HomeControllerの環境チェックロジックが正しく記載されているか確認
- [ ] 画面遷移図との整合性を確認
