---
generated_at: 2026-01-14 21:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-同意画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Views/Consent/Index.cshtml`
- E-02: `src/Identity.API/Quickstart/Consent/ConsentController.cs`
- E-03: `src/Identity.API/Quickstart/Consent/ConsentViewModel.cs`
- E-04: `src/Identity.API/Quickstart/Consent/ConsentInputModel.cs`
- E-05: `src/Identity.API/Quickstart/Consent/ScopeViewModel.cs`
- E-06: `src/Identity.API/Quickstart/Consent/ConsentOptions.cs`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-09: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 同意画面はOAuth2.0認可フローで権限付与を確認する | E-07 (行14: "OAuth同意画面。クライアントアプリへの権限付与を確認") | ○ |
| C-02 | Authorize属性で認証必須 | E-02 (行10: [Authorize]) | ○ |
| C-03 | ConsentViewModelを使用 | E-01 (行1: @model ConsentViewModel), E-03 | ○ |
| C-04 | ConsentViewModelはConsentInputModelを継承 | E-03 (行7) | ○ |
| C-05 | ClientName、ClientUrl、ClientLogoUrlを表示 | E-03 (行9-11), E-01 (行5-12) | ○ |
| C-06 | IdentityScopesとApiScopesを一覧表示 | E-03 (行14-15), E-01 (行26-60) | ○ |
| C-07 | ScopeViewModelにValue、DisplayName、Required、Checked等を保持 | E-05 (行9-14) | ○ |
| C-08 | RememberConsentチェックボックスを提供 | E-04 (行11), E-01 (行74-84) | ○ |
| C-09 | AllowRememberConsentで同意記憶の可否を制御 | E-03 (行12), E-01 (行74) | ○ |
| C-10 | Yes, AllowボタンとNo, Do Not Allowボタンを提供 | E-01 (行90-91) | ○ |
| C-11 | ProcessConsentでbutton="no"時にAccessDenied | E-02 (行93-99) | ○ |
| C-12 | ProcessConsentでbutton="yes"時にスコープ検証 | E-02 (行101-121) | ○ |
| C-13 | ConsentGrantedEventを発行 | E-02 (行120) | ○ |
| C-14 | ConsentDeniedEventを発行 | E-02 (行98) | ○ |
| C-15 | GrantConsentAsyncで同意をIdentityServerに通知 | E-02 (行135) | ○ |
| C-16 | エラーメッセージ"You must pick at least one permission" | E-06 (行13) | ○ |
| C-17 | エラーメッセージ"Invalid selection" | E-06 (行14) | ○ |
| C-18 | EnableOfflineAccessでオフラインアクセス設定 | E-06 (行9) | ○ |
| C-19 | BuildViewModelAsyncでViewModelを構築 | E-02 (行150-163) | ○ |
| C-20 | GetAuthorizationContextAsyncでリクエストコンテキスト取得 | E-02 (行152) | ○ |
| C-21 | ネイティブクライアント判定でLoadingPageを使用 | E-02 (行55-61) | ○ |
| C-22 | 機能No.31 ユーザーログインと関連 | E-08 (行39-40) | ○ |
| C-23 | 画面遷移：ログイン画面から遷移 | E-09 (行60-61) | ○ |
| C-24 | Descriptionフィールドで任意入力 | E-04 (行13), E-01 (行69) | ○ |
| C-25 | _ScopeListItemパーシャルビューを使用 | E-01 (行37, 55) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Index.cshtmlのフォーム構造がドキュメント記載と一致するか確認
- [ ] ConsentControllerのProcessConsent処理フローが正しく記載されているか確認
- [ ] ViewModelとInputModelのプロパティ構造が正確か確認
- [ ] 画面遷移図との整合性を確認
