---
generated_at: 2026-01-14 21:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-権限管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Views/Grants/Index.cshtml`
- E-02: `src/Identity.API/Quickstart/Grants/GrantsController.cs`
- E-03: `src/Identity.API/Quickstart/Grants/GrantsViewModel.cs`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 権限管理画面はユーザーの付与済み権限を一覧表示する | E-04 (行15: "付与済みの権限一覧を表示し、取り消し機能を提供") | ○ |
| C-02 | Authorize属性で認証必須 | E-02 (行10: [Authorize]) | ○ |
| C-03 | GrantsViewModelを使用 | E-01 (行1: @model GrantsViewModel), E-03 | ○ |
| C-04 | Grantsプロパティで権限一覧を保持 | E-03 (行9: IEnumerable<GrantViewModel> Grants) | ○ |
| C-05 | GrantViewModelにClientId、ClientName等を保持 | E-03 (行14-22) | ○ |
| C-06 | IdentityGrantNamesとApiGrantNamesで権限名を表示 | E-03 (行21-22), E-01 (行59-82) | ○ |
| C-07 | Created日付をyyyy-MM-dd形式で表示 | E-01 (行51) | ○ |
| C-08 | Expiresが存在する場合のみ有効期限を表示 | E-01 (行53-58: HasValue条件) | ○ |
| C-09 | Revoke Accessボタンを提供 | E-01 (行37: Revoke Access) | ○ |
| C-10 | Revokeアクションでclientidをhiddenで送信 | E-01 (行36) | ○ |
| C-11 | RevokeUserConsentAsyncで権限取り消し | E-02 (行45) | ○ |
| C-12 | GrantsRevokedEventを発行 | E-02 (行46) | ○ |
| C-13 | Revoke後にIndexへリダイレクト | E-02 (行48: RedirectToAction("Index")) | ○ |
| C-14 | GetAllUserGrantsAsyncで全権限取得 | E-02 (行53) | ○ |
| C-15 | FindClientByIdAsyncでクライアント情報取得 | E-02 (行58) | ○ |
| C-16 | FindResourcesByScopeAsyncでリソース情報取得 | E-02 (行61) | ○ |
| C-17 | 権限なしの場合にメッセージ表示 | E-01 (行9-18: "You have not given access to any applications") | ○ |
| C-18 | 機能No.31、34と関連 | E-05 (行41-42) | ○ |
| C-19 | 画面遷移：ホーム画面から遷移可能 | E-06 (行68) | ○ |
| C-20 | Description項目を条件付き表示 | E-01 (行44-49: grant.Description != null) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Index.cshtmlの一覧表示構造がドキュメント記載と一致するか確認
- [ ] GrantsControllerのRevoke処理フローが正しく記載されているか確認
- [ ] ViewModelのプロパティ構造が正確か確認
- [ ] 画面遷移図との整合性を確認
