---
generated_at: 2026-01-14 21:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-診断画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Views/Diagnostics/Index.cshtml`
- E-02: `src/Identity.API/Quickstart/Diagnostics/DiagnosticsController.cs`
- E-03: `src/Identity.API/Quickstart/Diagnostics/DiagnosticsViewModel.cs`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 診断画面は認証Cookieのクレームとプロパティを表示する | E-04 (行16: "認証クッキーのクレームとプロパティを表示するデバッグ画面") | ○ |
| C-02 | Authorize属性で認証必須 | E-02 (行8: [Authorize]) | ○ |
| C-03 | ローカルホストからのアクセスのみ許可 | E-02 (行13-17: localAddresses判定) | ○ |
| C-04 | 非ローカルからはNotFoundを返却 | E-02 (行16: return NotFound()) | ○ |
| C-05 | DiagnosticsViewModelを使用 | E-01 (行1: @model DiagnosticsViewModel), E-03 | ○ |
| C-06 | AuthenticateResultプロパティを保持 | E-03 (行26) | ○ |
| C-07 | Clientsプロパティを保持 | E-03 (行27) | ○ |
| C-08 | client_listをBase64Urlデコード | E-03 (行18: Base64Url.Decode) | ○ |
| C-09 | JSONデシリアライズでstring[]に変換 | E-03 (行21: JsonSerializer.Deserialize<string[]>) | ○ |
| C-10 | HttpContext.AuthenticateAsync()で認証情報取得 | E-02 (行19) | ○ |
| C-11 | Principal.Claimsをイテレートして表示 | E-01 (行16-20) | ○ |
| C-12 | Properties.Itemsをイテレートして表示 | E-01 (行33-34) | ○ |
| C-13 | タイトルは"Authentication Cookie" | E-01 (行5) | ○ |
| C-14 | クレームはdt/dd形式で表示 | E-01 (行18-19) | ○ |
| C-15 | 機能No.31 ユーザーログインと関連 | E-05 (行43) | ○ |
| C-16 | 画面遷移：ホーム画面から遷移可能 | E-06 (行67) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Index.cshtmlのクレーム・プロパティ表示構造がドキュメント記載と一致するか確認
- [ ] DiagnosticsControllerのローカルホストチェック処理が正しく記載されているか確認
- [ ] ViewModelのclient_listデコードロジックが正確か確認
