---
generated_at: 2026-01-14 21:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-デバイスコード入力画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Views/Device/UserCodeCapture.cshtml`
- E-02: `src/Identity.API/Quickstart/Device/DeviceController.cs`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デバイスコード入力画面はユーザーコードを入力するフォームを提供 | E-03 (行17: "デバイスフロー認証用のユーザーコード入力フォーム") | ○ |
| C-02 | Authorize属性で認証必須 | E-02 (行6: [Authorize]) | ○ |
| C-03 | userCodeパラメータがない場合にUserCodeCaptureビューを表示 | E-02 (行32: return View("UserCodeCapture")) | ○ |
| C-04 | タイトルは"User Code" | E-01 (行5) | ○ |
| C-05 | 説明文は"Please enter the code displayed on your device." | E-01 (行6) | ○ |
| C-06 | _ValidationSummaryパーシャルを使用 | E-01 (行9) | ○ |
| C-07 | asp-action="UserCodeCapture"でPOST | E-01 (行13) | ○ |
| C-08 | userCode入力フィールドにautofocus属性 | E-01 (行16: autofocus) | ○ |
| C-09 | Submitボタンを提供 | E-01 (行19: Submit) | ○ |
| C-10 | UserCodeCapture POSTでBuildViewModelAsyncを呼び出し | E-02 (行45) | ○ |
| C-11 | vm==nullの場合Errorビューを表示 | E-02 (行46) | ○ |
| C-12 | vm!=nullの場合UserCodeConfirmationビューを表示 | E-02 (行48) | ○ |
| C-13 | 機能No.31 ユーザーログインと関連 | E-04 (行44) | ○ |
| C-14 | 画面遷移：デバイス確認画面へ遷移 | E-05 (行69) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] UserCodeCapture.cshtmlの入力フォーム構造がドキュメント記載と一致するか確認
- [ ] DeviceControllerのUserCodeCapture処理フローが正しく記載されているか確認
- [ ] 画面遷移図との整合性を確認
