---
generated_at: 2026-01-14 20:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：2-商品詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **Basket（Redis）の詳細仕様**：BasketServiceの内部実装とRedisへの永続化方法の詳細確認が必要
  2. **ログイン後のリダイレクト動作**：ログイン後に元の商品詳細画面に戻る動作の実装詳細
  3. **data-enhance属性の挙動**：Blazor拡張動作の具体的な影響

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Components/Pages/Item/ItemPage.razor`
- E-02: `src/WebAppComponents/Catalog/CatalogItem.cs`
- E-03: `src/WebApp/Services/BasketItem.cs`
- E-04: `src/WebApp/Services/IBasketState.cs`
- E-05: `src/WebApp/Services/BasketState.cs`
- E-06: `src/WebAppComponents/Services/CatalogService.cs`
- E-07: `src/WebAppComponents/Services/IProductImageUrlProvider.cs`
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-10: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLルーティングが「/item/{itemId:int}」である | E-01 行1: `@page "/item/{itemId:int}"` | ○ |
| C-02 | itemIdはルートパラメータとして受け取る | E-01 行69-70: `[Parameter] public int ItemId` | ○ |
| C-03 | CatalogServiceで商品詳細を取得 | E-01 行80、E-06 行11-15 | ○ |
| C-04 | BasketState.GetBasketItemsAsyncでカート内数量を取得 | E-01 行107、E-05 行21-24 | ○ |
| C-05 | BasketState.AddAsyncでカートに追加 | E-01 行100、E-05 行33-56 | ○ |
| C-06 | 未ログイン時はログイン画面へリダイレクト | E-01 行92-95 | ○ |
| C-07 | ログイン状態はHttpContext.User.Identity.IsAuthenticatedで判定 | E-01 行79 | ○ |
| C-08 | 商品名がページタイトルに表示される | E-01 行10: `<PageTitle>@item.Name \| AdventureWorks</PageTitle>` | ○ |
| C-09 | ブランド名がヘッダーサブタイトルに表示される | E-01 行12: `@item.CatalogBrand?.Brand` | ○ |
| C-10 | 価格は$0.00形式で表示 | E-01 行23: `$@item.Price.ToString("0.00")` | ○ |
| C-11 | 404エラー時はnotFound=trueになる | E-01 行83-87 | ○ |
| C-12 | 404エラー時は「Sorry, we couldn't find any such product.」が表示 | E-01 行59 | ○ |
| C-13 | AntiforgeryTokenがフォームに含まれる | E-01 行22: `<AntiforgeryToken />` | ○ |
| C-14 | ログイン済み時は「Add to shopping bag」ボタンが表示 | E-01 行25-35 | ○ |
| C-15 | 未ログイン時は「Log in to purchase」ボタンが表示 | E-01 行36-45 | ○ |
| C-16 | カート内数量が0より大きい場合に表示 | E-01 行48-51 | ○ |
| C-17 | 商品画像はIProductImageUrlProviderで取得 | E-01 行15、E-07 | ○ |
| C-18 | BasketItemはProductId, Quantity等を持つ | E-03 | ○ |
| C-19 | カート追加時に既存商品は数量+1される | E-05 行42: `existing with { Quantity = existing.Quantity + 1 }` | ○ |
| C-20 | 新規商品は数量1で追加される | E-05 行50: `new BasketQuantity(item.Id, 1)` | ○ |
| C-21 | CatalogBrandはnullableとして扱われる | E-01 行12, 19: `item.CatalogBrand?` | ○ |
| C-22 | data-enhance属性がログイン状態で制御される | E-01 行21: `data-enhance="@isLoggedIn"` | ○ |
| C-23 | HTTPステータス404が設定される | E-01 行85: `HttpContext!.Response.StatusCode = 404` | ○ |
| C-24 | カート追加後に画面遷移は行われない | E-01 行100-102: AddAsync後にUpdateNumInCartAsyncのみ | ○ |
| C-25 | 機能No.2,4,14,15,42,47と関連 | E-09 | ○ |
| C-26 | 遷移元・遷移先の画面関係 | E-10 | ○ |
| C-27 | CascadingParameterでHttpContextを受け取る | E-01 行72-73 | ○ |
| C-28 | Basket永続化にRedisを使用 | **根拠なし（推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- BasketServiceの詳細実装とバックエンドストレージ（Redis）の仕様
  - 候補：BasketService.cs / Basket.API / インフラ設計書
- ログイン後の元ページへのリダイレクト実装
  - 候補：LogIn.razor / IdentityServer設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UIコンポーネントの構造と表示ロジック
- 0: 低リスク - カート追加・ログイン判定ロジック
- 1: 中リスク - Basket永続化層（Redis）の仕様推測部分

## 6) レビュアーチェックリスト（最小）
- [ ] 商品404時のユーザー体験が適切か確認
- [ ] カート追加後の画面更新タイミングが期待通りか確認
- [ ] BasketServiceのバックエンド（Redis等）の仕様を確認
- [ ] ログイン後の商品詳細画面への戻り動作を確認
