---
generated_at: 2026-01-14 21:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-エラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Views/Shared/Error.cshtml`
- E-02: `src/Identity.API/Quickstart/Home/HomeController.cs`
- E-03: `src/Identity.API/Quickstart/Home/ErrorViewModel.cs`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エラー画面は認証エラー時のエラーメッセージを表示 | E-04 (行20: "エラーメッセージとリクエストIDを表示する共通エラー画面") | ○ |
| C-02 | AllowAnonymous属性で認証不要 | E-02 (行7: [AllowAnonymous]) | ○ |
| C-03 | ErrorViewModelを使用 | E-01 (行1: @model ErrorViewModel), E-03 | ○ |
| C-04 | ErrorViewModelにErrorMessageプロパティを保持 | E-03 (行17: ErrorMessage Error) | ○ |
| C-05 | HomeController.Errorで処理 | E-02 (行39-57) | ○ |
| C-06 | GetErrorContextAsync(errorId)でエラー情報取得 | E-02 (行44) | ○ |
| C-07 | 本番環境ではErrorDescriptionをnull化 | E-02 (行49-52: !_environment.IsDevelopment()) | ○ |
| C-08 | タイトルは"Error" | E-01 (行11: `<h1>Error</h1>`) | ○ |
| C-09 | 基本メッセージは"Sorry, there was an error" | E-01 (行17) | ○ |
| C-10 | error変数にModel.Error.Errorを設定 | E-01 (行4) | ○ |
| C-11 | errorDescription変数にModel.Error.ErrorDescriptionを設定 | E-01 (行5) | ○ |
| C-12 | request_id変数にModel.Error.RequestIdを設定 | E-01 (行6) | ○ |
| C-13 | Error存在時に強調表示 | E-01 (行19-26: error != null条件分岐) | ○ |
| C-14 | RequestId存在時に表示 | E-01 (行34-37: request_id != null条件分岐) | ○ |
| C-15 | 機能No.31 ユーザーログインと関連 | E-05 (行48) | ○ |
| C-16 | 画面遷移：認証エラー発生時に表示 | E-06 (行26-27, 150-151) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Error.cshtmlのエラー表示構造がドキュメント記載と一致するか確認
- [ ] HomeControllerのError処理での環境チェックが正しく記載されているか確認
- [ ] ViewModelの構造が正確か確認
