---
generated_at: 2026-01-14 20:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：21-ホーム画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebhookClient/Components/Pages/Home/Home.razor` - ホーム画面のRazorページ
- E-02: `src/WebhookClient/Components/Pages/Home/RegisteredHooks.razor` - 登録済みWebhook一覧コンポーネント
- E-03: `src/WebhookClient/Components/Pages/Home/ReceivedMessages.razor` - 受信メッセージ一覧コンポーネント
- E-04: `src/WebhookClient/Services/WebHooksClient.cs` - WebhooksAPIクライアント
- E-05: `src/WebhookClient/Services/HooksRepository.cs` - 受信メッセージリポジトリ
- E-06: `src/WebhookClient/Services/WebhookResponse.cs` - 登録済みWebhookモデル
- E-07: `src/WebhookClient/Services/WebHookReceived.cs` - 受信メッセージモデル
- E-08: `src/WebhookClient/Endpoints/WebhookEndpoints.cs` - Webhookエンドポイント定義
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-10: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL/ルーティングが「/」である | E-01 (1行目: `@page "/"`) | ○ |
| C-02 | AuthorizeViewで認証状態に応じた表示制御を行う | E-01 (8-18行目) | ○ |
| C-03 | 登録済みWebhook一覧にDate, Destination, Tokenを表示 | E-02 (10-12行目: PropertyColumn定義) | ○ |
| C-04 | 受信メッセージ一覧にWhen, Data, Tokenを表示 | E-03 (11-13行目: PropertyColumn定義) | ○ |
| C-05 | WebhooksClient.LoadWebhooksでWebhook一覧を取得 | E-04 (10-13行目) | ○ |
| C-06 | HooksRepository.GetAllで受信メッセージを取得 | E-05 (30-33行目) | ○ |
| C-07 | HooksRepository.Subscribeで変更通知を購読 | E-05 (35-39行目), E-03 (30行目) | ○ |
| C-08 | 未認証時に「Log in to view or edit webhook registrations」を表示 | E-01 (14-16行目) | ○ |
| C-09 | 受信メッセージなし時にNone yet receivedを表示 | E-03 (18-22行目) | ○ |
| C-10 | 登録済みWebhookなし時にNone registeredを表示 | E-02 (17行目) | ○ |
| C-11 | WebhookResponseのプロパティはDate, DestUrl, Token | E-06 (5-7行目) | ○ |
| C-12 | WebHookReceivedのプロパティはWhen, Data, Token | E-07 (5-9行目) | ○ |
| C-13 | ReceivedMessagesがIDisposableを実装 | E-03 (2行目: `@implements IDisposable`) | ○ |
| C-14 | 「Add webhook registration」リンクで/add-webhookへ遷移 | E-01 (11行目) | ○ |
| C-15 | QuickGridでソート可能なテーブルを表示 | E-02 (9-13行目), E-03 (10-14行目) | ○ |
| C-16 | ConcurrentQueueで受信メッセージを管理 | E-05 (7行目) | ○ |
| C-17 | /webhook-receivedエンドポイントでメッセージを受信 | E-08 (31-53行目) | ○ |
| C-18 | 関連機能No.35, 49, 51, 52が正しい | E-09 (49-52行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に対してソースコードによる根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] AuthorizeViewの動作が認証基盤と正しく連携しているか確認
- [ ] QuickGridのソート機能が期待通りに動作するか確認
- [ ] HooksRepositoryのSubscribeパターンがメモリリークを起こさないか確認
