---
generated_at: 2026-01-14 20:48:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-Webhook追加画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 特になし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebhookClient/Components/Pages/AddWebhook.razor` - Webhook追加画面のRazorページ
- E-02: `src/WebhookClient/Services/WebHooksClient.cs` - WebhooksAPIクライアント
- E-03: `src/WebhookClient/Services/WebhookSubscriptionRequest.cs` - 登録リクエストモデル
- E-04: `src/WebhookClient/Services/WebhookClientOptions.cs` - 設定オプションクラス
- E-05: `src/WebhookClient/Endpoints/WebhookEndpoints.cs` - Webhookエンドポイント定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL/ルーティングが「/add-webhook」である | E-01 (1行目: `@page "/add-webhook"`) | ○ |
| C-02 | token入力フィールドがある | E-01 (14行目: `<input type="text" @bind="@token"`) | ○ |
| C-03 | デフォルトトークンがWebhookClientOptions.Tokenから取得される | E-01 (28-31行目), E-04 (5行目) | ○ |
| C-04 | WebhookSubscriptionRequestにUrl, Token, Event, GrantUrlがある | E-03 (5-8行目) | ○ |
| C-05 | Eventが"OrderPaid"固定である | E-01 (49行目) | ○ |
| C-06 | GrantUrlが{baseUrl}checkで構築される | E-01 (44行目) | ○ |
| C-07 | Webhook URLが{baseUrl}webhook-receivedで構築される | E-01 (45行目) | ○ |
| C-08 | WebhooksClient.AddWebHookAsyncでAPI呼び出し | E-01 (55行目), E-02 (5-8行目) | ○ |
| C-09 | POST /api/webhooksにリクエスト送信 | E-02 (7行目) | ○ |
| C-10 | 成功時にホーム画面へリダイレクト | E-01 (58行目: `Nav.NavigateTo("")`) | ○ |
| C-11 | 失敗時にエラーメッセージを表示 | E-01 (62行目) | ○ |
| C-12 | エラーメッセージの形式が「Registation was rejected with status {StatusCode} {ReasonPhrase}」 | E-01 (62行目) | ○ |
| C-13 | トークンが空の場合は早期リターン | E-01 (35-38行目) | ○ |
| C-14 | SelfUrlがあればそれを優先、なければBaseUriを使用 | E-01 (41-43行目) | ○ |
| C-15 | /checkエンドポイントでトークン検証 | E-05 (16-29行目) | ○ |
| C-16 | 関連機能No.37, 40, 49, 50が正しい | E-06 (53-56行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に対してソースコードによる根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 画面自体に認証制御（[Authorize]属性）がないことが意図的かどうか確認
- [ ] SelfUrlの設定方法と環境変数・設定ファイルとの整合性確認
- [ ] Grant URL検証がWebhooks API側で正しく動作するか確認
