---
generated_at: 2026-01-14 20:52:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-ログイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebhookClient/Components/Pages/LogIn.razor` - ログイン画面のRazorページ
- E-02: `src/WebhookClient/Program.cs` - アプリケーション起動設定
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL/ルーティングが「/login」である | E-01 (1行目: `@page "/login"`) | ○ |
| C-02 | [Authorize]属性が設定されている | E-01 (3行目: `@attribute [Authorize]`) | ○ |
| C-03 | ReturnUrlをクエリパラメータとして受け取る | E-01 (6行目: `[SupplyParameterFromQuery]`) | ○ |
| C-04 | ReturnUrlのデフォルト値が空文字 | E-01 (9行目: `ReturnUrl ?? ""`) | ○ |
| C-05 | UriKind.Relativeで相対URLとしてパース | E-01 (9行目: `new Uri(ReturnUrl ?? "", UriKind.Relative)`) | ○ |
| C-06 | NavigationManagerでリダイレクト | E-01 (10行目: `Nav.NavigateTo`) | ○ |
| C-07 | replace: trueで履歴を置き換え | E-01 (10行目: `replace: true`) | ○ |
| C-08 | NavigationManagerが依存性注入される | E-01 (4行目: `@inject NavigationManager Nav`) | ○ |
| C-09 | OnInitializedでリダイレクト処理を実行 | E-01 (7行目: `protected override void OnInitialized()`) | ○ |
| C-10 | Microsoft.AspNetCore.Authorizationを使用 | E-01 (2行目: `@using Microsoft.AspNetCore.Authorization`) | ○ |
| C-11 | 画面コンテンツ（HTMLマークアップ）がない | E-01 (全体: @code ブロックのみ) | ○ |
| C-12 | 関連機能No.31が正しい | E-03 (57行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に対してソースコードによる根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] OIDC認証設定がExtensions.csで正しく構成されているか確認
- [ ] ReturnUrlが相対URLのみを受け付けることによるオープンリダイレクト対策が十分か確認
- [ ] 認証失敗時のエラーハンドリングがIdentity.API側で適切に行われているか確認
