---
generated_at: 2026-01-14 20:56:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-エラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 特になし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebhookClient/Components/Pages/Error.razor` - エラー画面のRazorページ
- E-02: `src/WebhookClient/Program.cs` - アプリケーション起動設定
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL/ルーティングが「/Error」である | E-01 (1行目: `@page "/Error"`) | ○ |
| C-02 | System.Diagnosticsを使用 | E-01 (2行目: `@using System.Diagnostics`) | ○ |
| C-03 | PageTitleが「Error」である | E-01 (4行目: `<PageTitle>Error</PageTitle>`) | ○ |
| C-04 | 「Error.」というタイトルを表示 | E-01 (6行目: `<h1 class="text-danger">Error.</h1>`) | ○ |
| C-05 | 「An error occurred while processing your request.」を表示 | E-01 (7行目) | ○ |
| C-06 | ShowRequestIdがtrueの場合にリクエストIDを表示 | E-01 (9-14行目) | ○ |
| C-07 | ShowRequestIdはRequestIdが空でないかをチェック | E-01 (32行目: `!string.IsNullOrEmpty(RequestId)`) | ○ |
| C-08 | RequestIdはActivity.Current?.Idから取得 | E-01 (34-35行目) | ○ |
| C-09 | Activity.Current?.Idがnullの場合HttpContext?.TraceIdentifierを使用 | E-01 (35行目: `?? HttpContext?.TraceIdentifier`) | ○ |
| C-10 | HttpContextはCascadingParameterとして受け取る | E-01 (29行目: `[CascadingParameter]`) | ○ |
| C-11 | 開発モード案内のメッセージが含まれる | E-01 (16-25行目) | ○ |
| C-12 | UseExceptionHandler("/Error")で設定される | E-02 (16行目: `app.UseExceptionHandler("/Error"`) | ○ |
| C-13 | createScopeForErrors: trueが設定される | E-02 (16行目: `createScopeForErrors: true`) | ○ |
| C-14 | 関連機能No.49が正しい | E-03 (58行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に対してソースコードによる根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 本番環境でセンシティブな情報がエラー画面に表示されないことを確認
- [ ] 分散トレーシング（Activity）が正しく設定されているか確認
- [ ] エラーログとリクエストIDの対応が取れることを確認
