---
generated_at: 2026-01-14 20:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：5-注文履歴画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **OrderStatusNotificationServiceの実装詳細**：通知サービスの具体的な実装を確認
  2. **ステータス値の種類**：注文ステータスの取り得る値一覧
  3. **APIフィルタリング仕様**：ユーザーごとの注文フィルタリングがAPI側で行われる前提

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Components/Pages/User/Orders.razor`
- E-02: `src/WebApp/Components/Pages/User/OrdersRefreshOnStatusChange.razor`
- E-03: `src/WebApp/Services/OrderingService.cs`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLルーティングが「/user/orders」である | E-01 行1: `@page "/user/orders"` | ○ |
| C-02 | Authorize属性により認証必須 | E-01 行2: `@attribute [Authorize]` | ○ |
| C-03 | StreamRendering属性が付与されている | E-01 行3: `@attribute [StreamRendering]` | ○ |
| C-04 | ページタイトルが「Orders \| AdventureWorks」 | E-01 行6 | ○ |
| C-05 | OrdersRefreshOnStatusChangeコンポーネントを使用 | E-01 行8 | ○ |
| C-06 | OrderingService.GetOrdersで注文取得 | E-01 行56、E-03 行7-10 | ○ |
| C-07 | OrderRecordがOrderNumber,Date,Status,Totalを持つ | E-03 行21-25 | ○ |
| C-08 | GET /api/Orders/で注文一覧取得 | E-03 行5,9 | ○ |
| C-09 | 読み込み中に「Loading...」表示 | E-01 行13 | ○ |
| C-10 | 注文なし時に「You haven't yet placed any orders.」表示 | E-01 行17 | ○ |
| C-11 | 合計金額は$0.00形式で表示 | E-01 行38 | ○ |
| C-12 | ステータスにToLower()でCSSクラス適用 | E-01 行41 | ○ |
| C-13 | OrdersRefreshOnStatusChangeはInteractiveServerモード | E-02 行2 | ○ |
| C-14 | OnAfterRenderAsyncで通知購読開始 | E-02 行10-21 | ○ |
| C-15 | GetBuyerIdAsyncでユーザーID取得 | E-02 行14 | ○ |
| C-16 | SubscribeToOrderStatusNotificationsで購読 | E-02 行17-18 | ○ |
| C-17 | HandleOrderStatusChangedでNav.Refresh() | E-02 行27 | ○ |
| C-18 | DispatchExceptionAsyncで例外処理 | E-02 行33 | ○ |
| C-19 | IDisposableを実装し購読解除 | E-02 行6,37-40 | ○ |
| C-20 | 機能No.20,45と関連 | E-05 | ○ |
| C-21 | 遷移元・遷移先の画面関係 | E-06 | ○ |
| C-22 | OrderStatusNotificationServiceの詳細実装 | **根拠なし（参照のみ）** | △ |

## 4) 不足情報（Unknown / Missing）
- OrderStatusNotificationServiceの詳細実装
  - 候補：OrderStatusNotificationService.cs / SignalR設定
- 注文ステータスの取り得る値一覧
  - 候補：Ordering.API / ドメインモデル定義
- Ordering.APIのユーザーフィルタリング実装
  - 候補：Ordering.API / OrdersController

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UIコンポーネントの構造と表示ロジック
- 0: 低リスク - OrderingService経由のデータ取得
- 1: 中リスク - OrderStatusNotificationServiceの詳細実装確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] OrderStatusNotificationServiceの実装を確認（SignalR等）
- [ ] 注文ステータスの取り得る値とCSSクラス対応を確認
- [ ] Ordering.APIでのユーザーフィルタリングが正しく行われているか確認
- [ ] リアルタイム更新のパフォーマンス影響を確認
