---
generated_at: 2026-01-14 21:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：6-ログイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **OpenID Connect設定の詳細**：Identity.APIへのリダイレクト設定
  2. **認証ミドルウェアの動作**：[Authorize]属性による自動リダイレクト先の設定
  3. **セキュリティ対策の十分性**：オープンリダイレクト対策の検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Components/Pages/User/LogIn.razor`
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLルーティングが「/user/login」である | E-01 行1: `@page "/user/login"` | ○ |
| C-02 | Authorize属性により認証必須 | E-01 行3: `@attribute [Authorize]` | ○ |
| C-03 | SupplyParameterFromQueryでReturnUrl取得 | E-01 行5-6 | ○ |
| C-04 | CascadingParameterでHttpContext取得 | E-01 行8-9 | ○ |
| C-05 | ReturnUrl未指定時は"/"をデフォルト | E-01 行13: `ReturnUrl ?? "/"` | ○ |
| C-06 | Uri.IsAbsoluteUriで絶対URI判定 | E-01 行15: `url.IsAbsoluteUri ? "/" : returnUrl` | ○ |
| C-07 | 絶対URIの場合は"/"へリダイレクト | E-01 行15 | ○ |
| C-08 | Url静的メソッドでログインURL生成 | E-01 行19-20 | ○ |
| C-09 | Uri.EscapeDataStringでエンコード | E-01 行20 | ○ |
| C-10 | Nav.NavigateToでリダイレクト | E-01 行15 | ○ |
| C-11 | 機能No.31,47と関連 | E-03 | ○ |
| C-12 | 遷移元・遷移先の画面関係 | E-04 | ○ |
| C-13 | 認証必須画面である | E-02: 「認証必須」の記載 | ○ |
| C-14 | Identity.APIへ認証リダイレクト | E-04: WebAppとIdentityの連携図 | ○ |
| C-15 | OpenID Connect設定の詳細 | **根拠なし（Program.cs参照必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- OpenID Connect認証設定の詳細
  - 候補：Program.cs / appsettings.json / 認証設定ファイル
- Identity.APIの認証エンドポイントURL
  - 候補：Identity.API設定 / 環境変数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - リダイレクトロジック
- 1: 中リスク - オープンリダイレクト対策の十分性
- 1: 中リスク - OpenID Connect設定の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] OpenID Connect設定が正しく構成されているか確認（Program.cs）
- [ ] オープンリダイレクト対策が十分か確認（絶対URI判定のみで十分か）
- [ ] ReturnUrlの検証ロジックが適切か確認
- [ ] Identity.APIへのリダイレクトフローが正常に動作するか確認
