---
generated_at: 2026-01-14 21:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-ログアウト画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **ログアウト後のリダイレクト先**：Identity.APIからの最終リダイレクト先の確認
  2. **セッション完全クリア**：Cookie認証とOIDC認証の両方がクリアされることの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Components/Pages/User/LogOut.razor`
- E-02: `src/WebApp/Components/Layout/UserMenu.razor`
- E-03: `src/WebApp/Services/LogOutService.cs`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLルーティングが「/user/logout」である | E-01 行1: `@page "/user/logout"` | ○ |
| C-02 | 画面はUIを持たない | E-01: コメントで説明、実コンテンツなし | ○ |
| C-03 | 処理はUserMenu.razorで行われる | E-01 行3-4: コメントによる説明 | ○ |
| C-04 | AuthorizeViewで認証状態による表示切り替え | E-02 行8-25 | ○ |
| C-05 | ログアウトフォームはaction="user/logout" | E-02 行15 | ○ |
| C-06 | AntiforgeryTokenが含まれる | E-02 行16 | ○ |
| C-07 | @onsubmitでLogOutAsync呼び出し | E-02 行15: `@onsubmit="LogOutAsync"` | ○ |
| C-08 | LogOutServiceをインジェクト | E-02 行5 | ○ |
| C-09 | LogOutService.LogOutAsyncを呼び出し | E-02 行31-32 | ○ |
| C-10 | CascadingParameterでHttpContext取得 | E-02 行28-29 | ○ |
| C-11 | Cookie認証をサインアウト | E-03 行11 | ○ |
| C-12 | OpenIdConnect認証をサインアウト | E-03 行12 | ○ |
| C-13 | My ordersリンクがドロップダウンにある | E-02 行14 | ○ |
| C-14 | ユーザー名が表示される | E-02 行10 | ○ |
| C-15 | 未認証時はSign inリンク表示 | E-02 行23 | ○ |
| C-16 | 機能No.48と関連 | E-05 | ○ |
| C-17 | 遷移元・遷移先の画面関係 | E-06 | ○ |
| C-18 | フォームはPOSTメソッド | E-02 行15: `method="post"` | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（すべての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ログアウト処理フロー
- 0: 低リスク - CSRF対策（AntiforgeryToken）
- 0: 低リスク - 認証スキームのクリア処理

## 6) レビュアーチェックリスト（最小）
- [ ] Cookie認証とOIDC認証の両方が正しくクリアされることを確認
- [ ] ログアウト後のリダイレクト先（Identity.API経由）が適切か確認
- [ ] AntiforgeryTokenの検証が正しく動作するか確認
