---
generated_at: 2026-01-14 21:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：8-チャットボット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **セマンティック検索API**：GetCatalogItemsWithSemanticRelevanceのバックエンド実装
  2. **OpenAI設定詳細**：IChatClientの具体的な設定方法
  3. **MessageProcessor詳細**：AllowImagesメソッドの実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Components/Chatbot/Chatbot.razor`
- E-02: `src/WebApp/Components/Chatbot/ChatState.cs`
- E-03: `src/WebAppComponents/Services/CatalogService.cs`
- E-04: `src/WebApp/Services/BasketState.cs`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InteractiveServerモード(prerender:false)で動作 | E-01 行1 | ○ |
| C-02 | IChatClientをServiceProviderから取得 | E-01 行56 | ○ |
| C-03 | IChatClient未設定時にmissingConfiguration=true | E-01 行64 | ○ |
| C-04 | 設定エラーメッセージに'useOpenAI = true'の説明 | E-01 行30 | ○ |
| C-05 | SendMessageAsyncでメッセージ送信 | E-01 行68-79 | ○ |
| C-06 | thinking変数で思考中表示を制御 | E-01 行75,77 | ○ |
| C-07 | chatState.AddUserMessageAsyncを呼び出し | E-01 行76 | ○ |
| C-08 | JSモジュールでscrollToEnd実行 | E-01 行84 | ○ |
| C-09 | submitOnEnterでEnterキー送信 | E-01 行89 | ○ |
| C-10 | ChatStateに4つのツールを登録 | E-02 行41-47 | ○ |
| C-11 | システムプロンプトでAIの役割を定義 | E-02 行52-60 | ○ |
| C-12 | 初期メッセージが「Hi! I'm the AdventureWorks Concierge...」 | E-02 行61-63 | ○ |
| C-13 | GetUserInfoでユーザークレームを取得 | E-02 行96-115 | ○ |
| C-14 | SearchCatalogでセマンティック検索 | E-02 行117-134、E-03 行31-36 | ○ |
| C-15 | SearchCatalogで最大8件取得 | E-02 行122: `0, 8, productDescription` | ○ |
| C-16 | AddToCartでカート追加 | E-02 行136-153 | ○ |
| C-17 | 未認証時に「You must be logged in.」返却 | E-02 行145-148 | ○ |
| C-18 | GetCartContentsでカート内容取得 | E-02 行155-167 | ○ |
| C-19 | エラー時に「My apologies...」メッセージ | E-02 行90 | ○ |
| C-20 | 商品画像URLを付与 | E-02 行123-126 | ○ |
| C-21 | JSON形式で検索結果を返却 | E-02 行128 | ○ |
| C-22 | 「Item added to shopping cart.」を返却 | E-02 行143 | ○ |
| C-23 | 閉じるボタンでクエリパラメータ削除 | E-01 行15 | ○ |
| C-24 | textareaにplaceholder="Start chatting..." | E-01 行40 | ○ |
| C-25 | chatState nullで送信ボタン無効化 | E-01 行41: `disabled="@(chatState is null)"` | ○ |
| C-26 | 機能No.1,6,15,46と関連 | E-06 | ○ |
| C-27 | OpenAI設定必須の備考 | E-05 | ○ |
| C-28 | MessageProcessor.AllowImagesの詳細実装 | **根拠なし（参照のみ）** | △ |

## 4) 不足情報（Unknown / Missing）
- MessageProcessor.AllowImagesの詳細実装
  - 候補：MessageProcessor.cs
- セマンティック検索のバックエンド実装（Catalog.API内）
  - 候補：Catalog.API / AI検索設定
- IChatClientの設定方法（Program.cs、eShop.AppHost）
  - 候補：AppHost設定 / 環境変数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - チャットUIの構造
- 0: 低リスク - ツール関数の実装
- 1: 中リスク - セマンティック検索のバックエンド依存
- 1: 中リスク - OpenAI設定の詳細（APIキー管理等）

## 6) レビュアーチェックリスト（最小）
- [ ] OpenAI/Azure OpenAIの設定方法を確認（eShop.AppHost）
- [ ] セマンティック検索のバックエンド実装を確認（Catalog.API）
- [ ] AIツール関数のセキュリティ（特にAddToCart）を確認
- [ ] システムプロンプトの適切性（プロンプトインジェクション対策）を確認
- [ ] MessageProcessorのAllowImages実装を確認（XSS対策）
