---
generated_at: 2026-01-14 21:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：9-ログイン画面（Identity.API）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **LoginInputModel詳細**：基底クラスの詳細定義を確認
  2. **AccountOptions設定**：InvalidCredentialsErrorMessage等の設定値
  3. **デフォルトユーザー情報**：alice/bobの本番環境での取り扱い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Views/Account/Login.cshtml`
- E-02: `src/Identity.API/Quickstart/Account/LoginViewModel.cs`
- E-03: `src/Identity.API/Quickstart/Account/AccountController.cs`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SecurityHeaders属性が付与されている | E-03 行6 | ○ |
| C-02 | AllowAnonymous属性が付与されている | E-03 行7 | ○ |
| C-03 | EnableLocalLoginで条件付き表示 | E-01 行7 | ○ |
| C-04 | Usernameにautofocus | E-01 行18 | ○ |
| C-05 | Passwordにautocomplete="off" | E-01 行22 | ○ |
| C-06 | AllowRememberLoginでRemember me表示制御 | E-01 行24-34 | ○ |
| C-07 | デフォルトユーザー案内表示 | E-01 行37 | ○ |
| C-08 | ReturnUrlをhiddenで保持 | E-01 行12 | ○ |
| C-09 | button value="login"でログイン処理 | E-01 行39、E-03 行67 | ○ |
| C-10 | Login GETでBuildLoginViewModelAsync | E-03 行43 | ○ |
| C-11 | IsExternalLoginOnlyで外部認証のみ判定 | E-03 行47-51 | ○ |
| C-12 | GetAuthorizationContextAsyncで認可コンテキスト取得 | E-03 行64 | ○ |
| C-13 | キャンセル時にDenyAuthorizationAsync | E-03 行74 | ○ |
| C-14 | PasswordSignInAsyncでパスワード検証 | E-03 行95 | ○ |
| C-15 | lockoutOnFailure: trueでロックアウト有効 | E-03 行95 | ○ |
| C-16 | 認証成功時にUserLoginSuccessEvent発行 | E-03 行99 | ○ |
| C-17 | 認証失敗時にUserLoginFailureEvent発行 | E-03 行130 | ○ |
| C-18 | 不正なReturnUrlで例外スロー | E-03 行126 | ○ |
| C-19 | IsLocalUrlでURLチェック | E-03 行115 | ○ |
| C-20 | AllowRememberLogin設定をAccountOptionsから取得 | E-02 行9、E-03 行256 | ○ |
| C-21 | EnableLocalLogin設定をクライアントから取得可能 | E-03 行245 | ○ |
| C-22 | 機能No.31,33,34と関連 | E-05 | ○ |
| C-23 | 遷移元・遷移先の画面関係 | E-06 | ○ |
| C-24 | LoginInputModelの詳細定義 | **根拠なし（参照のみ）** | △ |

## 4) 不足情報（Unknown / Missing）
- LoginInputModelの詳細定義
  - 候補：LoginInputModel.cs
- AccountOptionsの全設定値
  - 候補：AccountOptions.cs
- AspNetUsersテーブルの詳細スキーマ
  - 候補：ApplicationDbContext / EF Coreマイグレーション

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ログインフォームの構造
- 0: 低リスク - 認証処理フロー
- 1: 中リスク - デフォルトユーザー（alice/bob）の本番環境での取り扱い
- 1: 中リスク - ロックアウト設定の適切性

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトユーザー（alice/bob）が本番環境で無効化されているか確認
- [ ] ロックアウト設定（試行回数、ロック時間）が適切か確認
- [ ] SecurityHeaders属性で適切なヘッダーが設定されているか確認
- [ ] ReturnUrlのバリデーションが十分か確認（オープンリダイレクト対策）
