---
generated_at: 2026-01-14 20:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 65
  claims_without_evidence: 5
confidence_derived: 0.93
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：65 / 70、根拠なし：5
- 優先レビュー（高）
  1. **IT-057/058 Identity API認証連携**：EFLoginServiceからの推測のため要検証
  2. **IT-059/060 認証トークン検証**：具体的な認証フロー実装の詳細確認必要
  3. **IT-062 Ordering統合イベントログ**：実装詳細の追加確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Catalog.API/Apis/CatalogApi.cs`
- E-02: `src/Ordering.API/Apis/OrdersApi.cs`
- E-03: `src/Basket.API/Grpc/BasketService.cs`
- E-04: `src/Webhooks.API/Apis/WebHooksApi.cs`
- E-05: `src/Catalog.API/Infrastructure/CatalogContext.cs`
- E-06: `src/Ordering.Infrastructure/OrderingContext.cs`
- E-07: `src/Ordering.Infrastructure/Repositories/OrderRepository.cs`
- E-08: `src/Basket.API/Repositories/RedisBasketRepository.cs`
- E-09: `src/Basket.API/Repositories/IBasketRepository.cs`
- E-10: `src/Catalog.API/IntegrationEvents/EventHandling/OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs`
- E-11: `src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderStockConfirmedIntegrationEventHandler.cs`
- E-12: `src/PaymentProcessor/IntegrationEvents/EventHandling/OrderStatusChangedToStockConfirmedIntegrationEventHandler.cs`
- E-13: `src/Basket.API/IntegrationEvents/EventHandling/OrderStartedIntegrationEventHandler.cs`
- E-14: `src/OrderProcessor/Services/GracePeriodManagerService.cs`
- E-15: `src/Catalog.API/IntegrationEvents/ICatalogIntegrationEventService.cs`
- E-16: `src/Ordering.API/Application/IntegrationEvents/IOrderingIntegrationEventService.cs`
- E-17: `src/Identity.API/Services/EFLoginService.cs`
- E-18: `tests/Catalog.FunctionalTests/CatalogApiTests.cs`
- E-19: `tests/Ordering.FunctionalTests/OrderingApiTests.cs`
- E-20: `src/Ordering.API/Application/Commands/IdentifiedCommandHandler.cs`
- E-21: `src/Ordering.Infrastructure/Idempotency/RequestManager.cs`
- E-22: `src/Webhooks.API/IntegrationEvents/ProductPriceChangedIntegrationEventHandler.cs`
- E-23: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToPaidIntegrationEventHandler.cs`
- E-24: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEventHandler.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001 カタログアイテム一覧取得API | E-01, E-18 | ○ |
| C-02 | IT-002 カタログアイテムID指定取得API | E-01, E-18 | ○ |
| C-03 | IT-003 カタログアイテム複数ID一括取得API | E-01, E-18 | ○ |
| C-04 | IT-004 カタログアイテム名前検索API | E-01, E-18 | ○ |
| C-05 | IT-005 カタログアイテム画像取得API | E-01, E-18 | ○ |
| C-06 | IT-006 カタログアイテムセマンティック検索API | E-01, E-18 | ○ |
| C-07 | IT-007 カタログアイテムタイプ・ブランド検索API | E-01, E-18 | ○ |
| C-08 | IT-008 カタログタイプ一覧取得API | E-01, E-18 | ○ |
| C-09 | IT-009 カタログブランド一覧取得API | E-01, E-18 | ○ |
| C-10 | IT-010 カタログアイテム作成API | E-01, E-18 | ○ |
| C-11 | IT-011 カタログアイテム更新（価格変更なし）API | E-01, E-18 | ○ |
| C-12 | IT-012 カタログアイテム更新（価格変更）API + EventBus連携 | E-01, E-15, E-18 | ○ |
| C-13 | IT-013 カタログアイテム削除API | E-01, E-18 | ○ |
| C-14 | IT-014 注文一覧取得API | E-02, E-19 | ○ |
| C-15 | IT-015 注文詳細取得API | E-02, E-19 | ○ |
| C-16 | IT-016 カードタイプ一覧取得API | E-02, E-19 | ○ |
| C-17 | IT-017 注文ドラフト作成API | E-02, E-19 | ○ |
| C-18 | IT-018 注文作成API | E-02, E-19 | ○ |
| C-19 | IT-019 注文作成RequestId空エラー | E-02, E-19 | ○ |
| C-20 | IT-020 注文キャンセルAPI | E-02, E-19 | ○ |
| C-21 | IT-021 注文キャンセルRequestId空エラー | E-02, E-19 | ○ |
| C-22 | IT-022 注文キャンセル存在しない注文エラー | E-02, E-19 | ○ |
| C-23 | IT-023 注文出荷API | E-02, E-19 | ○ |
| C-24 | IT-024 注文出荷RequestId空エラー | E-02, E-19 | ○ |
| C-25 | IT-025 注文出荷存在しない注文エラー | E-02, E-19 | ○ |
| C-26 | IT-026 gRPCバスケット取得 | E-03 | ○ |
| C-27 | IT-027 gRPCバスケット取得（未認証） | E-03 | ○ |
| C-28 | IT-028 gRPCバスケット更新 | E-03, E-08 | ○ |
| C-29 | IT-029 gRPCバスケット更新（未認証エラー） | E-03 | ○ |
| C-30 | IT-030 gRPCバスケット削除 | E-03, E-08 | ○ |
| C-31 | IT-031 gRPCバスケット削除（未認証エラー） | E-03 | ○ |
| C-32 | IT-032 Webhook購読一覧取得API | E-04 | ○ |
| C-33 | IT-033 Webhook購読詳細取得API | E-04 | ○ |
| C-34 | IT-034 Webhook購読作成API | E-04 | ○ |
| C-35 | IT-035 Webhook購読作成（無効GrantURL）エラー | E-04 | ○ |
| C-36 | IT-036 Webhook購読削除API | E-04 | ○ |
| C-37 | IT-037 CatalogContextトランザクション | E-05 | ○ |
| C-38 | IT-038 OrderingContextトランザクション | E-06 | ○ |
| C-39 | IT-039 Unit of Workパターン | E-06 | ○ |
| C-40 | IT-040 トランザクション管理 | E-06 | ○ |
| C-41 | IT-041 トランザクションロールバック | E-06 | ○ |
| C-42 | IT-042 Redisバスケット保存 | E-08 | ○ |
| C-43 | IT-043 Redisバスケット取得 | E-08 | ○ |
| C-44 | IT-044 Redisバスケット削除 | E-08 | ○ |
| C-45 | IT-045 在庫確認イベント送信 | E-10, E-15 | ○ |
| C-46 | IT-046 在庫確認成功イベント受信 | E-10, E-11 | ○ |
| C-47 | IT-047 在庫確認失敗イベント受信 | E-10 | ○ |
| C-48 | IT-048 決済処理イベント送信 | E-12 | ○ |
| C-49 | IT-049 決済成功イベント受信 | E-12 | ○ |
| C-50 | IT-050 決済失敗イベント受信 | E-12 | ○ |
| C-51 | IT-051 注文開始時バスケット削除 | E-13 | ○ |
| C-52 | IT-052 価格変更Webhook通知 | E-22 | ○ |
| C-53 | IT-053 支払完了Webhook通知 | E-23 | ○ |
| C-54 | IT-054 出荷完了Webhook通知 | E-24 | ○ |
| C-55 | IT-055 GracePeriod確認処理 | E-14 | ○ |
| C-56 | IT-056 GracePeriod確認イベント受信 | E-14, E-16 | ○ |
| C-57 | IT-057 ユーザーログイン認証 | E-17 | △ |
| C-58 | IT-058 ユーザーサインイン | E-17 | △ |
| C-59 | IT-059 認証トークン検証 | **根拠なし** | △ |
| C-60 | IT-060 認証エラー（無効トークン） | **根拠なし** | △ |
| C-61 | IT-061 Catalog統合イベントログ保存 | E-15 | ○ |
| C-62 | IT-062 Ordering統合イベントログ保存 | E-16 | △ |
| C-63 | IT-063 統合イベントパブリッシュ | E-15, E-16 | ○ |
| C-64 | IT-064 重複リクエスト排除 | E-20 | ○ |
| C-65 | IT-065 RequestManager登録確認 | E-21 | ○ |
| C-66 | IT-066 APIバージョン1.0互換性 | E-01, E-18 | ○ |
| C-67 | IT-067 APIバージョン2.0互換性 | E-01, E-18 | ○ |
| C-68 | IT-068 不正ID指定エラー | E-01 | ○ |
| C-69 | IT-069 存在しないアイテム取得エラー | E-01 | ○ |
| C-70 | IT-070 存在しない注文取得エラー | E-02, E-19 | ○ |

## 4) 不足情報（Unknown / Missing）
- **IT-057/058（Identity API認証連携）**: EFLoginServiceの実装は確認できたが、完全な認証フローの統合テスト詳細は要確認
  - 候補：Identity.API/Quickstart/Account/AccountController.cs / Identity.API関連テスト
- **IT-059/060（認証トークン検証）**: JWTトークン検証の具体的な実装コードの参照が不足
  - 候補：ServiceDefaults/Extensions.cs / 認証ミドルウェア設定
- **IT-062（Ordering統合イベントログ）**: インターフェースのみ確認、具体的な実装詳細の追加確認推奨
  - 候補：OrderingIntegrationEventService.cs の詳細確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: Catalog API、Ordering API、Basket API、Webhooks APIの基本CRUD操作（E-01〜E-04, E-18, E-19で検証済み）
- **0（低リスク）**: EventBus連携テスト（IntegrationEventHandlerの実装コードで検証済み）
- **1（中リスク）**: Identity API認証連携（EFLoginServiceの実装は確認したが、統合テストの詳細確認推奨）
- **1（中リスク）**: 認証トークン検証（JWT設定の具体的実装を追加確認推奨）
- **0（低リスク）**: データベーストランザクション（OrderingContext, CatalogContextで明示的に実装確認済み）
- **0（低リスク）**: Redis連携（RedisBasketRepositoryで明示的に実装確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] IT-001〜013: Catalog APIエンドポイントのテスト手順とエンドポイントURLが正確か確認
- [ ] IT-014〜025: Ordering APIエンドポイントのテスト手順とエンドポイントURLが正確か確認
- [ ] IT-026〜031: gRPC Basket APIのメソッド名とエラーコードが正確か確認
- [ ] IT-045〜056: EventBus連携のイベント名とフローが実際の実装と一致するか確認
- [ ] IT-057〜060: Identity API認証フローの詳細を追加確認（要重点レビュー）
- [ ] IT-064〜065: 冪等性制御のIdentifiedCommandHandlerとRequestManagerの動作確認
- [ ] 全体: テストケースの優先度（高/中/低）が適切か確認
