---
generated_at: 2026-01-14 10:00:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs`
- E-02: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToSubmittedIntegrationEventHandler.cs`
- E-03: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs`
- E-04: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToStockConfirmedIntegrationEventHandler.cs`
- E-05: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToPaidIntegrationEventHandler.cs`
- E-06: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToShippedIntegrationEventHandler.cs`
- E-07: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToCancelledIntegrationEventHandler.cs`
- E-08: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToPaidIntegrationEventHandler.cs`
- E-09: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEventHandler.cs`
- E-10: `src/ClientApp/ViewModels/CheckoutViewModel.cs`
- E-11: `src/ClientApp/Services/Dialog/DialogService.cs`
- E-12: `src/WebApp/Components/Pages/User/OrdersRefreshOnStatusChange.razor`
- E-13: `src/Ordering.API/Application/DomainEventHandlers/ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandler.cs`
- E-14: `src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToAwaitingValidationDomainEventHandler.cs`
- E-15: `src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToStockConfirmedDomainEventHandler.cs`
- E-16: `src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToPaidDomainEventHandler.cs`
- E-17: `src/Ordering.API/Application/DomainEventHandlers/OrderShippedDomainEventHandler.cs`
- E-18: `src/Ordering.API/Application/DomainEventHandlers/OrderCancelledDomainEventHandler.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 注文送信完了通知：注文が正常に送信され処理が開始されたことを購入者に通知 | E-02, E-12, E-13 | ○ |
| C-02 | 在庫検証待ち通知：注文が在庫検証待ち状態になったことを購入者に通知 | E-03, E-12, E-14 | ○ |
| C-03 | 在庫確認完了通知：注文商品の在庫が確認されたことを購入者に通知 | E-04, E-12, E-15 | ○ |
| C-04 | 支払完了通知：注文の支払いが完了したことを購入者に通知 | E-05, E-12, E-16 | ○ |
| C-05 | 出荷完了通知：注文が出荷されたことを購入者に通知 | E-06, E-12, E-17 | ○ |
| C-06 | 注文キャンセル通知：注文がキャンセルされたことを購入者に通知 | E-07, E-12, E-18 | ○ |
| C-07 | 注文支払完了Webhook：支払い完了時に外部システムへWebhook通知を送信 | E-08 | ○ |
| C-08 | 注文出荷完了Webhook：出荷完了時に外部システムへWebhook通知を送信 | E-09 | ○ |
| C-09 | 注文成功アラート：モバイルアプリで注文完了時にアラートダイアログを表示 | E-10, E-11 | ○ |
| C-10 | 注文エラーアラート：モバイルアプリで注文エラー時にアラートダイアログを表示 | E-10, E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で不足情報はありません
- 全ての通知機能についてソースコードレベルで根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードレベルの根拠あり
- 注意点：
  - Email/SMS等の外部通知サービス連携は現在のコードベースでは実装されていない
  - 通知内容の詳細（メール本文テンプレート等）は確認できないが、これは仕様上存在しない可能性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 注文ステータス変更通知（6種類）が網羅されているか確認
- [ ] Webhook通知のトリガー条件が正しいか確認
- [ ] UIアラートのメッセージ内容が適切か確認
- [ ] 将来的に追加予定の通知機能がないか確認
