# 通知設計書 1-注文送信完了通知

## 概要

本ドキュメントは、eShopシステムにおける注文送信完了通知（OrderStatusChangedToSubmittedIntegrationEvent）の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、購入者が注文を送信し、システムが注文処理を開始したことをリアルタイムで通知する機能である。Ordering.APIドメインで発生したOrderStartedDomainEventを契機として、IntegrationEventが生成され、EventBus経由でWebAppに送信される。WebAppでは、SignalRライクな仕組み（OrderStatusNotificationService）を用いて、該当購入者のブラウザ画面を自動的に更新する。

**業務上の目的・背景**：EC（電子商取引）において、注文が正常に受け付けられたことを即座に購入者に伝えることは、顧客体験の向上において極めて重要である。本通知により、購入者は注文が正しく処理開始されたことを確認でき、不安を解消できる。また、リアルタイム通知により、ページの手動リロードなしに最新のステータスを確認可能となる。

**通知の送信タイミング**：注文が送信され、OrderStartedDomainEventが発火し、バイヤー情報の検証・登録が完了した直後にIntegrationEventが発行される。具体的には、ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandlerの処理完了時に送信される。

**通知の受信者**：注文を行った購入者（BuyerIdentityGuidで識別）のみが受信対象となる。WebApp上で当該購入者のセッションに紐づくサブスクリプションにのみ通知が配信される。

**通知内容の概要**：注文ID、注文ステータス（Submitted）、購入者名、購入者識別子の情報が含まれる。これらの情報により、WebApp側で適切な画面更新処理を実行できる。

**期待されるアクション**：購入者は画面が自動更新されることで、注文履歴画面やマイページで最新の注文ステータスを確認できる。特別な操作は不要で、自動的にUIが最新状態に更新される。

## 通知種別

アプリ内通知（WebApp SignalR経由のリアルタイム画面更新）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventBus経由） |
| 優先度 | 中 |
| リトライ | EventBusレベルでのリトライ機構による |

### 送信先決定ロジック

1. IntegrationEventに含まれるBuyerIdentityGuidを取得
2. OrderStatusNotificationServiceの_subscriptionsByBuyerIdディクショナリから該当するサブスクリプションを検索
3. 該当するすべてのサブスクリプション（同一ユーザーの複数ブラウザセッション等）にコールバックを実行

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、アプリ内リアルタイム通知のため該当なし。

### 本文テンプレート

本通知は画面自動更新のためのシグナルであり、テキスト本文は存在しない。

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| OrderId | 注文ID | Order.Id | Yes |
| OrderStatus | 注文ステータス | Order.OrderStatus | Yes |
| BuyerName | 購入者名 | Buyer.Name | Yes |
| BuyerIdentityGuid | 購入者識別子 | Buyer.IdentityGuid | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ドメインイベント | OrderStartedDomainEvent | バイヤー情報の検証・保存成功後 | 注文開始時にバイヤー情報を検証・登録し、成功したらIntegrationEventを発行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| バイヤー情報保存失敗 | SaveEntitiesAsync失敗時はイベント発行されない |
| 該当サブスクリプションなし | WebApp側で購入者のサブスクリプションが存在しない場合は通知されない（エラーにはならない） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[CreateOrderCommand実行] --> B[Order集約作成]
    B --> C[OrderStartedDomainEvent発火]
    C --> D[ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandler]
    D --> E[バイヤー情報検証・登録]
    E --> F[SaveEntitiesAsync]
    F --> G[OrderStatusChangedToSubmittedIntegrationEvent作成]
    G --> H[AddAndSaveEventAsync]
    H --> I[EventBus経由で発行]
    I --> J[WebApp OrderStatusChangedToSubmittedIntegrationEventHandler受信]
    J --> K[OrderStatusNotificationService.NotifyOrderStatusChangedAsync]
    K --> L[該当サブスクリプションのコールバック実行]
    L --> M[ブラウザ画面更新 Nav.Refresh]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Orders | 注文情報取得 | 注文ID、ステータス取得 |
| Buyers | 購入者情報取得 | 購入者名、識別子取得 |

### テーブル別参照項目詳細

#### Orders

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Id | 注文ID | OrderStartedDomainEventから取得 |
| OrderStatus | 注文ステータス | OrderStartedDomainEventから取得 |

#### Buyers

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Name | 購入者名 | VerifyOrAddPaymentMethod実行後のBuyerインスタンスから取得 |
| IdentityGuid | 購入者識別子 | VerifyOrAddPaymentMethod実行後のBuyerインスタンスから取得 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| IntegrationEventLog | INSERT | イベントログの保存 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | EventId | IntegrationEvent.Id | イベント一意識別子 |
| INSERT | EventTypeName | イベント型名 | OrderStatusChangedToSubmittedIntegrationEvent |
| INSERT | State | Pending→InProgress→Published/Failed | 送信状態 |
| INSERT | Content | JSONシリアライズされたイベント内容 | イベントデータ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| イベント発行失敗 | EventBus接続エラー | MarkEventAsFailedAsyncでログ記録、リトライキューへ |
| サブスクリプションエラー | WebApp側でのコールバック実行エラー | DispatchExceptionAsyncで例外ハンドリング |
| データベースエラー | イベントログ保存失敗 | トランザクションロールバック |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | EventBus実装依存（RabbitMQ等） |
| リトライ間隔 | EventBus実装依存 |
| リトライ対象エラー | 一時的なネットワークエラー、接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間365日配信可能）

## セキュリティ考慮事項

- BuyerIdentityGuidは認証済みユーザーの識別子として使用され、他ユーザーの通知を受信することはできない
- IntegrationEventはシステム内部のEventBus経由でのみ送信され、外部からの偽装は不可能
- WebApp側ではAuthenticationStateProviderを使用して認証状態を検証

## 備考

- この通知はSignalRではなく、Blazor Serverの`InteractiveServer`レンダーモードを活用した独自の通知機構を使用
- `Nav.Refresh()`によりページ全体が再レンダリングされるため、部分更新ではなく完全な画面更新となる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、IntegrationEventのデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IntegrationEvent.cs | `src/EventBus/Events/IntegrationEvent.cs` | 基底クラス。Id（Guid）とCreationDate（DateTime）を持つ |
| 1-2 | OrderStatusChangedToSubmittedIntegrationEvent.cs | `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedTosubmittedIntegrationEvent.cs` | 発行側のイベント定義。OrderId、OrderStatus、BuyerName、BuyerIdentityGuidを含む |
| 1-3 | OrderStatusChangedToSubmittedIntegrationEvent.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToSubmittedIntegrationEvent.cs` | 受信側のイベント定義。OrderStatusがstring型である点に注意 |

**読解のコツ**: C#のrecord型は不変データ構造。プロパティはget-onlyで定義され、コンストラクタで初期化される。

#### Step 2: エントリーポイントを理解する

イベント発行の起点となるDomainEventHandlerを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandler.cs | `src/Ordering.API/Application/DomainEventHandlers/ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandler.cs` | OrderStartedDomainEventを処理し、IntegrationEventを発行する |

**主要処理フロー**:
1. **行23**: バイヤー情報をリポジトリから検索
2. **行34-40**: 支払い方法の検証・追加
3. **行47-48**: SaveEntitiesAsyncでデータベース保存
4. **行50**: IntegrationEventのインスタンス作成
5. **行51**: AddAndSaveEventAsyncでイベントをキューに追加

#### Step 3: イベント発行サービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OrderingIntegrationEventService.cs | `src/Ordering.API/Application/IntegrationEvents/OrderingIntegrationEventService.cs` | AddAndSaveEventAsyncでイベントを保存し、PublishEventsThroughEventBusAsyncで発行 |

**主要処理フロー**:
- **行36-41**: AddAndSaveEventAsyncでイベントログに保存
- **行13-34**: PublishEventsThroughEventBusAsyncでEventBus経由で発行

#### Step 4: WebApp側のイベントハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | OrderStatusChangedToSubmittedIntegrationEventHandler.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToSubmittedIntegrationEventHandler.cs` | イベント受信後、OrderStatusNotificationServiceに通知を委譲 |
| 4-2 | OrderStatusNotificationService.cs | `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs` | 購入者IDベースでサブスクリプション管理、コールバック実行 |

**主要処理フロー**:
- **行10-14（Handler）**: イベント受信→NotifyOrderStatusChangedAsync呼び出し
- **行27-34（Service）**: 購入者IDでサブスクリプション検索→コールバック実行

#### Step 5: UI更新コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | OrdersRefreshOnStatusChange.razor | `src/WebApp/Components/Pages/User/OrdersRefreshOnStatusChange.razor` | Blazorコンポーネント。購入者IDでサブスクライブし、通知受信時にNav.Refresh()を呼び出す |

**主要処理フロー**:
- **行10-20**: firstRender時にサブスクリプション登録
- **行23-35**: HandleOrderStatusChangedでNav.Refresh()を実行

### プログラム呼び出し階層図

```
CreateOrderCommand
    │
    ├─ Order.AddOrderStartedDomainEvent()
    │
    └─ MediatR.Publish(OrderStartedDomainEvent)
           │
           └─ ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandler.Handle()
                  │
                  ├─ BuyerRepository.FindAsync()
                  ├─ Buyer.VerifyOrAddPaymentMethod()
                  ├─ BuyerRepository.UnitOfWork.SaveEntitiesAsync()
                  │
                  └─ OrderingIntegrationEventService.AddAndSaveEventAsync()
                         │
                         └─ IntegrationEventLogService.SaveEventAsync()

[トランザクションコミット後]

OrderingIntegrationEventService.PublishEventsThroughEventBusAsync()
    │
    └─ EventBus.PublishAsync(OrderStatusChangedToSubmittedIntegrationEvent)
           │
           └─ [WebApp] OrderStatusChangedToSubmittedIntegrationEventHandler.Handle()
                  │
                  └─ OrderStatusNotificationService.NotifyOrderStatusChangedAsync()
                         │
                         └─ Subscription.NotifyAsync() → callback()
                                │
                                └─ Nav.Refresh()
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

OrderStartedDomainEvent ───▶ ValidateOrAddBuyerAggregate... ───▶ IntegrationEventLog
      │                              │                                    │
      │                              ▼                                    ▼
      │                    OrderingIntegrationEventService ───▶ EventBus(RabbitMQ等)
      │                                                                   │
      ▼                                                                   ▼
Order/Buyer情報 ──────────────────────────────────────────▶ WebApp EventHandler
                                                                          │
                                                                          ▼
                                                           OrderStatusNotificationService
                                                                          │
                                                                          ▼
                                                           ブラウザ画面更新（Nav.Refresh）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IntegrationEvent.cs | `src/EventBus/Events/IntegrationEvent.cs` | ソース | 基底イベントクラス |
| IIntegrationEventHandler.cs | `src/EventBus/Abstractions/IIntegrationEventHandler.cs` | ソース | イベントハンドラインターフェース |
| OrderStatusChangedToSubmittedIntegrationEvent.cs | `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedTosubmittedIntegrationEvent.cs` | ソース | 発行側イベント定義 |
| ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandler.cs | `src/Ordering.API/Application/DomainEventHandlers/ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandler.cs` | ソース | イベント発行起点 |
| OrderingIntegrationEventService.cs | `src/Ordering.API/Application/IntegrationEvents/OrderingIntegrationEventService.cs` | ソース | イベント発行サービス |
| OrderStatusChangedToSubmittedIntegrationEvent.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToSubmittedIntegrationEvent.cs` | ソース | 受信側イベント定義 |
| OrderStatusChangedToSubmittedIntegrationEventHandler.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToSubmittedIntegrationEventHandler.cs` | ソース | 受信側イベントハンドラ |
| OrderStatusNotificationService.cs | `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs` | ソース | 通知配信サービス |
| OrdersRefreshOnStatusChange.razor | `src/WebApp/Components/Pages/User/OrdersRefreshOnStatusChange.razor` | ソース | UI更新Blazorコンポーネント |
