# 通知設計書 10-注文エラーアラート

## 概要

本ドキュメントは、eShopシステムのモバイルアプリ（ClientApp）における注文エラーアラートの設計仕様を定義するものである。

### 本通知の処理概要

本通知は、モバイルアプリで注文処理中にエラーが発生した際に、アラートダイアログを表示してユーザーにエラーを通知する機能である。CheckoutViewModelのCheckoutAsyncメソッドで例外が発生すると、catchブロックでDialogServiceのShowAlertAsyncメソッドを介して「An error ocurred. Please, try again.」というメッセージのアラートダイアログが表示される。

**業務上の目的・背景**：モバイルアプリにおいて、注文処理の失敗をユーザーに明確に伝えることは、ユーザー体験の維持において重要である。エラーが発生した場合、ユーザーに再試行を促すことで、注文の完了を支援する。

**通知の送信タイミング**：CheckoutAsyncメソッドのtry-catchブロックで例外がキャッチされた直後にアラートダイアログが表示される。

**通知の受信者**：注文を実行したモバイルアプリユーザー（端末上でアプリを操作中のユーザー）。

**通知内容の概要**：タイトル「Oops!」、メッセージ「An error ocurred. Please, try again.」、ボタン「Ok」のシンプルなアラートダイアログ。

**期待されるアクション**：ユーザーは「Ok」ボタンをタップしてダイアログを閉じ、再度注文を試みるか、問題が解決しない場合はカスタマーサポートに連絡する。

## 通知種別

UIアラート（.NET MAUIアラートダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（UI直接表示） |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

1. CheckoutAsyncメソッド内で例外が発生した場合に表示
2. ユーザー操作（Checkoutボタンタップ）後の処理で例外をキャッチ

## 通知テンプレート

### アラートダイアログ仕様

| 項目 | 内容 |
|-----|------|
| ダイアログタイプ | Alert（DisplayAlert） |
| タイトル | Oops! |
| メッセージ | An error ocurred. Please, try again. |
| ボタン | Ok |

### 本文テンプレート

```
An error ocurred. Please, try again.
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | アラートメッセージ | ハードコード | Yes |
| title | アラートタイトル | ハードコード | Yes |
| buttonLabel | ボタンラベル | ハードコード | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 例外発生 | CheckoutAsyncで例外キャッチ | try-catchブロックで例外が発生 | 注文処理中に任意の例外が発生した場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 注文処理成功 | 例外が発生せずに正常完了した場合（代わりに成功アラートが表示される） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザー: Checkoutボタンタップ] --> B[CheckoutAsyncメソッド実行]
    B --> C[try ブロック開始]
    C --> D[MapOrderToBasket]
    D --> E[OrderService.CreateOrderAsync]
    E --> F{例外発生?}
    F -->|No| G[成功処理→成功アラート表示]
    F -->|Yes| H[catch ブロック]
    H --> I[Console.WriteLine ex]
    I --> J[DialogService.ShowAlertAsync エラーメッセージ]
    J --> K[AppShell.Current.DisplayAlert]
    K --> L[アラートダイアログ表示]
    L --> M[ユーザー: Okボタンタップ]
    M --> N[ダイアログ閉じる]
    N --> O[ユーザーが再試行可能]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（クライアントサイドUIのみ）

### 更新テーブル一覧

該当なし（クライアントサイドUIのみ）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ネットワークエラー | API呼び出し中の接続失敗 | エラーアラートを表示し、再試行を促す |
| サーバーエラー | APIからのエラーレスポンス | エラーアラートを表示し、再試行を促す |
| バリデーションエラー | 注文データの不正 | エラーアラートを表示し、再試行を促す |
| 認証エラー | ユーザー認証の失敗 | エラーアラートを表示し、再試行を促す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（ユーザーが再度操作） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間365日表示可能）

## セキュリティ考慮事項

- アラートダイアログは端末ローカルで表示されるため、外部への情報漏洩リスクは低い
- 例外の詳細情報はConsole.WriteLineでログ出力されるが、ユーザーには表示されない
- エラーメッセージは汎用的な内容で、機密情報を含まない

## 備考

- 本アラートは.NET MAUIのDisplayAlertを使用しており、iOS/Android両プラットフォームでネイティブのアラートダイアログとして表示される
- メッセージは現在ハードコードされているが、将来的には多言語対応のためリソースファイルへの外出しを検討すべき
- メッセージ「An error ocurred」には「occurred」のスペルミスがある（原文ママ）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、DialogServiceのインターフェースと実装を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IDialogService.cs | `src/ClientApp/Services/Dialog/IDialogService.cs` | ShowAlertAsyncメソッドのインターフェース定義 |
| 1-2 | DialogService.cs | `src/ClientApp/Services/Dialog/DialogService.cs` | AppShell.Current.DisplayAlertを使用した実装 |

**読解のコツ**: .NET MAUIのDisplayAlertはモーダルダイアログを表示するプラットフォーム標準のAPIである。

#### Step 2: エントリーポイントを理解する

エラーアラート表示の起点となるViewModelを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CheckoutViewModel.cs | `src/ClientApp/ViewModels/CheckoutViewModel.cs` | CheckoutAsyncメソッドのcatchブロックでエラーアラート表示 |

**主要処理フロー**:
1. **行105-133**: CheckoutAsyncメソッド全体
2. **行107**: tryブロック開始
3. **行129**: catch (Exception ex) で全例外をキャッチ
4. **行131**: Console.WriteLine(ex) でログ出力
5. **行132**: DialogService.ShowAlertAsyncでエラーアラート表示
6. **行132**: メッセージ "An error ocurred. Please, try again."
7. **行132**: タイトル "Oops!"
8. **行132**: ボタン "Ok"

#### Step 3: エラー発生の可能性がある処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IOrderService.cs | `src/ClientApp/Services/Order/IOrderService.cs` | CreateOrderAsyncメソッドの定義 |

### プログラム呼び出し階層図

```
[ユーザー操作] Checkoutボタンタップ
    │
    └─ CheckoutCommand.Execute()
           │
           └─ CheckoutViewModel.CheckoutAsync()
                  │
                  └─ try {
                         │
                         ├─ _appEnvironmentService.OrderService.MapOrderToBasket(Order)
                         │
                         ├─ _appEnvironmentService.OrderService.CreateOrderAsync(Order)
                         │           │
                         │           └─ [例外発生の可能性]
                         │
                         ├─ _appEnvironmentService.BasketService.ClearBasketAsync()
                         │
                         └─ ...
                     }
                     catch (Exception ex) {
                         │
                         ├─ Console.WriteLine(ex)
                         │
                         └─ _dialogService.ShowAlertAsync("An error ocurred...", "Oops!", "Ok")
                                │
                                └─ AppShell.Current.DisplayAlert(title, message, buttonLabel)
                                       │
                                       └─ [Platform] ネイティブアラートダイアログ表示
                     }
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

ユーザー操作                            │
(Checkoutボタンタップ) ─────────────────▶ CheckoutAsyncメソッド
                                        │
                                        ├─ try {
                                        │    注文処理...
                                        │  }
                                        │
                                        └─ catch (Exception ex) {
                                             │
                                             ├─ ログ出力
                                             │  (Console.WriteLine)
                                             │
                                             └─ アラート表示 ───▶ DisplayAlert
                                                                      │
                                                                      ▼
                                                              ネイティブダイアログ
                                                              "An error ocurred..."
                                           }
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CheckoutViewModel.cs | `src/ClientApp/ViewModels/CheckoutViewModel.cs` | ソース | 注文処理とエラーハンドリングのViewModel |
| IDialogService.cs | `src/ClientApp/Services/Dialog/IDialogService.cs` | ソース | ダイアログサービスインターフェース |
| DialogService.cs | `src/ClientApp/Services/Dialog/DialogService.cs` | ソース | ダイアログサービス実装 |
| IOrderService.cs | `src/ClientApp/Services/Order/IOrderService.cs` | ソース | 注文サービスインターフェース |
| MockDialogService.cs | `tests/ClientApp.UnitTests/Mocks/MockDialogService.cs` | テスト | テスト用モックサービス |
