# 通知設計書 2-在庫検証待ち通知

## 概要

本ドキュメントは、eShopシステムにおける在庫検証待ち通知（OrderStatusChangedToAwaitingValidationIntegrationEvent）の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、注文が在庫検証待ち状態（AwaitingValidation）に遷移したことを購入者にリアルタイムで通知する機能である。注文の猶予期間（GracePeriod）が終了し、在庫検証プロセスが開始されると、OrderStatusChangedToAwaitingValidationDomainEventが発火し、それを契機としてIntegrationEventが生成される。EventBus経由でWebAppに送信され、該当購入者のブラウザ画面が自動的に更新される。また、同時にCatalog.APIにも送信され、在庫の検証処理がトリガーされる。

**業務上の目的・背景**：ECシステムにおいて、注文処理の進捗状況を購入者に透明性をもって伝えることは、顧客満足度向上に不可欠である。在庫検証待ち状態は、注文商品の在庫が実際に確保できるかを確認するフェーズであり、この状態を購入者に通知することで、注文処理が進行中であることを安心して確認できる。

**通知の送信タイミング**：注文の猶予期間確認後、Order集約のSetAwaitingValidationStatusメソッドが呼び出され、OrderStatusChangedToAwaitingValidationDomainEventが発火した直後にIntegrationEventが発行される。

**通知の受信者**：注文を行った購入者（BuyerIdentityGuidで識別）が受信対象となる。WebApp上で当該購入者のセッションに紐づくサブスクリプションにのみ通知が配信される。

**通知内容の概要**：注文ID、注文ステータス（AwaitingValidation）、購入者名、購入者識別子、注文商品リスト（商品ID、数量）の情報が含まれる。注文商品リストはCatalog.API側での在庫検証に使用される。

**期待されるアクション**：購入者は画面が自動更新されることで、注文が在庫検証段階に進んだことを確認できる。在庫検証結果を待つ間、注文履歴画面でステータスを確認できる。

## 通知種別

アプリ内通知（WebApp SignalR経由のリアルタイム画面更新）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventBus経由） |
| 優先度 | 中 |
| リトライ | EventBusレベルでのリトライ機構による |

### 送信先決定ロジック

1. IntegrationEventに含まれるBuyerIdentityGuidを取得
2. OrderStatusNotificationServiceの_subscriptionsByBuyerIdディクショナリから該当するサブスクリプションを検索
3. 該当するすべてのサブスクリプション（同一ユーザーの複数ブラウザセッション等）にコールバックを実行

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、アプリ内リアルタイム通知のため該当なし。

### 本文テンプレート

本通知は画面自動更新のためのシグナルであり、テキスト本文は存在しない。

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| OrderId | 注文ID | Order.Id | Yes |
| OrderStatus | 注文ステータス | Order.OrderStatus | Yes |
| BuyerName | 購入者名 | Buyer.Name | Yes |
| BuyerIdentityGuid | 購入者識別子 | Buyer.IdentityGuid | Yes |
| OrderStockItems | 注文商品リスト | OrderItems（ProductId, Units） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ドメインイベント | OrderStatusChangedToAwaitingValidationDomainEvent | 猶予期間終了後、在庫検証開始時 | Order集約のSetAwaitingValidationStatusメソッド呼び出し時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 注文情報取得失敗 | OrderRepositoryからの注文取得に失敗した場合 |
| 購入者情報取得失敗 | BuyerRepositoryからの購入者取得に失敗した場合 |
| 該当サブスクリプションなし | WebApp側で購入者のサブスクリプションが存在しない場合（エラーにはならない） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[GracePeriodConfirmedIntegrationEvent受信] --> B[GracePeriodConfirmedIntegrationEventHandler]
    B --> C[SetAwaitingValidationStatusCommand実行]
    C --> D[Order.SetAwaitingValidationStatus]
    D --> E[OrderStatusChangedToAwaitingValidationDomainEvent発火]
    E --> F[OrderStatusChangedToAwaitingValidationDomainEventHandler]
    F --> G[注文情報・購入者情報取得]
    G --> H[OrderStatusChangedToAwaitingValidationIntegrationEvent作成]
    H --> I[AddAndSaveEventAsync]
    I --> J[EventBus経由で発行]
    J --> K1[WebApp EventHandler受信]
    J --> K2[Catalog.API EventHandler受信]
    K1 --> L[OrderStatusNotificationService.NotifyOrderStatusChangedAsync]
    L --> M[該当サブスクリプションのコールバック実行]
    M --> N[ブラウザ画面更新 Nav.Refresh]
    K2 --> O[在庫検証処理開始]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Orders | 注文情報取得 | 注文ID、ステータス、購入者ID取得 |
| Buyers | 購入者情報取得 | 購入者名、識別子取得 |
| OrderItems | 注文商品情報取得 | 商品ID、数量取得 |

### テーブル別参照項目詳細

#### Orders

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Id | 注文ID | DomainEventのOrderIdで検索 |
| OrderStatus | 注文ステータス | 同上 |
| BuyerId | 購入者ID | 同上 |

#### Buyers

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Name | 購入者名 | Order.BuyerIdで検索 |
| IdentityGuid | 購入者識別子 | 同上 |

#### OrderItems

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| ProductId | 商品ID | DomainEventから取得 |
| Units | 数量 | 同上 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| IntegrationEventLog | INSERT | イベントログの保存 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | EventId | IntegrationEvent.Id | イベント一意識別子 |
| INSERT | EventTypeName | イベント型名 | OrderStatusChangedToAwaitingValidationIntegrationEvent |
| INSERT | State | Pending→InProgress→Published/Failed | 送信状態 |
| INSERT | Content | JSONシリアライズされたイベント内容 | イベントデータ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 注文取得エラー | OrderRepositoryからの取得失敗 | 例外をスローし、トランザクションロールバック |
| 購入者取得エラー | BuyerRepositoryからの取得失敗 | 例外をスローし、トランザクションロールバック |
| イベント発行失敗 | EventBus接続エラー | MarkEventAsFailedAsyncでログ記録、リトライキューへ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | EventBus実装依存 |
| リトライ間隔 | EventBus実装依存 |
| リトライ対象エラー | 一時的なネットワークエラー、接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間365日配信可能）

## セキュリティ考慮事項

- BuyerIdentityGuidは認証済みユーザーの識別子として使用され、他ユーザーの通知を受信することはできない
- IntegrationEventはシステム内部のEventBus経由でのみ送信され、外部からの偽装は不可能
- OrderStockItemsには商品IDと数量のみ含まれ、価格情報等の機密情報は含まれない

## 備考

- 本イベントはマルチキャスト的に配信され、WebApp（画面更新用）とCatalog.API（在庫検証用）の両方で受信される
- OrderStockItems情報はCatalog.APIでの在庫検証処理で使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、IntegrationEventのデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OrderStatusChangedToAwaitingValidationIntegrationEvent.cs | `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToAwaitingValidationIntegrationEvent.cs` | 発行側イベント定義。OrderStockItemsリストを含む点が特徴 |
| 1-2 | OrderStockItem（同ファイル内） | `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToAwaitingValidationIntegrationEvent.cs` | ProductIdとUnitsを持つrecord |
| 1-3 | OrderStatusChangedToAwaitingValidationIntegrationEvent.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToAwaitingValidationIntegrationEvent.cs` | 受信側（WebApp）イベント定義 |

**読解のコツ**: OrderStockItemはイベント内で定義されたネストされたrecord型。Catalog.API側の在庫検証で必要な最小限の情報のみを含む。

#### Step 2: エントリーポイントを理解する

イベント発行の起点となるDomainEventHandlerを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OrderStatusChangedToAwaitingValidationDomainEventHandler.cs | `src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToAwaitingValidationDomainEventHandler.cs` | DomainEventを処理し、IntegrationEventを発行 |

**主要処理フロー**:
1. **行25**: ログ出力でステータス更新を記録
2. **行27**: OrderRepositoryから注文取得
3. **行28**: BuyerRepositoryから購入者取得
4. **行30-31**: OrderStockItemリストを作成
5. **行33**: IntegrationEventインスタンス作成
6. **行34**: AddAndSaveEventAsyncでイベントをキューに追加

#### Step 3: WebApp側のイベントハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs` | イベント受信後、OrderStatusNotificationServiceに通知を委譲 |
| 3-2 | OrderStatusNotificationService.cs | `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs` | 購入者IDベースでサブスクリプション管理 |

**主要処理フロー**:
- **行10-14（Handler）**: イベント受信→NotifyOrderStatusChangedAsync呼び出し
- **行27-34（Service）**: 購入者IDでサブスクリプション検索→コールバック実行

#### Step 4: Catalog.API側の在庫検証ハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs | `src/Catalog.API/IntegrationEvents/EventHandling/OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs` | 在庫検証処理を実行し、結果イベントを発行 |

### プログラム呼び出し階層図

```
GracePeriodConfirmedIntegrationEvent受信
    │
    └─ GracePeriodConfirmedIntegrationEventHandler.Handle()
           │
           └─ mediator.Send(SetAwaitingValidationStatusCommand)
                  │
                  └─ Order.SetAwaitingValidationStatus()
                         │
                         └─ AddDomainEvent(OrderStatusChangedToAwaitingValidationDomainEvent)
                                │
                                └─ MediatR.Publish(DomainEvent)
                                       │
                                       └─ OrderStatusChangedToAwaitingValidationDomainEventHandler.Handle()
                                              │
                                              ├─ OrderRepository.GetAsync()
                                              ├─ BuyerRepository.FindByIdAsync()
                                              │
                                              └─ OrderingIntegrationEventService.AddAndSaveEventAsync()

[トランザクションコミット後]

OrderingIntegrationEventService.PublishEventsThroughEventBusAsync()
    │
    └─ EventBus.PublishAsync(OrderStatusChangedToAwaitingValidationIntegrationEvent)
           │
           ├─ [WebApp] EventHandler → OrderStatusNotificationService → Nav.Refresh()
           │
           └─ [Catalog.API] EventHandler → 在庫検証処理
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

OrderStatusChangedToAwaitingValidation  →  DomainEventHandler  →  IntegrationEventLog
DomainEvent                                      │                         │
      │                                          ▼                         ▼
      │                               OrderingIntegrationEventService → EventBus
      │                                                                    │
      ▼                                                            ┌──────┴──────┐
Order/Buyer/OrderItems情報                                          ▼              ▼
                                                              WebApp           Catalog.API
                                                                 │                  │
                                                                 ▼                  ▼
                                                          画面更新          在庫検証処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OrderStatusChangedToAwaitingValidationIntegrationEvent.cs | `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToAwaitingValidationIntegrationEvent.cs` | ソース | 発行側イベント定義 |
| OrderStatusChangedToAwaitingValidationDomainEvent.cs | `src/Ordering.Domain/Events/OrderStatusChangedToAwaitingValidationDomainEvent.cs` | ソース | ドメインイベント定義 |
| OrderStatusChangedToAwaitingValidationDomainEventHandler.cs | `src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToAwaitingValidationDomainEventHandler.cs` | ソース | イベント発行起点 |
| OrderStatusChangedToAwaitingValidationIntegrationEvent.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToAwaitingValidationIntegrationEvent.cs` | ソース | 受信側（WebApp）イベント定義 |
| OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs` | ソース | WebApp側ハンドラ |
| OrderStatusChangedToAwaitingValidationIntegrationEvent.cs | `src/Catalog.API/IntegrationEvents/Events/OrderStatusChangedToAwaitingValidationIntegrationEvent.cs` | ソース | 受信側（Catalog）イベント定義 |
| OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs | `src/Catalog.API/IntegrationEvents/EventHandling/OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs` | ソース | Catalog.API側ハンドラ |
| OrderStatusNotificationService.cs | `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs` | ソース | 通知配信サービス |
| OrdersRefreshOnStatusChange.razor | `src/WebApp/Components/Pages/User/OrdersRefreshOnStatusChange.razor` | ソース | UI更新Blazorコンポーネント |
