# 通知設計書 3-在庫確認完了通知

## 概要

本ドキュメントは、eShopシステムにおける在庫確認完了通知（OrderStatusChangedToStockConfirmedIntegrationEvent）の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、注文商品の在庫が確認され、注文ステータスがStockConfirmed（在庫確認済み）に遷移したことを購入者にリアルタイムで通知する機能である。Catalog.APIでの在庫検証処理が成功し、OrderStockConfirmedIntegrationEventがOrdering.APIで受信されると、Order集約のステータスが更新され、OrderStatusChangedToStockConfirmedDomainEventが発火する。これを契機としてIntegrationEventが生成され、EventBus経由でWebAppに送信される。

**業務上の目的・背景**：在庫検証は注文処理の重要なチェックポイントである。在庫が確認できたことを購入者に通知することで、注文処理が順調に進んでいることを安心して確認できる。在庫確認後は決済処理に進むため、購入者にとって重要なマイルストーンとなる。

**通知の送信タイミング**：Catalog.APIからのOrderStockConfirmedIntegrationEventを受信し、OrderStockConfirmedIntegrationEventHandlerがSetStockConfirmedStatusCommandを実行した後、Order集約のSetStockConfirmedStatusメソッドが呼び出され、DomainEventが発火した直後にIntegrationEventが発行される。

**通知の受信者**：注文を行った購入者（BuyerIdentityGuidで識別）が受信対象となる。WebApp上で当該購入者のセッションに紐づくサブスクリプションにのみ通知が配信される。

**通知内容の概要**：注文ID、注文ステータス（StockConfirmed）、購入者名、購入者識別子の情報が含まれる。

**期待されるアクション**：購入者は画面が自動更新されることで、注文商品の在庫が確保されたことを確認できる。次の決済処理を待つ間、注文履歴画面でステータスを確認できる。

## 通知種別

アプリ内通知（WebApp SignalR経由のリアルタイム画面更新）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventBus経由） |
| 優先度 | 中 |
| リトライ | EventBusレベルでのリトライ機構による |

### 送信先決定ロジック

1. IntegrationEventに含まれるBuyerIdentityGuidを取得
2. OrderStatusNotificationServiceの_subscriptionsByBuyerIdディクショナリから該当するサブスクリプションを検索
3. 該当するすべてのサブスクリプションにコールバックを実行

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、アプリ内リアルタイム通知のため該当なし。

### 本文テンプレート

本通知は画面自動更新のためのシグナルであり、テキスト本文は存在しない。

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| OrderId | 注文ID | Order.Id | Yes |
| OrderStatus | 注文ステータス | Order.OrderStatus | Yes |
| BuyerName | 購入者名 | Buyer.Name | Yes |
| BuyerIdentityGuid | 購入者識別子 | Buyer.IdentityGuid | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ドメインイベント | OrderStatusChangedToStockConfirmedDomainEvent | Catalog.APIからの在庫確認成功イベント受信後 | Order集約のSetStockConfirmedStatusメソッド呼び出し時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 注文情報取得失敗 | OrderRepositoryからの注文取得に失敗した場合 |
| 購入者情報取得失敗 | BuyerRepositoryからの購入者取得に失敗した場合 |
| 該当サブスクリプションなし | WebApp側で購入者のサブスクリプションが存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Catalog.API: 在庫検証成功] --> B[OrderStockConfirmedIntegrationEvent発行]
    B --> C[Ordering.API: OrderStockConfirmedIntegrationEventHandler受信]
    C --> D[SetStockConfirmedStatusCommand実行]
    D --> E[Order.SetStockConfirmedStatus]
    E --> F[OrderStatusChangedToStockConfirmedDomainEvent発火]
    F --> G[OrderStatusChangedToStockConfirmedDomainEventHandler]
    G --> H[注文情報・購入者情報取得]
    H --> I[OrderStatusChangedToStockConfirmedIntegrationEvent作成]
    I --> J[AddAndSaveEventAsync]
    J --> K[EventBus経由で発行]
    K --> L[WebApp EventHandler受信]
    L --> M[OrderStatusNotificationService.NotifyOrderStatusChangedAsync]
    M --> N[該当サブスクリプションのコールバック実行]
    N --> O[ブラウザ画面更新 Nav.Refresh]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Orders | 注文情報取得 | 注文ID、ステータス、購入者ID取得 |
| Buyers | 購入者情報取得 | 購入者名、識別子取得 |

### テーブル別参照項目詳細

#### Orders

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Id | 注文ID | DomainEventのOrderIdで検索 |
| OrderStatus | 注文ステータス | 同上 |
| BuyerId | 購入者ID | 同上 |

#### Buyers

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Name | 購入者名 | Order.BuyerIdで検索 |
| IdentityGuid | 購入者識別子 | 同上 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| IntegrationEventLog | INSERT | イベントログの保存 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | EventId | IntegrationEvent.Id | イベント一意識別子 |
| INSERT | EventTypeName | イベント型名 | OrderStatusChangedToStockConfirmedIntegrationEvent |
| INSERT | State | Pending→InProgress→Published/Failed | 送信状態 |
| INSERT | Content | JSONシリアライズされたイベント内容 | イベントデータ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 注文取得エラー | OrderRepositoryからの取得失敗 | 例外をスローし、トランザクションロールバック |
| 購入者取得エラー | BuyerRepositoryからの取得失敗 | 例外をスローし、トランザクションロールバック |
| イベント発行失敗 | EventBus接続エラー | MarkEventAsFailedAsyncでログ記録、リトライキューへ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | EventBus実装依存 |
| リトライ間隔 | EventBus実装依存 |
| リトライ対象エラー | 一時的なネットワークエラー、接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間365日配信可能）

## セキュリティ考慮事項

- BuyerIdentityGuidは認証済みユーザーの識別子として使用され、他ユーザーの通知を受信することはできない
- IntegrationEventはシステム内部のEventBus経由でのみ送信され、外部からの偽装は不可能

## 備考

- 本イベントは在庫検証プロセスの成功を示すマイルストーン通知である
- 在庫検証が失敗した場合は、OrderStockRejectedIntegrationEventが発行され、別の処理フローとなる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、IntegrationEventのデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OrderStatusChangedToStockConfirmedIntegrationEvent.cs | `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToStockConfirmedIntegrationEvent.cs` | 発行側イベント定義。OrderId, OrderStatus, BuyerName, BuyerIdentityGuidを含む |
| 1-2 | OrderStatusChangedToStockConfirmedIntegrationEvent.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToStockConfirmedIntegrationEvent.cs` | 受信側（WebApp）イベント定義 |

**読解のコツ**: このイベントはAwaitingValidationと異なり、OrderStockItemsを含まない。在庫確認済みの通知のため、商品情報は不要。

#### Step 2: エントリーポイントを理解する

イベント発行の起点となるDomainEventHandlerを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OrderStatusChangedToStockConfirmedDomainEventHandler.cs | `src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToStockConfirmedDomainEventHandler.cs` | DomainEventを処理し、IntegrationEventを発行 |

**主要処理フロー**:
1. **行25**: ログ出力でステータス更新を記録
2. **行27**: OrderRepositoryから注文取得
3. **行28**: BuyerRepositoryから購入者取得
4. **行30**: IntegrationEventインスタンス作成
5. **行31**: AddAndSaveEventAsyncでイベントをキューに追加

#### Step 3: トリガーとなる受信イベントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OrderStockConfirmedIntegrationEventHandler.cs | `src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderStockConfirmedIntegrationEventHandler.cs` | Catalog.APIからの在庫確認成功イベントを受信 |

#### Step 4: WebApp側のイベントハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | OrderStatusChangedToStockConfirmedIntegrationEventHandler.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToStockConfirmedIntegrationEventHandler.cs` | イベント受信後、OrderStatusNotificationServiceに通知を委譲 |

**主要処理フロー**:
- **行10-14**: イベント受信→NotifyOrderStatusChangedAsync呼び出し

### プログラム呼び出し階層図

```
[Catalog.API] OrderStockConfirmedIntegrationEvent発行
    │
    └─ [Ordering.API] OrderStockConfirmedIntegrationEventHandler.Handle()
           │
           └─ mediator.Send(SetStockConfirmedStatusCommand)
                  │
                  └─ Order.SetStockConfirmedStatus()
                         │
                         └─ AddDomainEvent(OrderStatusChangedToStockConfirmedDomainEvent)
                                │
                                └─ MediatR.Publish(DomainEvent)
                                       │
                                       └─ OrderStatusChangedToStockConfirmedDomainEventHandler.Handle()
                                              │
                                              ├─ OrderRepository.GetAsync()
                                              ├─ BuyerRepository.FindByIdAsync()
                                              │
                                              └─ OrderingIntegrationEventService.AddAndSaveEventAsync()

[トランザクションコミット後]

OrderingIntegrationEventService.PublishEventsThroughEventBusAsync()
    │
    └─ EventBus.PublishAsync(OrderStatusChangedToStockConfirmedIntegrationEvent)
           │
           └─ [WebApp] EventHandler → OrderStatusNotificationService → Nav.Refresh()
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

[Catalog.API]                           │
OrderStockConfirmedIntegrationEvent ────┼───▶ Ordering.API受信
                                        │           │
                                        │           ▼
                                        │    SetStockConfirmedStatusCommand
                                        │           │
                                        │           ▼
                                        │    Order.SetStockConfirmedStatus()
                                        │           │
                                        │           ▼
                                        │    DomainEventHandler
                                        │           │
                                        │           ▼
                                        │    IntegrationEvent作成 ───▶ EventBus
                                        │                                │
                                        │                                ▼
                                        │                          [WebApp]
                                        │                          画面更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OrderStatusChangedToStockConfirmedIntegrationEvent.cs | `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToStockConfirmedIntegrationEvent.cs` | ソース | 発行側イベント定義 |
| OrderStatusChangedToStockConfirmedDomainEvent.cs | `src/Ordering.Domain/Events/OrderStatusChangedToStockConfirmedDomainEvent.cs` | ソース | ドメインイベント定義 |
| OrderStatusChangedToStockConfirmedDomainEventHandler.cs | `src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToStockConfirmedDomainEventHandler.cs` | ソース | イベント発行起点 |
| OrderStockConfirmedIntegrationEventHandler.cs | `src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderStockConfirmedIntegrationEventHandler.cs` | ソース | トリガーイベントのハンドラ |
| OrderStatusChangedToStockConfirmedIntegrationEvent.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToStockConfirmedIntegrationEvent.cs` | ソース | 受信側（WebApp）イベント定義 |
| OrderStatusChangedToStockConfirmedIntegrationEventHandler.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToStockConfirmedIntegrationEventHandler.cs` | ソース | WebApp側ハンドラ |
| OrderStatusNotificationService.cs | `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs` | ソース | 通知配信サービス |
| OrdersRefreshOnStatusChange.razor | `src/WebApp/Components/Pages/User/OrdersRefreshOnStatusChange.razor` | ソース | UI更新Blazorコンポーネント |
