# 通知設計書 4-支払完了通知

## 概要

本ドキュメントは、eShopシステムにおける支払完了通知（OrderStatusChangedToPaidIntegrationEvent）の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、注文の支払いが完了し、注文ステータスがPaid（支払済み）に遷移したことを購入者にリアルタイムで通知する機能である。PaymentProcessorサービスでの決済シミュレーションが成功し、OrderPaymentSucceededIntegrationEventがOrdering.APIで受信されると、Order集約のステータスが更新され、OrderStatusChangedToPaidDomainEventが発火する。これを契機としてIntegrationEventが生成され、EventBus経由でWebApp、Catalog.API、Webhooks.APIに送信される。

**業務上の目的・背景**：支払完了は注文処理において最も重要なマイルストーンの一つである。購入者に支払いが正常に処理されたことを即座に通知することで、安心感を提供し、カスタマーサポートへの問い合わせを削減できる。また、この通知をトリガーとして、在庫の実際の引き当て処理やWebhook外部連携が実行される。

**通知の送信タイミング**：PaymentProcessorからのOrderPaymentSucceededIntegrationEventを受信し、OrderPaymentSucceededIntegrationEventHandlerがSetPaidStatusCommandを実行した後、Order集約のSetPaidStatusメソッドが呼び出され、DomainEventが発火した直後にIntegrationEventが発行される。

**通知の受信者**：注文を行った購入者（BuyerIdentityGuidで識別）がWebAppの画面更新通知を受信する。また、Catalog.APIとWebhooks.APIもイベントを受信し、それぞれ在庫引当処理とWebhook送信処理を実行する。

**通知内容の概要**：注文ID、注文ステータス（Paid）、購入者名、購入者識別子、注文商品リスト（商品ID、数量）の情報が含まれる。注文商品リストはCatalog.APIでの在庫引当処理で使用される。

**期待されるアクション**：購入者は画面が自動更新されることで、支払いが完了したことを確認できる。次の出荷処理を待つ間、注文履歴画面でステータスを確認できる。

## 通知種別

アプリ内通知（WebApp SignalR経由のリアルタイム画面更新）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventBus経由） |
| 優先度 | 高 |
| リトライ | EventBusレベルでのリトライ機構による |

### 送信先決定ロジック

1. IntegrationEventに含まれるBuyerIdentityGuidを取得
2. OrderStatusNotificationServiceの_subscriptionsByBuyerIdディクショナリから該当するサブスクリプションを検索
3. 該当するすべてのサブスクリプションにコールバックを実行

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、アプリ内リアルタイム通知のため該当なし。

### 本文テンプレート

本通知は画面自動更新のためのシグナルであり、テキスト本文は存在しない。

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| OrderId | 注文ID | Order.Id | Yes |
| OrderStatus | 注文ステータス | Order.OrderStatus | Yes |
| BuyerName | 購入者名 | Buyer.Name | Yes |
| BuyerIdentityGuid | 購入者識別子 | Buyer.IdentityGuid | Yes |
| OrderStockItems | 注文商品リスト | OrderItems（ProductId, Units） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ドメインイベント | OrderStatusChangedToPaidDomainEvent | PaymentProcessorからの支払い成功イベント受信後 | Order集約のSetPaidStatusメソッド呼び出し時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 注文情報取得失敗 | OrderRepositoryからの注文取得に失敗した場合 |
| 購入者情報取得失敗 | BuyerRepositoryからの購入者取得に失敗した場合 |
| 該当サブスクリプションなし | WebApp側で購入者のサブスクリプションが存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[PaymentProcessor: 決済成功] --> B[OrderPaymentSucceededIntegrationEvent発行]
    B --> C[Ordering.API: OrderPaymentSucceededIntegrationEventHandler受信]
    C --> D[SetPaidStatusCommand実行]
    D --> E[Order.SetPaidStatus]
    E --> F[OrderStatusChangedToPaidDomainEvent発火]
    F --> G[OrderStatusChangedToPaidDomainEventHandler]
    G --> H[注文情報・購入者情報取得]
    H --> I[OrderStatusChangedToPaidIntegrationEvent作成]
    I --> J[AddAndSaveEventAsync]
    J --> K[EventBus経由で発行]
    K --> L1[WebApp EventHandler受信]
    K --> L2[Catalog.API EventHandler受信]
    K --> L3[Webhooks.API EventHandler受信]
    L1 --> M[OrderStatusNotificationService.NotifyOrderStatusChangedAsync]
    M --> N[ブラウザ画面更新 Nav.Refresh]
    L2 --> O[在庫引当処理]
    L3 --> P[Webhook外部送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Orders | 注文情報取得 | 注文ID、ステータス、購入者ID取得 |
| Buyers | 購入者情報取得 | 購入者名、識別子取得 |
| OrderItems | 注文商品情報取得 | 商品ID、数量取得 |

### テーブル別参照項目詳細

#### Orders

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Id | 注文ID | DomainEventのOrderIdで検索 |
| OrderStatus | 注文ステータス | 同上 |
| BuyerId | 購入者ID | 同上 |

#### Buyers

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Name | 購入者名 | Order.BuyerIdで検索 |
| IdentityGuid | 購入者識別子 | 同上 |

#### OrderItems

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| ProductId | 商品ID | DomainEventから取得 |
| Units | 数量 | 同上 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| IntegrationEventLog | INSERT | イベントログの保存 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | EventId | IntegrationEvent.Id | イベント一意識別子 |
| INSERT | EventTypeName | イベント型名 | OrderStatusChangedToPaidIntegrationEvent |
| INSERT | State | Pending→InProgress→Published/Failed | 送信状態 |
| INSERT | Content | JSONシリアライズされたイベント内容 | イベントデータ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 注文取得エラー | OrderRepositoryからの取得失敗 | 例外をスローし、トランザクションロールバック |
| 購入者取得エラー | BuyerRepositoryからの取得失敗 | 例外をスローし、トランザクションロールバック |
| イベント発行失敗 | EventBus接続エラー | MarkEventAsFailedAsyncでログ記録、リトライキューへ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | EventBus実装依存 |
| リトライ間隔 | EventBus実装依存 |
| リトライ対象エラー | 一時的なネットワークエラー、接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間365日配信可能）

## セキュリティ考慮事項

- BuyerIdentityGuidは認証済みユーザーの識別子として使用され、他ユーザーの通知を受信することはできない
- 支払い情報（カード番号等）はIntegrationEventに含まれない
- IntegrationEventはシステム内部のEventBus経由でのみ送信され、外部からの偽装は不可能

## 備考

- 本イベントはマルチキャスト的に配信され、WebApp、Catalog.API、Webhooks.APIの3つのサービスで受信される
- Catalog.APIでは在庫の実際の引き当て処理が実行される
- Webhooks.APIでは外部システムへのWebhook通知が送信される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、IntegrationEventのデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OrderStatusChangedToPaidIntegrationEvent.cs | `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToPaidIntegrationEvent.cs` | 発行側イベント定義。OrderStockItemsリストを含む点が特徴 |
| 1-2 | OrderStatusChangedToPaidIntegrationEvent.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToPaidIntegrationEvent.cs` | 受信側（WebApp）イベント定義 |
| 1-3 | OrderStatusChangedToPaidIntegrationEvent.cs | `src/Catalog.API/IntegrationEvents/Events/OrderStatusChangedToPaidIntegrationEvent.cs` | 受信側（Catalog）イベント定義 |
| 1-4 | OrderStatusChangedToPaidIntegrationEvent.cs | `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToPaidIntegrationEvent.cs` | 受信側（Webhooks）イベント定義 |

**読解のコツ**: 各サービスで受信するイベントの形式が微妙に異なる場合がある。特にOrderStockItemsの有無に注意。

#### Step 2: エントリーポイントを理解する

イベント発行の起点となるDomainEventHandlerを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OrderStatusChangedToPaidDomainEventHandler.cs | `src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToPaidDomainEventHandler.cs` | DomainEventを処理し、IntegrationEventを発行 |

**主要処理フロー**:
1. **行24**: ログ出力でステータス更新を記録
2. **行26**: OrderRepositoryから注文取得
3. **行27**: BuyerRepositoryから購入者取得
4. **行29-30**: OrderStockItemリストを作成
5. **行32-37**: IntegrationEventインスタンス作成
6. **行39**: AddAndSaveEventAsyncでイベントをキューに追加

#### Step 3: トリガーとなる受信イベントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OrderPaymentSucceededIntegrationEventHandler.cs | `src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderPaymentSucceededIntegrationEventHandler.cs` | PaymentProcessorからの支払い成功イベントを受信 |

#### Step 4: 各サービスのイベントハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | OrderStatusChangedToPaidIntegrationEventHandler.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToPaidIntegrationEventHandler.cs` | WebApp側ハンドラ - 画面更新 |
| 4-2 | OrderStatusChangedToPaidIntegrationEventHandler.cs | `src/Catalog.API/IntegrationEvents/EventHandling/OrderStatusChangedToPaidIntegrationEventHandler.cs` | Catalog.API側ハンドラ - 在庫引当 |
| 4-3 | OrderStatusChangedToPaidIntegrationEventHandler.cs | `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToPaidIntegrationEventHandler.cs` | Webhooks.API側ハンドラ - Webhook送信 |

### プログラム呼び出し階層図

```
[PaymentProcessor] OrderPaymentSucceededIntegrationEvent発行
    │
    └─ [Ordering.API] OrderPaymentSucceededIntegrationEventHandler.Handle()
           │
           └─ mediator.Send(SetPaidStatusCommand)
                  │
                  └─ Order.SetPaidStatus()
                         │
                         └─ AddDomainEvent(OrderStatusChangedToPaidDomainEvent)
                                │
                                └─ MediatR.Publish(DomainEvent)
                                       │
                                       └─ OrderStatusChangedToPaidDomainEventHandler.Handle()
                                              │
                                              ├─ OrderRepository.GetAsync()
                                              ├─ BuyerRepository.FindByIdAsync()
                                              │
                                              └─ OrderingIntegrationEventService.AddAndSaveEventAsync()

[トランザクションコミット後]

OrderingIntegrationEventService.PublishEventsThroughEventBusAsync()
    │
    └─ EventBus.PublishAsync(OrderStatusChangedToPaidIntegrationEvent)
           │
           ├─ [WebApp] EventHandler → OrderStatusNotificationService → Nav.Refresh()
           │
           ├─ [Catalog.API] EventHandler → 在庫引当処理
           │
           └─ [Webhooks.API] EventHandler → WebhooksSender → 外部HTTP送信
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

[PaymentProcessor]                      │
OrderPaymentSucceededIntegrationEvent ──┼───▶ Ordering.API受信
                                        │           │
                                        │           ▼
                                        │    SetPaidStatusCommand
                                        │           │
                                        │           ▼
                                        │    Order.SetPaidStatus()
                                        │           │
                                        │           ▼
                                        │    DomainEventHandler
                                        │           │
                                        │           ▼
                                        │    IntegrationEvent作成 ───▶ EventBus
                                        │                                │
                                        │                        ┌───────┼───────┐
                                        │                        ▼       ▼       ▼
                                        │                    WebApp  Catalog  Webhooks
                                        │                       │       │        │
                                        │                       ▼       ▼        ▼
                                        │                   画面更新 在庫引当 HTTP送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OrderStatusChangedToPaidIntegrationEvent.cs | `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToPaidIntegrationEvent.cs` | ソース | 発行側イベント定義 |
| OrderStatusChangedToPaidDomainEvent.cs | `src/Ordering.Domain/Events/OrderStatusChangedToPaidDomainEvent.cs` | ソース | ドメインイベント定義 |
| OrderStatusChangedToPaidDomainEventHandler.cs | `src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToPaidDomainEventHandler.cs` | ソース | イベント発行起点 |
| OrderPaymentSucceededIntegrationEventHandler.cs | `src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderPaymentSucceededIntegrationEventHandler.cs` | ソース | トリガーイベントのハンドラ |
| OrderStatusChangedToPaidIntegrationEvent.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToPaidIntegrationEvent.cs` | ソース | 受信側（WebApp）イベント定義 |
| OrderStatusChangedToPaidIntegrationEventHandler.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToPaidIntegrationEventHandler.cs` | ソース | WebApp側ハンドラ |
| OrderStatusChangedToPaidIntegrationEvent.cs | `src/Catalog.API/IntegrationEvents/Events/OrderStatusChangedToPaidIntegrationEvent.cs` | ソース | 受信側（Catalog）イベント定義 |
| OrderStatusChangedToPaidIntegrationEventHandler.cs | `src/Catalog.API/IntegrationEvents/EventHandling/OrderStatusChangedToPaidIntegrationEventHandler.cs` | ソース | Catalog.API側ハンドラ |
| OrderStatusChangedToPaidIntegrationEvent.cs | `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToPaidIntegrationEvent.cs` | ソース | 受信側（Webhooks）イベント定義 |
| OrderStatusChangedToPaidIntegrationEventHandler.cs | `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToPaidIntegrationEventHandler.cs` | ソース | Webhooks.API側ハンドラ |
| OrderStatusNotificationService.cs | `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs` | ソース | 通知配信サービス |
