# 通知設計書 5-出荷完了通知

## 概要

本ドキュメントは、eShopシステムにおける出荷完了通知（OrderStatusChangedToShippedIntegrationEvent）の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、注文が出荷され、注文ステータスがShipped（出荷済み）に遷移したことを購入者にリアルタイムで通知する機能である。管理者がSetShipOrderStatusCommand（出荷処理）を実行すると、Order集約のSetShippedStatusメソッドが呼び出され、OrderShippedDomainEventが発火する。これを契機としてIntegrationEventが生成され、EventBus経由でWebAppとWebhooks.APIに送信される。

**業務上の目的・背景**：出荷完了は購入者にとって最も待ち望んでいる通知の一つである。商品が実際に発送されたことを知ることで、配送を待つ顧客の期待感と安心感を高める。また、外部システム（物流管理システム等）への連携もこのタイミングで行われる。

**通知の送信タイミング**：管理者がShipOrderCommandを実行し、Order集約のSetShippedStatusメソッドが呼び出され、DomainEventが発火した直後にIntegrationEventが発行される。

**通知の受信者**：注文を行った購入者（BuyerIdentityGuidで識別）がWebAppの画面更新通知を受信する。また、Webhooks.APIもイベントを受信し、外部システムへのWebhook通知が送信される。

**通知内容の概要**：注文ID、注文ステータス（Shipped）、購入者名、購入者識別子の情報が含まれる。

**期待されるアクション**：購入者は画面が自動更新されることで、注文が出荷されたことを確認できる。配送の追跡を行い、商品の到着を待つことになる。

## 通知種別

アプリ内通知（WebApp SignalR経由のリアルタイム画面更新）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventBus経由） |
| 優先度 | 高 |
| リトライ | EventBusレベルでのリトライ機構による |

### 送信先決定ロジック

1. IntegrationEventに含まれるBuyerIdentityGuidを取得
2. OrderStatusNotificationServiceの_subscriptionsByBuyerIdディクショナリから該当するサブスクリプションを検索
3. 該当するすべてのサブスクリプションにコールバックを実行

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、アプリ内リアルタイム通知のため該当なし。

### 本文テンプレート

本通知は画面自動更新のためのシグナルであり、テキスト本文は存在しない。

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| OrderId | 注文ID | Order.Id | Yes |
| OrderStatus | 注文ステータス | Order.OrderStatus | Yes |
| BuyerName | 購入者名 | Buyer.Name | Yes |
| BuyerIdentityGuid | 購入者識別子 | Buyer.IdentityGuid | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ドメインイベント | OrderShippedDomainEvent | 管理者による出荷処理実行後 | Order集約のSetShippedStatusメソッド呼び出し時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 注文情報取得失敗 | OrderRepositoryからの注文取得に失敗した場合 |
| 購入者情報取得失敗 | BuyerRepositoryからの購入者取得に失敗した場合 |
| 該当サブスクリプションなし | WebApp側で購入者のサブスクリプションが存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理者: 出荷処理実行] --> B[ShipOrderCommand送信]
    B --> C[Order.SetShippedStatus]
    C --> D[OrderShippedDomainEvent発火]
    D --> E[OrderShippedDomainEventHandler]
    E --> F[注文情報・購入者情報取得]
    F --> G[OrderStatusChangedToShippedIntegrationEvent作成]
    G --> H[AddAndSaveEventAsync]
    H --> I[EventBus経由で発行]
    I --> J1[WebApp EventHandler受信]
    I --> J2[Webhooks.API EventHandler受信]
    J1 --> K[OrderStatusNotificationService.NotifyOrderStatusChangedAsync]
    K --> L[ブラウザ画面更新 Nav.Refresh]
    J2 --> M[Webhook外部送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Orders | 注文情報取得 | 注文ID、ステータス、購入者ID取得 |
| Buyers | 購入者情報取得 | 購入者名、識別子取得 |

### テーブル別参照項目詳細

#### Orders

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Id | 注文ID | DomainEventのOrder.Idで検索 |
| OrderStatus | 注文ステータス | 同上 |
| BuyerId | 購入者ID | 同上 |

#### Buyers

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Name | 購入者名 | Order.BuyerIdで検索 |
| IdentityGuid | 購入者識別子 | 同上 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| IntegrationEventLog | INSERT | イベントログの保存 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | EventId | IntegrationEvent.Id | イベント一意識別子 |
| INSERT | EventTypeName | イベント型名 | OrderStatusChangedToShippedIntegrationEvent |
| INSERT | State | Pending→InProgress→Published/Failed | 送信状態 |
| INSERT | Content | JSONシリアライズされたイベント内容 | イベントデータ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 注文取得エラー | OrderRepositoryからの取得失敗 | 例外をスローし、トランザクションロールバック |
| 購入者取得エラー | BuyerRepositoryからの取得失敗 | 例外をスローし、トランザクションロールバック |
| イベント発行失敗 | EventBus接続エラー | MarkEventAsFailedAsyncでログ記録、リトライキューへ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | EventBus実装依存 |
| リトライ間隔 | EventBus実装依存 |
| リトライ対象エラー | 一時的なネットワークエラー、接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間365日配信可能）

## セキュリティ考慮事項

- BuyerIdentityGuidは認証済みユーザーの識別子として使用され、他ユーザーの通知を受信することはできない
- IntegrationEventはシステム内部のEventBus経由でのみ送信され、外部からの偽装は不可能
- 出荷処理は管理者権限を持つユーザーのみが実行可能

## 備考

- 本イベントはWebAppとWebhooks.APIの2つのサービスで受信される
- Webhooks.APIでは外部システムへのWebhook通知が送信される（WebhookType.OrderShipped）
- 出荷情報（配送業者、追跡番号等）は現在のイベントに含まれていないが、拡張時に追加可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、IntegrationEventのデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OrderStatusChangedToShippedIntegrationEvent.cs | `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToShippedIntegrationEvent.cs` | 発行側イベント定義。OrderId, OrderStatus, BuyerName, BuyerIdentityGuidを含む |
| 1-2 | OrderStatusChangedToShippedIntegrationEvent.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToShippedIntegrationEvent.cs` | 受信側（WebApp）イベント定義 |
| 1-3 | OrderStatusChangedToShippedIntegrationEvent.cs | `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEvent.cs` | 受信側（Webhooks）イベント定義 |

**読解のコツ**: Webhooks.API側のイベント定義はシンプルで、OrderId, OrderStatus, BuyerNameのみを含む。BuyerIdentityGuidは含まれない点に注意。

#### Step 2: エントリーポイントを理解する

イベント発行の起点となるDomainEventHandlerを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OrderShippedDomainEventHandler.cs | `src/Ordering.API/Application/DomainEventHandlers/OrderShippedDomainEventHandler.cs` | DomainEventを処理し、IntegrationEventを発行 |

**主要処理フロー**:
1. **行25**: ログ出力でステータス更新を記録
2. **行27**: OrderRepositoryから注文取得
3. **行28**: BuyerRepositoryから購入者取得
4. **行30**: IntegrationEventインスタンス作成
5. **行31**: AddAndSaveEventAsyncでイベントをキューに追加

#### Step 3: WebApp側のイベントハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OrderStatusChangedToShippedIntegrationEventHandler.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToShippedIntegrationEventHandler.cs` | イベント受信後、OrderStatusNotificationServiceに通知を委譲 |

#### Step 4: Webhooks.API側のイベントハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | OrderStatusChangedToShippedIntegrationEventHandler.cs | `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEventHandler.cs` | Webhook送信処理を実行 |

**主要処理フロー**:
- **行10**: WebhookType.OrderShippedでサブスクリプションを検索
- **行14**: WebhookDataにイベント情報をラップ
- **行16**: sender.SendAllでWebhook送信

### プログラム呼び出し階層図

```
[管理者] ShipOrderCommand実行
    │
    └─ mediator.Send(ShipOrderCommand)
           │
           └─ Order.SetShippedStatus()
                  │
                  └─ AddDomainEvent(OrderShippedDomainEvent)
                         │
                         └─ MediatR.Publish(DomainEvent)
                                │
                                └─ OrderShippedDomainEventHandler.Handle()
                                       │
                                       ├─ OrderRepository.GetAsync()
                                       ├─ BuyerRepository.FindByIdAsync()
                                       │
                                       └─ OrderingIntegrationEventService.AddAndSaveEventAsync()

[トランザクションコミット後]

OrderingIntegrationEventService.PublishEventsThroughEventBusAsync()
    │
    └─ EventBus.PublishAsync(OrderStatusChangedToShippedIntegrationEvent)
           │
           ├─ [WebApp] EventHandler → OrderStatusNotificationService → Nav.Refresh()
           │
           └─ [Webhooks.API] EventHandler → WebhooksSender → 外部HTTP送信
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

ShipOrderCommand ───────────────▶ Order.SetShippedStatus()
                                        │
                                        ▼
                                OrderShippedDomainEvent
                                        │
                                        ▼
                                DomainEventHandler
                                        │
                                        ▼
                                IntegrationEvent作成 ───▶ EventBus
                                                              │
                                                      ┌───────┴───────┐
                                                      ▼               ▼
                                                  WebApp         Webhooks.API
                                                     │               │
                                                     ▼               ▼
                                                 画面更新        HTTP送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OrderStatusChangedToShippedIntegrationEvent.cs | `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToShippedIntegrationEvent.cs` | ソース | 発行側イベント定義 |
| OrderShippedDomainEvent.cs | `src/Ordering.Domain/Events/OrderShippedDomainEvent.cs` | ソース | ドメインイベント定義 |
| OrderShippedDomainEventHandler.cs | `src/Ordering.API/Application/DomainEventHandlers/OrderShippedDomainEventHandler.cs` | ソース | イベント発行起点 |
| OrderStatusChangedToShippedIntegrationEvent.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToShippedIntegrationEvent.cs` | ソース | 受信側（WebApp）イベント定義 |
| OrderStatusChangedToShippedIntegrationEventHandler.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToShippedIntegrationEventHandler.cs` | ソース | WebApp側ハンドラ |
| OrderStatusChangedToShippedIntegrationEvent.cs | `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEvent.cs` | ソース | 受信側（Webhooks）イベント定義 |
| OrderStatusChangedToShippedIntegrationEventHandler.cs | `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEventHandler.cs` | ソース | Webhooks.API側ハンドラ |
| WebhooksSender.cs | `src/Webhooks.API/Services/WebhooksSender.cs` | ソース | Webhook送信サービス |
| OrderStatusNotificationService.cs | `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs` | ソース | 通知配信サービス |
