# 通知設計書 6-注文キャンセル通知

## 概要

本ドキュメントは、eShopシステムにおける注文キャンセル通知（OrderStatusChangedToCancelledIntegrationEvent）の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、注文がキャンセルされ、注文ステータスがCancelled（キャンセル済み）に遷移したことを購入者にリアルタイムで通知する機能である。購入者または管理者がCancelOrderCommandを実行すると、Order集約のSetCancelledStatusまたはSetCancelledStatusWhenStockIsRejectedメソッドが呼び出され、OrderCancelledDomainEventが発火する。これを契機としてIntegrationEventが生成され、EventBus経由でWebAppに送信される。

**業務上の目的・背景**：注文キャンセルは購入者にとって重要な情報である。キャンセル処理が完了したことを即座に通知することで、購入者は安心してキャンセル完了を確認できる。また、在庫不足によるシステム自動キャンセルの場合も、購入者に状況を知らせる必要がある。

**通知の送信タイミング**：CancelOrderCommandを実行し、Order集約のSetCancelledStatusメソッドが呼び出され、DomainEventが発火した直後にIntegrationEventが発行される。または、在庫不足によりOrderStockRejectedIntegrationEventを受信した際に、SetCancelledStatusWhenStockIsRejectedメソッドが呼び出された場合も同様にイベントが発行される。

**通知の受信者**：注文を行った購入者（BuyerIdentityGuidで識別）がWebAppの画面更新通知を受信する。

**通知内容の概要**：注文ID、注文ステータス（Cancelled）、購入者名、購入者識別子の情報が含まれる。

**期待されるアクション**：購入者は画面が自動更新されることで、注文がキャンセルされたことを確認できる。必要に応じて再注文を行うか、サポートに問い合わせることができる。

## 通知種別

アプリ内通知（WebApp SignalR経由のリアルタイム画面更新）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（EventBus経由） |
| 優先度 | 高 |
| リトライ | EventBusレベルでのリトライ機構による |

### 送信先決定ロジック

1. IntegrationEventに含まれるBuyerIdentityGuidを取得
2. OrderStatusNotificationServiceの_subscriptionsByBuyerIdディクショナリから該当するサブスクリプションを検索
3. 該当するすべてのサブスクリプションにコールバックを実行

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、アプリ内リアルタイム通知のため該当なし。

### 本文テンプレート

本通知は画面自動更新のためのシグナルであり、テキスト本文は存在しない。

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| OrderId | 注文ID | Order.Id | Yes |
| OrderStatus | 注文ステータス | Order.OrderStatus | Yes |
| BuyerName | 購入者名 | Buyer.Name | Yes |
| BuyerIdentityGuid | 購入者識別子 | Buyer.IdentityGuid | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ドメインイベント | OrderCancelledDomainEvent | ユーザーまたは管理者によるキャンセル処理実行後 | Order集約のSetCancelledStatusメソッド呼び出し時に発火 |
| ドメインイベント | OrderCancelledDomainEvent | 在庫不足による自動キャンセル | Order集約のSetCancelledStatusWhenStockIsRejectedメソッド呼び出し時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 注文情報取得失敗 | OrderRepositoryからの注文取得に失敗した場合 |
| 購入者情報取得失敗 | BuyerRepositoryからの購入者取得に失敗した場合 |
| 該当サブスクリプションなし | WebApp側で購入者のサブスクリプションが存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A1[ユーザー/管理者: キャンセル処理実行] --> B[CancelOrderCommand送信]
    A2[システム: 在庫不足検出] --> C[OrderStockRejectedIntegrationEvent受信]
    B --> D[Order.SetCancelledStatus]
    C --> D2[Order.SetCancelledStatusWhenStockIsRejected]
    D --> E[OrderCancelledDomainEvent発火]
    D2 --> E
    E --> F[OrderCancelledDomainEventHandler]
    F --> G[注文情報・購入者情報取得]
    G --> H[OrderStatusChangedToCancelledIntegrationEvent作成]
    H --> I[AddAndSaveEventAsync]
    I --> J[EventBus経由で発行]
    J --> K[WebApp EventHandler受信]
    K --> L[OrderStatusNotificationService.NotifyOrderStatusChangedAsync]
    L --> M[ブラウザ画面更新 Nav.Refresh]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Orders | 注文情報取得 | 注文ID、ステータス、購入者ID取得 |
| Buyers | 購入者情報取得 | 購入者名、識別子取得 |

### テーブル別参照項目詳細

#### Orders

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Id | 注文ID | DomainEventのOrder.Idで検索 |
| OrderStatus | 注文ステータス | 同上 |
| BuyerId | 購入者ID | 同上 |

#### Buyers

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Name | 購入者名 | Order.BuyerIdで検索 |
| IdentityGuid | 購入者識別子 | 同上 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| IntegrationEventLog | INSERT | イベントログの保存 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | EventId | IntegrationEvent.Id | イベント一意識別子 |
| INSERT | EventTypeName | イベント型名 | OrderStatusChangedToCancelledIntegrationEvent |
| INSERT | State | Pending→InProgress→Published/Failed | 送信状態 |
| INSERT | Content | JSONシリアライズされたイベント内容 | イベントデータ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 注文取得エラー | OrderRepositoryからの取得失敗 | 例外をスローし、トランザクションロールバック |
| 購入者取得エラー | BuyerRepositoryからの取得失敗 | 例外をスローし、トランザクションロールバック |
| イベント発行失敗 | EventBus接続エラー | MarkEventAsFailedAsyncでログ記録、リトライキューへ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | EventBus実装依存 |
| リトライ間隔 | EventBus実装依存 |
| リトライ対象エラー | 一時的なネットワークエラー、接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間365日配信可能）

## セキュリティ考慮事項

- BuyerIdentityGuidは認証済みユーザーの識別子として使用され、他ユーザーの通知を受信することはできない
- IntegrationEventはシステム内部のEventBus経由でのみ送信され、外部からの偽装は不可能
- キャンセル処理は注文の所有者または管理者権限を持つユーザーのみが実行可能

## 備考

- キャンセル理由（ユーザー要望、在庫不足等）は現在のイベントに含まれていないが、拡張時に追加可能
- 在庫不足によるキャンセルの場合、購入者への通知とは別に、在庫管理者への通知を検討する必要がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、IntegrationEventのデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OrderStatusChangedToCancelledIntegrationEvent.cs | `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToCancelledIntegrationEvent.cs` | 発行側イベント定義。OrderId, OrderStatus, BuyerName, BuyerIdentityGuidを含む |
| 1-2 | OrderStatusChangedToCancelledIntegrationEvent.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToCancelledIntegrationEvent.cs` | 受信側（WebApp）イベント定義 |

**読解のコツ**: このイベントはシンプルな構造で、OrderStockItemsは含まれない。

#### Step 2: エントリーポイントを理解する

イベント発行の起点となるDomainEventHandlerを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OrderCancelledDomainEventHandler.cs | `src/Ordering.API/Application/DomainEventHandlers/OrderCancelledDomainEventHandler.cs` | DomainEventを処理し、IntegrationEventを発行 |

**主要処理フロー**:
1. **行25**: ログ出力でステータス更新を記録
2. **行27**: OrderRepositoryから注文取得
3. **行28**: BuyerRepositoryから購入者取得
4. **行30**: IntegrationEventインスタンス作成
5. **行31**: AddAndSaveEventAsyncでイベントをキューに追加

#### Step 3: トリガーとなるイベントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OrderStockRejectedIntegrationEventHandler.cs | `src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderStockRejectedIntegrationEventHandler.cs` | 在庫不足による自動キャンセルのトリガー |

#### Step 4: WebApp側のイベントハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | OrderStatusChangedToCancelledIntegrationEventHandler.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToCancelledIntegrationEventHandler.cs` | イベント受信後、OrderStatusNotificationServiceに通知を委譲 |

**主要処理フロー**:
- **行10-14**: イベント受信→NotifyOrderStatusChangedAsync呼び出し

### プログラム呼び出し階層図

```
[ユーザー/管理者] CancelOrderCommand実行
    │                                               [Catalog.API] OrderStockRejectedIntegrationEvent発行
    │                                                       │
    ▼                                                       ▼
mediator.Send(CancelOrderCommand)               OrderStockRejectedIntegrationEventHandler.Handle()
    │                                                       │
    └───────────────────┬───────────────────────────────────┘
                        │
                        ▼
              Order.SetCancelledStatus() / Order.SetCancelledStatusWhenStockIsRejected()
                        │
                        ▼
              AddDomainEvent(OrderCancelledDomainEvent)
                        │
                        ▼
              MediatR.Publish(DomainEvent)
                        │
                        ▼
              OrderCancelledDomainEventHandler.Handle()
                        │
                        ├─ OrderRepository.GetAsync()
                        ├─ BuyerRepository.FindByIdAsync()
                        │
                        └─ OrderingIntegrationEventService.AddAndSaveEventAsync()

[トランザクションコミット後]

OrderingIntegrationEventService.PublishEventsThroughEventBusAsync()
    │
    └─ EventBus.PublishAsync(OrderStatusChangedToCancelledIntegrationEvent)
           │
           └─ [WebApp] EventHandler → OrderStatusNotificationService → Nav.Refresh()
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

CancelOrderCommand ───────┐
                          │
                          ▼
OrderStockRejectedIntegrationEvent ──▶ Order.SetCancelled...()
                                              │
                                              ▼
                                   OrderCancelledDomainEvent
                                              │
                                              ▼
                                   DomainEventHandler
                                              │
                                              ▼
                                   IntegrationEvent作成 ───▶ EventBus
                                                                 │
                                                                 ▼
                                                             WebApp
                                                                │
                                                                ▼
                                                            画面更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OrderStatusChangedToCancelledIntegrationEvent.cs | `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToCancelledIntegrationEvent.cs` | ソース | 発行側イベント定義 |
| OrderCancelledDomainEvent.cs | `src/Ordering.Domain/Events/OrderCancelledDomainEvent.cs` | ソース | ドメインイベント定義 |
| OrderCancelledDomainEventHandler.cs | `src/Ordering.API/Application/DomainEventHandlers/OrderCancelledDomainEventHandler.cs` | ソース | イベント発行起点 |
| OrderStockRejectedIntegrationEventHandler.cs | `src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderStockRejectedIntegrationEventHandler.cs` | ソース | 在庫不足キャンセルのトリガー |
| OrderStatusChangedToCancelledIntegrationEvent.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToCancelledIntegrationEvent.cs` | ソース | 受信側（WebApp）イベント定義 |
| OrderStatusChangedToCancelledIntegrationEventHandler.cs | `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToCancelledIntegrationEventHandler.cs` | ソース | WebApp側ハンドラ |
| OrderStatusNotificationService.cs | `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs` | ソース | 通知配信サービス |
| OrdersRefreshOnStatusChange.razor | `src/WebApp/Components/Pages/User/OrdersRefreshOnStatusChange.razor` | ソース | UI更新Blazorコンポーネント |
