# 通知設計書 8-注文出荷完了Webhook

## 概要

本ドキュメントは、eShopシステムにおける注文出荷完了Webhook（OrderShipped Webhook）の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、注文が出荷された際に、事前に登録された外部システムのエンドポイントにHTTP POSTリクエストでWebhook通知を送信する機能である。Webhooks.APIがOrderStatusChangedToShippedIntegrationEventを受信すると、WebhookType.OrderShippedに登録されているすべてのサブスクリプションに対して、WebhooksSenderを介して通知を送信する。

**業務上の目的・背景**：出荷完了は物流システムや顧客通知システムとの連携において重要なイベントである。Webhook方式により、外部システム（物流追跡システム、CRM、マーケティングオートメーション等）はポーリングなしでリアルタイムに出荷情報を受信でき、タイムリーな顧客対応や配送追跡が可能となる。

**通知の送信タイミング**：Ordering.APIからOrderStatusChangedToShippedIntegrationEventがEventBus経由で発行され、Webhooks.APIがイベントを受信した直後に、登録されているすべてのサブスクリプションに対してWebhookが送信される。

**通知の受信者**：WebhookType.OrderShippedに登録されている外部システムのエンドポイント（DestUrl）に送信される。各サブスクリプションはユーザーごとに管理され、認証トークンを設定可能。

**通知内容の概要**：WebhookDataとしてラップされ、タイムスタンプ（When）、タイプ（OrderShipped）、ペイロード（OrderId、OrderStatus、BuyerName）を含むJSON形式で送信される。

**期待されるアクション**：外部システムは受信したWebhookを処理し、出荷完了に対応した業務処理（配送追跡開始、顧客への出荷通知メール送信、CRM更新など）を実行する。

## 通知種別

Webhook（HTTP POST）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（HTTP POST） |
| 優先度 | 高 |
| リトライ | なし（現在の実装） |

### 送信先決定ロジック

1. WebhooksRetrieverでWebhookType.OrderShippedに登録されているサブスクリプションを取得
2. 取得したすべてのサブスクリプションのDestUrlに対して並列でHTTP POSTを送信

## 通知テンプレート

### HTTPリクエスト仕様

| 項目 | 内容 |
|-----|------|
| HTTPメソッド | POST |
| Content-Type | application/json; charset=utf-8 |
| 認証ヘッダー | X-eshop-whtoken（サブスクリプションにTokenが設定されている場合） |

### リクエストボディ（JSON）

```json
{
  "When": "2026-01-14T12:30:00.000Z",
  "Type": "OrderShipped",
  "Payload": "{\"OrderId\":123,\"OrderStatus\":\"Shipped\",\"BuyerName\":\"John Doe\"}"
}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| When | 送信日時（UTC） | DateTime.UtcNow | Yes |
| Type | Webhookタイプ | WebhookType.ToString() | Yes |
| Payload | イベントデータ（JSONシリアライズ） | OrderStatusChangedToShippedIntegrationEvent | Yes |
| OrderId | 注文ID | IntegrationEvent.OrderId | Yes |
| OrderStatus | 注文ステータス | IntegrationEvent.OrderStatus | Yes |
| BuyerName | 購入者名 | IntegrationEvent.BuyerName | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| IntegrationEvent | OrderStatusChangedToShippedIntegrationEvent | WebhookType.OrderShippedのサブスクリプションが存在する場合 | Webhooks.APIでイベント受信後に送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| サブスクリプションなし | WebhookType.OrderShippedに登録されているサブスクリプションがない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Ordering.API: OrderStatusChangedToShippedIntegrationEvent発行] --> B[EventBus経由で配信]
    B --> C[Webhooks.API: OrderStatusChangedToShippedIntegrationEventHandler受信]
    C --> D[WebhooksRetriever.GetSubscriptionsOfType OrderShipped]
    D --> E{サブスクリプションあり?}
    E -->|Yes| F[WebhookData作成]
    E -->|No| G[処理終了]
    F --> H[WebhooksSender.SendAll]
    H --> I[各サブスクリプションに並列送信]
    I --> J[HttpClient.SendAsync POST]
    J --> K[処理終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| WebhookSubscription | 送信先情報取得 | Webhooks.API専用テーブル |

### テーブル別参照項目詳細

#### WebhookSubscription

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Id | サブスクリプションID | - |
| Type | Webhookタイプ | WHERE Type = WebhookType.OrderShipped |
| DestUrl | 送信先URL | - |
| Token | 認証トークン | - |
| UserId | 登録ユーザーID | - |

### 更新テーブル一覧

該当なし（ログテーブルへの記録なし）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| HTTP送信エラー | 宛先URLへの接続失敗 | 現在はエラーを無視（リトライなし） |
| タイムアウト | HTTP送信のタイムアウト | 現在はエラーを無視（リトライなし） |
| サブスクリプション取得エラー | データベース接続エラー | 例外をスロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（現在の実装） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間365日配信可能）

## セキュリティ考慮事項

- 認証トークン（X-eshop-whtoken）により、受信側で送信元の正当性を検証可能
- サブスクリプション登録時に、DestUrlの到達可能性を検証（GrantUrlTesterService）
- サブスクリプションはユーザーごとに管理され、他ユーザーのサブスクリプションにはアクセス不可
- HTTPSプロトコルの使用を推奨（現在は強制されていない）

## 備考

- 現在の実装ではWebhook送信失敗時のリトライ機構がない。本番環境では外部キュー（RabbitMQ等）を使用したリトライ機構の追加を検討すべき
- OrderPaid Webhookとの違い：出荷完了イベントにはOrderStockItemsは含まれず、OrderStatus、BuyerNameが含まれる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Webhook関連のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OrderStatusChangedToShippedIntegrationEvent.cs | `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEvent.cs` | 受信イベント定義。OrderId, OrderStatus, BuyerNameを含む |
| 1-2 | WebhookData.cs | `src/Webhooks.API/Model/WebhookData.cs` | 送信データのラッパー。When, Type, Payloadを持つ |
| 1-3 | WebhookType.cs | `src/Webhooks.API/Model/WebhookType.cs` | Webhookタイプのenum定義。OrderShipped=2 |
| 1-4 | WebhookSubscription.cs | `src/Webhooks.API/Model/WebhookSubscription.cs` | サブスクリプションのエンティティ定義 |

**読解のコツ**: OrderShippedイベントはOrderPaidと異なり、OrderStockItemsを含まない。BuyerNameが含まれる点が特徴。

#### Step 2: エントリーポイントを理解する

イベント受信の起点となるハンドラを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OrderStatusChangedToShippedIntegrationEventHandler.cs | `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEventHandler.cs` | イベント受信→サブスクリプション検索→Webhook送信の流れ |

**主要処理フロー**:
1. **行10**: WebhooksRetriever.GetSubscriptionsOfType(WebhookType.OrderShipped)
2. **行12**: ログ出力（サブスクリプション数）
3. **行14**: WebhookData作成（イベントをラップ）
4. **行16**: WebhooksSender.SendAllで送信

#### Step 3: サブスクリプション取得処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WebhooksRetriever.cs | `src/Webhooks.API/Services/WebhooksRetriever.cs` | WebhooksContextを使用してサブスクリプション検索 |

#### Step 4: Webhook送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | WebhooksSender.cs | `src/Webhooks.API/Services/WebhooksSender.cs` | HttpClientを使用したHTTP POST送信 |

### プログラム呼び出し階層図

```
[Ordering.API] OrderStatusChangedToShippedIntegrationEvent発行
    │
    └─ EventBus経由で配信
           │
           └─ [Webhooks.API] OrderStatusChangedToShippedIntegrationEventHandler.Handle()
                  │
                  ├─ WebhooksRetriever.GetSubscriptionsOfType(WebhookType.OrderShipped)
                  │      │
                  │      └─ WebhooksContext.Subscriptions.Where(s => s.Type == type)
                  │
                  ├─ new WebhookData(WebhookType.OrderShipped, @event)
                  │
                  └─ WebhooksSender.SendAll(subscriptions, whook)
                         │
                         └─ Task.WhenAll(receivers.Select(r => OnSendData(...)))
                                │
                                └─ HttpClient.SendAsync(request) [並列実行]
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

OrderStatusChangedToShippedIntegrationEvent ───▶ Webhooks.API受信
                                                    │
                                                    ▼
                                          WebhooksRetriever
                                          (サブスクリプション検索)
                                                    │
                                                    ▼
                                             WebhookData作成
                                          (イベントをラップ)
                                                    │
                                                    ▼
                                            WebhooksSender
                                          (HTTP POST送信)
                                                    │
                                            ┌───────┼───────┐
                                            ▼       ▼       ▼
                                         外部URL1 外部URL2 外部URL3
                                         (並列送信)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OrderStatusChangedToShippedIntegrationEvent.cs | `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEvent.cs` | ソース | 受信イベント定義 |
| OrderStatusChangedToShippedIntegrationEventHandler.cs | `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEventHandler.cs` | ソース | イベントハンドラ |
| WebhookData.cs | `src/Webhooks.API/Model/WebhookData.cs` | ソース | 送信データモデル |
| WebhookType.cs | `src/Webhooks.API/Model/WebhookType.cs` | ソース | Webhookタイプenum |
| WebhookSubscription.cs | `src/Webhooks.API/Model/WebhookSubscription.cs` | ソース | サブスクリプションエンティティ |
| WebhooksRetriever.cs | `src/Webhooks.API/Services/WebhooksRetriever.cs` | ソース | サブスクリプション取得サービス |
| WebhooksSender.cs | `src/Webhooks.API/Services/WebhooksSender.cs` | ソース | Webhook送信サービス |
| WebhooksContext.cs | `src/Webhooks.API/Infrastructure/WebhooksContext.cs` | ソース | EF Core DbContext |
