# 通知設計書 9-注文成功アラート

## 概要

本ドキュメントは、eShopシステムのモバイルアプリ（ClientApp）における注文成功アラートの設計仕様を定義するものである。

### 本通知の処理概要

本通知は、モバイルアプリで注文が正常に完了した際に、アラートダイアログを表示してユーザーに成功を通知する機能である。CheckoutViewModelのCheckoutAsyncメソッドで注文処理が成功すると、DialogServiceのShowAlertAsyncメソッドを介して「Order sent successfully!」というメッセージのアラートダイアログが表示される。

**業務上の目的・背景**：モバイルアプリにおいて、注文処理の完了をユーザーに明確に伝えることは、顧客体験の向上において重要である。視覚的なフィードバックにより、ユーザーは注文が正しく送信されたことを確認でき、安心感を得られる。

**通知の送信タイミング**：CheckoutAsyncメソッドで、OrderService.CreateOrderAsyncが成功し、BasketService.ClearBasketAsyncでカートがクリアされた後、カタログ画面へのナビゲーション直後にアラートダイアログが表示される。

**通知の受信者**：注文を実行したモバイルアプリユーザー（端末上でアプリを操作中のユーザー）。

**通知内容の概要**：タイトル「Checkout」、メッセージ「Order sent successfully!」、ボタン「Ok」のシンプルなアラートダイアログ。

**期待されるアクション**：ユーザーは「Ok」ボタンをタップしてダイアログを閉じ、カタログ画面で引き続き買い物を続けるか、注文履歴を確認できる。

## 通知種別

UIアラート（.NET MAUIアラートダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（UI直接表示） |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

1. CheckoutAsyncメソッド内で注文処理が成功した場合に表示
2. ユーザー操作（Checkoutボタンタップ）をトリガーとする

## 通知テンプレート

### アラートダイアログ仕様

| 項目 | 内容 |
|-----|------|
| ダイアログタイプ | Alert（DisplayAlert） |
| タイトル | Checkout |
| メッセージ | Order sent successfully! |
| ボタン | Ok |

### 本文テンプレート

```
Order sent successfully!
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | アラートメッセージ | ハードコード | Yes |
| title | アラートタイトル | ハードコード | Yes |
| buttonLabel | ボタンラベル | ハードコード | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Checkoutボタンタップ | OrderService.CreateOrderAsync成功後 | 注文処理が正常に完了した場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 注文処理失敗 | CreateOrderAsyncで例外が発生した場合（代わりにエラーアラートが表示される） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザー: Checkoutボタンタップ] --> B[CheckoutAsyncメソッド実行]
    B --> C[MapOrderToBasket]
    C --> D[OrderService.CreateOrderAsync]
    D --> E{成功?}
    E -->|Yes| F[BasketService.ClearBasketAsync]
    E -->|No| G[例外発生→エラーアラート表示]
    F --> H[BasketViewModel.ClearBasketItems]
    H --> I[WeakReferenceMessenger.Send ProductCountChangedMessage]
    I --> J[NavigationService.NavigateToAsync //Main/Catalog]
    J --> K[DialogService.ShowAlertAsync 成功メッセージ]
    K --> L[AppShell.Current.DisplayAlert]
    L --> M[アラートダイアログ表示]
    M --> N[ユーザー: Okボタンタップ]
    N --> O[ダイアログ閉じる]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（クライアントサイドUIのみ）

### 更新テーブル一覧

該当なし（クライアントサイドUIのみ）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 注文処理エラー | CreateOrderAsyncで例外発生 | エラーアラート（No.10）を表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（ユーザーが再度操作） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間365日表示可能）

## セキュリティ考慮事項

- アラートダイアログは端末ローカルで表示されるため、外部への情報漏洩リスクは低い
- ユーザー認証済みの状態でのみCheckout処理が実行される

## 備考

- 本アラートは.NET MAUIのDisplayAlertを使用しており、iOS/Android両プラットフォームでネイティブのアラートダイアログとして表示される
- メッセージは現在ハードコードされているが、将来的には多言語対応のためリソースファイルへの外出しを検討すべき

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、DialogServiceのインターフェースと実装を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IDialogService.cs | `src/ClientApp/Services/Dialog/IDialogService.cs` | ShowAlertAsyncメソッドのインターフェース定義 |
| 1-2 | DialogService.cs | `src/ClientApp/Services/Dialog/DialogService.cs` | AppShell.Current.DisplayAlertを使用した実装 |

**読解のコツ**: .NET MAUIのDisplayAlertはモーダルダイアログを表示するプラットフォーム標準のAPIである。

#### Step 2: エントリーポイントを理解する

アラート表示の起点となるViewModelを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CheckoutViewModel.cs | `src/ClientApp/ViewModels/CheckoutViewModel.cs` | CheckoutAsyncメソッドで注文処理と成功アラート表示 |

**主要処理フロー**:
1. **行105-133**: CheckoutAsyncメソッド全体
2. **行109**: MapOrderToBasketでBasketオブジェクト作成
3. **行112**: OrderService.CreateOrderAsyncで注文送信
4. **行115**: BasketService.ClearBasketAsyncでカートクリア
5. **行124**: NavigationService.NavigateToAsyncでカタログ画面へ
6. **行127**: DialogService.ShowAlertAsyncで成功アラート表示
7. **行129-132**: try-catchでエラー時はエラーアラート表示

#### Step 3: 依存サービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ViewModelBase.cs | `src/ClientApp/ViewModels/Base/ViewModelBase.cs` | NavigationServiceの基底クラス |

### プログラム呼び出し階層図

```
[ユーザー操作] Checkoutボタンタップ
    │
    └─ CheckoutCommand.Execute()
           │
           └─ CheckoutViewModel.CheckoutAsync()
                  │
                  ├─ _appEnvironmentService.OrderService.MapOrderToBasket(Order)
                  │
                  ├─ _appEnvironmentService.OrderService.CreateOrderAsync(Order)
                  │
                  ├─ _appEnvironmentService.BasketService.ClearBasketAsync()
                  │
                  ├─ _basketViewModel.ClearBasketItems()
                  │
                  ├─ WeakReferenceMessenger.Default.Send(ProductCountChangedMessage)
                  │
                  ├─ NavigationService.NavigateToAsync("//Main/Catalog")
                  │
                  └─ _dialogService.ShowAlertAsync("Order sent successfully!", "Checkout", "Ok")
                         │
                         └─ AppShell.Current.DisplayAlert(title, message, buttonLabel)
                                │
                                └─ [Platform] ネイティブアラートダイアログ表示
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

ユーザー操作                            │
(Checkoutボタンタップ) ─────────────────▶ CheckoutAsyncメソッド
                                        │
                                        ├─ Order作成
                                        │
                                        ├─ API呼び出し
                                        │  (OrderService.CreateOrderAsync)
                                        │
                                        ├─ カートクリア
                                        │
                                        ├─ 画面遷移
                                        │  (//Main/Catalog)
                                        │
                                        └─ アラート表示 ───▶ DisplayAlert
                                                                  │
                                                                  ▼
                                                          ネイティブダイアログ
                                                          "Order sent successfully!"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CheckoutViewModel.cs | `src/ClientApp/ViewModels/CheckoutViewModel.cs` | ソース | 注文処理とアラート表示のViewModel |
| IDialogService.cs | `src/ClientApp/Services/Dialog/IDialogService.cs` | ソース | ダイアログサービスインターフェース |
| DialogService.cs | `src/ClientApp/Services/Dialog/DialogService.cs` | ソース | ダイアログサービス実装 |
| ViewModelBase.cs | `src/ClientApp/ViewModels/Base/ViewModelBase.cs` | ソース | ViewModel基底クラス |
| INavigationService.cs | `src/ClientApp/Services/Navigation/INavigationService.cs` | ソース | ナビゲーションサービスインターフェース |
| MockDialogService.cs | `tests/ClientApp.UnitTests/Mocks/MockDialogService.cs` | テスト | テスト用モックサービス |
