---
generated_at: 2026-01-14 21:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-注文送信完了通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **EventBusリトライ仕様**：具体的なリトライ回数・間隔がコードから確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedTosubmittedIntegrationEvent.cs`
- E-02: `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToSubmittedIntegrationEvent.cs`
- E-03: `src/Ordering.API/Application/DomainEventHandlers/ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandler.cs`
- E-04: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToSubmittedIntegrationEventHandler.cs`
- E-05: `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs`
- E-06: `src/WebApp/Components/Pages/User/OrdersRefreshOnStatusChange.razor`
- E-07: `src/Ordering.API/Application/IntegrationEvents/OrderingIntegrationEventService.cs`
- E-08: `src/EventBus/Events/IntegrationEvent.cs`
- E-09: `src/EventBus/Abstractions/IIntegrationEventHandler.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OrderStatusChangedToSubmittedIntegrationEventはOrderId, OrderStatus, BuyerName, BuyerIdentityGuidを含む | E-01（行5-8） | ○ |
| C-02 | イベントはIntegrationEventを継承している | E-01（行3） | ○ |
| C-03 | IntegrationEventはIdとCreationDateを持つ | E-08（行6-8, 12-15） | ○ |
| C-04 | ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandlerがイベント発行の起点 | E-03（行50-51） | ○ |
| C-05 | OrderStartedDomainEventをトリガーとしている | E-03（行4, 20） | ○ |
| C-06 | バイヤー情報の検証・登録後にイベントが発行される | E-03（行34-51） | ○ |
| C-07 | AddAndSaveEventAsyncでイベントをキューに追加 | E-03（行51）, E-07（行36-40） | ○ |
| C-08 | EventBus経由でイベントが発行される | E-07（行24） | ○ |
| C-09 | WebApp側でOrderStatusChangedToSubmittedIntegrationEventHandlerが受信 | E-04（行5-8） | ○ |
| C-10 | ハンドラはOrderStatusNotificationServiceに通知を委譲 | E-04（行13） | ○ |
| C-11 | BuyerIdentityGuidで送信先を決定 | E-04（行13）, E-05（行27-34） | ○ |
| C-12 | OrderStatusNotificationServiceは辞書でサブスクリプションを管理 | E-05（行7） | ○ |
| C-13 | NotifyOrderStatusChangedAsyncで該当サブスクリプションにコールバック実行 | E-05（行27-34） | ○ |
| C-14 | OrdersRefreshOnStatusChange.razorがUI更新を担当 | E-06（行1-41） | ○ |
| C-15 | Nav.Refresh()で画面を更新 | E-06（行27） | ○ |
| C-16 | InteractiveServerレンダーモードを使用 | E-06（行2） | ○ |
| C-17 | 認証にAuthenticationStateProviderを使用 | E-06（行3, 14） | ○ |
| C-18 | IDisposableを実装してサブスクリプション解除 | E-06（行6, 37-40）, E-05（行52-60） | ○ |
| C-19 | IIntegrationEventHandlerインターフェースを実装 | E-04（行8）, E-09（行3-9） | ○ |
| C-20 | 送信方式は非同期 | E-07（行24 async Task） | ○ |
| C-21 | イベントログにPending/InProgress/Published/Failedの状態遷移がある | E-07（行23, 25, 31） | ○ |
| C-22 | 例外発生時はMarkEventAsFailedAsyncで記録 | E-07（行31） | ○ |
| C-23 | DispatchExceptionAsyncで例外ハンドリング | E-06（行33） | ○ |
| C-24 | WebApp側のイベント定義ではOrderStatusがstring型 | E-02（行8） | ○ |
| C-25 | EventBusのリトライ仕様は実装依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- EventBusの具体的なリトライ仕様（回数、間隔）がソースコードから確認できない
  - 候補：RabbitMQ設定ファイル / Azure Service Bus設定 / EventBus実装クラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの主張がソースコードで直接確認可能
- 1: 中リスク - EventBusリトライ仕様は実行環境・設定依存のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] C-25のEventBusリトライ仕様について、実運用環境の設定を確認
- [ ] E-01とE-02のイベント定義の差異（OrderStatusの型）が問題ないか確認
- [ ] OrderStatusNotificationServiceのスレッドセーフ実装（lock）が適切か確認
