---
generated_at: 2026-01-14 21:32:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-在庫検証待ち通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **EventBusリトライ仕様**：具体的なリトライ回数・間隔がコードから確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToAwaitingValidationIntegrationEvent.cs`
- E-02: `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToAwaitingValidationIntegrationEvent.cs`
- E-03: `src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToAwaitingValidationDomainEventHandler.cs`
- E-04: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs`
- E-05: `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs`
- E-06: `src/Catalog.API/IntegrationEvents/Events/OrderStatusChangedToAwaitingValidationIntegrationEvent.cs`
- E-07: `src/Catalog.API/IntegrationEvents/EventHandling/OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OrderStatusChangedToAwaitingValidationIntegrationEventはOrderStockItemsを含む | E-01（行9） | ○ |
| C-02 | OrderStockItemはProductIdとUnitsを持つrecord | E-01（行23-32） | ○ |
| C-03 | イベントはOrderId, OrderStatus, BuyerName, BuyerIdentityGuidを含む | E-01（行5-8） | ○ |
| C-04 | OrderStatusChangedToAwaitingValidationDomainEventHandlerがイベント発行の起点 | E-03（行23-35） | ○ |
| C-05 | OrderRepositoryから注文取得 | E-03（行27） | ○ |
| C-06 | BuyerRepositoryから購入者取得 | E-03（行28） | ○ |
| C-07 | OrderStockItemリストをDomainEventのOrderItemsから作成 | E-03（行30-31） | ○ |
| C-08 | AddAndSaveEventAsyncでイベントをキューに追加 | E-03（行34） | ○ |
| C-09 | WebApp側でEventHandlerがイベントを受信 | E-04（行5-8） | ○ |
| C-10 | NotifyOrderStatusChangedAsyncを呼び出す | E-04（行13） | ○ |
| C-11 | BuyerIdentityGuidで通知先を決定 | E-04（行13）, E-05（行27-34） | ○ |
| C-12 | Catalog.API側でもイベントを受信 | E-06, E-07 | ○ |
| C-13 | Catalog.APIで在庫検証処理が実行される | E-07 | ○ |
| C-14 | WebApp側イベント定義ではOrderStockItemsは含まれない | E-02（行5-10） | ○ |
| C-15 | OrderStatusChangedToAwaitingValidationDomainEventを処理 | E-03（行3-4） | ○ |
| C-16 | INotificationHandlerを実装 | E-03（行3-4） | ○ |
| C-17 | ログ出力でステータス更新を記録 | E-03（行25） | ○ |
| C-18 | OrderingApiTrace.LogOrderStatusUpdatedを使用 | E-03（行25） | ○ |
| C-19 | OrderStatusはAwaitingValidation | E-03（行25） | ○ |
| C-20 | IIntegrationEventHandlerを実装 | E-04（行8） | ○ |
| C-21 | 非同期でイベント発行 | E-03（行34 async/await） | ○ |
| C-22 | EventBusのリトライ仕様は実装依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- EventBusの具体的なリトライ仕様（回数、間隔）がソースコードから確認できない
  - 候補：RabbitMQ設定ファイル / Azure Service Bus設定 / EventBus実装クラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの主張がソースコードで直接確認可能
- 1: 中リスク - マルチキャスト配信のため、各受信者の処理順序や障害時の影響を要確認

## 6) レビュアーチェックリスト（最小）
- [ ] C-22のEventBusリトライ仕様について、実運用環境の設定を確認
- [ ] WebApp側とCatalog.API側でイベントを同時に処理する場合の整合性を確認
- [ ] E-02でOrderStockItemsが含まれない理由が妥当か確認（WebAppでは不要なため省略されている想定）
