---
generated_at: 2026-01-14 21:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-在庫確認完了通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **EventBusリトライ仕様**：具体的なリトライ回数・間隔がコードから確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToStockConfirmedIntegrationEvent.cs`
- E-02: `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToStockConfirmedIntegrationEvent.cs`
- E-03: `src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToStockConfirmedDomainEventHandler.cs`
- E-04: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToStockConfirmedIntegrationEventHandler.cs`
- E-05: `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs`
- E-06: `src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderStockConfirmedIntegrationEventHandler.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OrderStatusChangedToStockConfirmedIntegrationEventはOrderId, OrderStatus, BuyerName, BuyerIdentityGuidを含む | E-01（行5-8） | ○ |
| C-02 | イベントはIntegrationEventを継承 | E-01（行3） | ○ |
| C-03 | OrderStatusChangedToStockConfirmedDomainEventHandlerがイベント発行の起点 | E-03（行23-32） | ○ |
| C-04 | OrderRepositoryから注文取得 | E-03（行27） | ○ |
| C-05 | BuyerRepositoryから購入者取得 | E-03（行28） | ○ |
| C-06 | AddAndSaveEventAsyncでイベントをキューに追加 | E-03（行31） | ○ |
| C-07 | WebApp側でEventHandlerがイベントを受信 | E-04（行5-8） | ○ |
| C-08 | NotifyOrderStatusChangedAsyncを呼び出す | E-04（行13） | ○ |
| C-09 | BuyerIdentityGuidで通知先を決定 | E-04（行13）, E-05（行27-34） | ○ |
| C-10 | OrderStockConfirmedIntegrationEventHandlerがトリガーイベントを受信 | E-06 | ○ |
| C-11 | INotificationHandlerを実装 | E-03（行3-4） | ○ |
| C-12 | ログ出力でステータス更新を記録 | E-03（行25） | ○ |
| C-13 | OrderingApiTrace.LogOrderStatusUpdatedを使用 | E-03（行25） | ○ |
| C-14 | OrderStatusはStockConfirmed | E-03（行25） | ○ |
| C-15 | IIntegrationEventHandlerを実装 | E-04（行8） | ○ |
| C-16 | 非同期でイベント発行 | E-03（行31 async/await） | ○ |
| C-17 | OrderStockItemsは含まれない | E-01（行5-17） | ○ |
| C-18 | IntegrationEventインスタンス作成時にBuyer.Name, Buyer.IdentityGuidを使用 | E-03（行30） | ○ |
| C-19 | Order.BuyerId.Valueを使用してBuyerを検索 | E-03（行28） | ○ |
| C-20 | EventBusのリトライ仕様は実装依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- EventBusの具体的なリトライ仕様（回数、間隔）がソースコードから確認できない
  - 候補：RabbitMQ設定ファイル / Azure Service Bus設定 / EventBus実装クラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの主張がソースコードで直接確認可能
- 0: 低リスク - イベント構造がシンプルで、前後のフローも明確

## 6) レビュアーチェックリスト（最小）
- [ ] C-20のEventBusリトライ仕様について、実運用環境の設定を確認
- [ ] OrderStockRejected（在庫不足）時の処理フローとの整合性を確認
- [ ] SetStockConfirmedStatusCommand実行時のバリデーションを確認
