---
generated_at: 2026-01-14 21:37:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：4-支払完了通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **EventBusリトライ仕様**：具体的なリトライ回数・間隔がコードから確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToPaidIntegrationEvent.cs`
- E-02: `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToPaidIntegrationEvent.cs`
- E-03: `src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToPaidDomainEventHandler.cs`
- E-04: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToPaidIntegrationEventHandler.cs`
- E-05: `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs`
- E-06: `src/Catalog.API/IntegrationEvents/Events/OrderStatusChangedToPaidIntegrationEvent.cs`
- E-07: `src/Catalog.API/IntegrationEvents/EventHandling/OrderStatusChangedToPaidIntegrationEventHandler.cs`
- E-08: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToPaidIntegrationEvent.cs`
- E-09: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToPaidIntegrationEventHandler.cs`
- E-10: `src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderPaymentSucceededIntegrationEventHandler.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OrderStatusChangedToPaidIntegrationEventはOrderStockItemsを含む | E-01（行9） | ○ |
| C-02 | イベントはOrderId, OrderStatus, BuyerName, BuyerIdentityGuidを含む | E-01（行5-8） | ○ |
| C-03 | OrderStatusChangedToPaidDomainEventHandlerがイベント発行の起点 | E-03（行22-40） | ○ |
| C-04 | OrderRepositoryから注文取得 | E-03（行26） | ○ |
| C-05 | BuyerRepositoryから購入者取得 | E-03（行27） | ○ |
| C-06 | OrderStockItemリストをDomainEventのOrderItemsから作成 | E-03（行29-30） | ○ |
| C-07 | AddAndSaveEventAsyncでイベントをキューに追加 | E-03（行39） | ○ |
| C-08 | WebApp側でEventHandlerがイベントを受信 | E-04（行5-8） | ○ |
| C-09 | NotifyOrderStatusChangedAsyncを呼び出す | E-04（行13） | ○ |
| C-10 | Catalog.API側でもイベントを受信 | E-06, E-07 | ○ |
| C-11 | Webhooks.API側でもイベントを受信 | E-08, E-09 | ○ |
| C-12 | Webhooks.APIでWebhook送信処理が実行される | E-09（行8-17） | ○ |
| C-13 | WebhookType.OrderPaidでサブスクリプションを検索 | E-09（行10） | ○ |
| C-14 | OrderPaymentSucceededIntegrationEventHandlerがトリガーイベントを受信 | E-10 | ○ |
| C-15 | INotificationHandlerを実装 | E-03（行3） | ○ |
| C-16 | ログ出力でステータス更新を記録 | E-03（行24） | ○ |
| C-17 | OrderingApiTrace.LogOrderStatusUpdatedを使用 | E-03（行24） | ○ |
| C-18 | OrderStatusはPaid | E-03（行24） | ○ |
| C-19 | IIntegrationEventHandlerを実装 | E-04（行8）, E-09（行6） | ○ |
| C-20 | 非同期でイベント発行 | E-03（行39 async/await） | ○ |
| C-21 | WebhookDataにイベント情報をラップ | E-09（行14） | ○ |
| C-22 | sender.SendAllでWebhook送信 | E-09（行16） | ○ |
| C-23 | マルチキャスト配信で3つのサービスに送信 | E-04, E-07, E-09 | ○ |
| C-24 | EventBusのリトライ仕様は実装依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- EventBusの具体的なリトライ仕様（回数、間隔）がソースコードから確認できない
  - 候補：RabbitMQ設定ファイル / Azure Service Bus設定 / EventBus実装クラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの主張がソースコードで直接確認可能
- 1: 中リスク - 3サービスへのマルチキャスト配信のため、障害時の影響範囲が大きい
- 1: 中リスク - 支払完了は重要なビジネスイベントのため、確実な配信が必要

## 6) レビュアーチェックリスト（最小）
- [ ] C-24のEventBusリトライ仕様について、実運用環境の設定を確認
- [ ] WebApp、Catalog.API、Webhooks.APIでイベントを同時処理する場合の整合性を確認
- [ ] OrderPaymentFailed（決済失敗）時の処理フローとの整合性を確認
- [ ] Webhook送信失敗時のリトライ仕様を確認
