---
generated_at: 2026-01-14 21:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-注文支払完了Webhook

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **リトライ機構なし**：Webhook送信失敗時のリトライ機構が実装されていない点は設計判断として要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToPaidIntegrationEvent.cs`
- E-02: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToPaidIntegrationEventHandler.cs`
- E-03: `src/Webhooks.API/Model/WebhookData.cs`
- E-04: `src/Webhooks.API/Model/WebhookType.cs`
- E-05: `src/Webhooks.API/Model/WebhookSubscription.cs`
- E-06: `src/Webhooks.API/Services/WebhooksRetriever.cs`
- E-07: `src/Webhooks.API/Services/WebhooksSender.cs`
- E-08: `src/Webhooks.API/Infrastructure/WebhooksContext.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OrderStatusChangedToPaidIntegrationEventはOrderIdとOrderStockItemsを含む | E-01（行3） | ○ |
| C-02 | IIntegrationEventHandlerを実装 | E-02（行6） | ○ |
| C-03 | WebhookType.OrderPaidでサブスクリプションを検索 | E-02（行10） | ○ |
| C-04 | WebhookDataにイベントをラップ | E-02（行14） | ○ |
| C-05 | WebhooksSender.SendAllで送信 | E-02（行16） | ○ |
| C-06 | WebhookDataはWhen, Type, Payloadを持つ | E-03（行5-9） | ○ |
| C-07 | WhenはDateTime.UtcNow | E-03（行14） | ○ |
| C-08 | TypeはhookType.ToString() | E-03（行15） | ○ |
| C-09 | PayloadはJsonSerializer.Serialize(data) | E-03（行16） | ○ |
| C-10 | WebhookType.OrderPaid = 3 | E-04（行7） | ○ |
| C-11 | WebhookSubscriptionはId, Type, DestUrl, Token, UserIdを持つ | E-05（行5-13） | ○ |
| C-12 | DestUrlは必須（Required属性） | E-05（行10） | ○ |
| C-13 | WebhooksRetrieverはTypeでフィルタリング | E-06（行7） | ○ |
| C-14 | WebhooksRetrieverはWebhooksContextを使用 | E-06（行3） | ○ |
| C-15 | WebhooksSenderはHttpClientFactoryを使用 | E-07（行3） | ○ |
| C-16 | SendAllで並列送信（Task.WhenAll） | E-07（行9-10） | ○ |
| C-17 | POSTメソッドでHTTPリクエスト | E-07（行18） | ○ |
| C-18 | Content-Typeはapplication/json | E-07（行19） | ○ |
| C-19 | Tokenがある場合はX-eshop-whtokenヘッダーを追加 | E-07（行22-25） | ○ |
| C-20 | リトライ機構なし | E-07（全体を確認、リトライコードなし） | ○ |
| C-21 | WebhooksContextはDbSetを持つ | E-08（行10） | ○ |
| C-22 | TypeとUserIdにインデックス | E-08（行16-17） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの主張がソースコードで直接確認可能
- 2: 高リスク - Webhook送信失敗時のリトライ機構がない。本番環境での信頼性に影響する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] Webhook送信失敗時のリトライ機構を追加する必要があるか確認
- [ ] DestUrlの検証（GrantUrlTesterService）の実装を確認
- [ ] HTTPSの強制が必要かどうか確認
- [ ] 並列送信時のレート制限が必要かどうか確認
