---
generated_at: 2026-01-14 21:47:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-注文出荷完了Webhook

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **リトライ機構なし**：Webhook送信失敗時のリトライ機構が実装されていない点は設計判断として要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEvent.cs`
- E-02: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEventHandler.cs`
- E-03: `src/Webhooks.API/Model/WebhookData.cs`
- E-04: `src/Webhooks.API/Model/WebhookType.cs`
- E-05: `src/Webhooks.API/Model/WebhookSubscription.cs`
- E-06: `src/Webhooks.API/Services/WebhooksRetriever.cs`
- E-07: `src/Webhooks.API/Services/WebhooksSender.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OrderStatusChangedToShippedIntegrationEventはOrderId, OrderStatus, BuyerNameを含む | E-01（行3） | ○ |
| C-02 | IIntegrationEventHandlerを実装 | E-02（行6） | ○ |
| C-03 | WebhookType.OrderShippedでサブスクリプションを検索 | E-02（行10） | ○ |
| C-04 | WebhookDataにイベントをラップ | E-02（行14） | ○ |
| C-05 | WebhooksSender.SendAllで送信 | E-02（行16） | ○ |
| C-06 | WebhookDataはWhen, Type, Payloadを持つ | E-03（行5-9） | ○ |
| C-07 | WhenはDateTime.UtcNow | E-03（行14） | ○ |
| C-08 | TypeはhookType.ToString() | E-03（行15） | ○ |
| C-09 | PayloadはJsonSerializer.Serialize(data) | E-03（行16） | ○ |
| C-10 | WebhookType.OrderShipped = 2 | E-04（行6） | ○ |
| C-11 | WebhookSubscriptionはId, Type, DestUrl, Token, UserIdを持つ | E-05（行5-13） | ○ |
| C-12 | WebhooksRetrieverはTypeでフィルタリング | E-06（行7） | ○ |
| C-13 | WebhooksSenderはHttpClientFactoryを使用 | E-07（行3） | ○ |
| C-14 | SendAllで並列送信（Task.WhenAll） | E-07（行9-10） | ○ |
| C-15 | POSTメソッドでHTTPリクエスト | E-07（行18） | ○ |
| C-16 | Content-Typeはapplication/json | E-07（行19） | ○ |
| C-17 | Tokenがある場合はX-eshop-whtokenヘッダーを追加 | E-07（行22-25） | ○ |
| C-18 | リトライ機構なし | E-07（全体を確認、リトライコードなし） | ○ |
| C-19 | OrderStockItemsは含まれない | E-01（行3のrecord定義） | ○ |
| C-20 | ログでサブスクリプション数を出力 | E-02（行12） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの主張がソースコードで直接確認可能
- 2: 高リスク - Webhook送信失敗時のリトライ機構がない。本番環境での信頼性に影響する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] Webhook送信失敗時のリトライ機構を追加する必要があるか確認
- [ ] OrderPaid WebhookとOrderShipped Webhookのペイロード形式の違いが問題ないか確認
- [ ] HTTPSの強制が必要かどうか確認
