---
generated_at: 2026-01-14 21:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **パスワードリセット手順**：具体的な実装がコードから確認できない
  2. **AIチャットボット機能の詳細**：オプション機能のため詳細確認が必要
  3. **サポートへの連絡方法**：実際の連絡先情報が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - システム概要、技術スタック
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面構成一覧
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能構成一覧
- E-04: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図
- E-07: `docs/code-to-docs/画面設計書/1-カタログ画面.md` - カタログ画面設計
- E-08: `docs/code-to-docs/画面設計書/2-商品詳細画面.md` - 商品詳細画面設計
- E-09: `docs/code-to-docs/画面設計書/3-カート画面.md` - カート画面設計
- E-10: `docs/code-to-docs/画面設計書/4-チェックアウト画面.md` - チェックアウト画面設計
- E-11: `docs/code-to-docs/画面設計書/5-注文履歴画面.md` - 注文履歴画面設計
- E-12: `docs/code-to-docs/画面設計書/6-ログイン画面.md` - ログイン画面設計
- E-13: `docs/code-to-docs/画面設計書/21-ホーム画面.md` - WebhookClientホーム画面設計

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | eShopは.NET Aspireを使用したマイクロサービスベースのECサイト | E-01 | ○ |
| C-02 | 商品カタログ、買い物かご、注文処理、認証機能を提供 | E-01, E-03 | ○ |
| C-03 | カタログ画面はルートURL（/）でアクセス可能 | E-02, E-07 | ○ |
| C-04 | 商品は9件ずつページネーションで表示 | E-07 | ○ |
| C-05 | ブランドフィルタリング機能が利用可能 | E-07, E-03 | ○ |
| C-06 | 商品タイプフィルタリング機能が利用可能 | E-07, E-03 | ○ |
| C-07 | 商品詳細画面のURLは/item/{itemId:int}形式 | E-02, E-08 | ○ |
| C-08 | 商品詳細で商品名、価格、説明、ブランド名が確認可能 | E-08 | ○ |
| C-09 | ログイン済みユーザーは「Add to shopping bag」でカート追加 | E-08 | ○ |
| C-10 | 未ログインユーザーは「Log in to purchase」でログインへ誘導 | E-08 | ○ |
| C-11 | カート画面のURLは/cart | E-02, E-09 | ○ |
| C-12 | カート画面は認証必須（[Authorize]属性） | E-09 | ○ |
| C-13 | カート内で数量変更が可能 | E-09, E-04 (BR-024) | ○ |
| C-14 | 数量0で商品削除 | E-09 | ○ |
| C-15 | チェックアウト画面のURLは/checkout | E-02, E-10 | ○ |
| C-16 | チェックアウトで配送先住所入力が必要 | E-10, E-04 (BR-031) | ○ |
| C-17 | 住所項目はStreet, City, State, ZipCode, Countryの5項目 | E-10 | ○ |
| C-18 | すべての住所項目は必須入力 | E-10 | ○ |
| C-19 | 注文確定後は注文履歴画面にリダイレクト | E-10, E-06 | ○ |
| C-20 | 注文確定後にカートがクリアされる | E-10 | ○ |
| C-21 | 注文履歴画面のURLは/user/orders | E-02, E-11 | ○ |
| C-22 | 注文履歴で注文番号、日付、金額、ステータスが確認可能 | E-11 | ○ |
| C-23 | 注文ステータスがリアルタイムで更新される | E-11 | ○ |
| C-24 | 注文ステータスはSubmitted→AwaitingValidation→StockConfirmed→Paid→Shippedの順で遷移 | E-04 (BR-038〜BR-042) | ○ |
| C-25 | ログイン画面のURLは/user/login | E-02, E-12 | ○ |
| C-26 | ログイン画面はIdentity.APIへリダイレクト | E-12 | ○ |
| C-27 | ReturnUrlパラメータで元のページに戻る | E-12 | ○ |
| C-28 | 外部サイトへのオープンリダイレクトを防止 | E-12 | ○ |
| C-29 | WebhookClient画面でWebhook管理が可能 | E-02, E-03 | ○ |
| C-30 | Webhook追加画面のURLは/add-webhook | E-02 | ○ |
| C-31 | OrderPaidイベントでWebhook通知が送信可能 | E-04 (BR-061), E-03 | ○ |
| C-32 | AIチャットボットはAzure OpenAI/Ollamaで動作 | E-01, E-03 | ○ |
| C-33 | HybridAppでカタログ閲覧が可能 | E-02, E-03 | ○ |
| C-34 | HybridAppでは買い物かご機能は未実装 | E-02 | ○ |
| C-35 | 対応ブラウザはChrome, Edge, Safari, Firefox | **根拠なし** | △ |
| C-36 | ユーザー種別は一般ユーザーと管理者 | E-04, E-02 | ○ |
| C-37 | 認証にはメールアドレスとパスワードを使用 | E-04 (BR-001, BR-002) | ○ |
| C-38 | 買い物かごからチェックアウトへの遷移は「Check out」ボタン | E-09, E-06 | ○ |
| C-39 | カタログ画面から商品詳細への遷移は商品カードクリック | E-07, E-06 | ○ |
| C-40 | 注文キャンセルはPaid/Shipped状態では不可 | E-04 (BR-028) | ○ |
| C-41 | カード情報はチェックアウト時に必要 | E-04 (BR-032) | ○ |
| C-42 | パスワードリセット機能が存在 | E-04 (BR-003) | △ |
| C-43 | AIチャットボットで商品検索支援が可能 | E-03 | ○ |
| C-44 | 「Loading...」メッセージがデータ読み込み中に表示 | E-07, E-09, E-11 | ○ |
| C-45 | サポートへの連絡方法 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パスワードリセット機能の詳細**：業務要件（BR-003）では言及されているが、具体的な画面や操作フローがコードから確認できない
  - 候補：Identity.APIの追加画面確認 / 設定ファイル確認 / 開発者への確認
- **対応ブラウザの公式情報**：.NET Aspire/Blazorの標準対応ブラウザを参照したが、本プロジェクト固有の検証情報は未確認
  - 候補：テスト仕様書 / E2Eテスト設定 / 公式ドキュメント
- **サポート連絡先**：運用に関する連絡先情報がコードベースから確認できない
  - 候補：運用手順書 / インフラ設計書 / 管理者への確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - システム概要、画面構成、基本的な操作手順（十分な根拠あり）
- **0: 低リスク** - 購入フロー（STEP1〜5）の説明（画面設計書で詳細確認済み）
- **1: 中リスク** - パスワードリセット手順（業務要件に記載あるが実装詳細未確認）
- **0: 低リスク** - 注文ステータス遷移（業務要件で詳細定義済み）
- **1: 中リスク** - AIチャットボット機能（オプション機能、設定依存）
- **0: 低リスク** - Webhook管理機能（画面設計書・機能一覧で確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] パスワードリセット機能が実際に利用可能か確認
- [ ] 対応ブラウザでの動作確認が完了しているか確認
- [ ] AIチャットボット機能の設定手順が正しいか確認
- [ ] サポート連絡先の情報を追加する必要があるか検討
- [ ] 注文ステータスの説明が業務要件と一致しているか確認
- [ ] スクリーンショットや図の追加が必要か検討
