# eShop 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（TOP画面）](#3-トップページtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】商品閲覧機能（商品の検索・閲覧）](#4-step1商品閲覧機能商品の検索閲覧)
5. [【STEP2-3】買い物かご機能（商品の追加・管理）](#5-step2-3買い物かご機能商品の追加管理)
6. [【STEP3-4】チェックアウト機能（注文の確定）](#6-step3-4チェックアウト機能注文の確定)
7. [【STEP4-5】注文管理機能（注文履歴・ステータス確認）](#7-step4-5注文管理機能注文履歴ステータス確認)

**【サポート機能】**
8. [Webhook管理機能](#8-webhook管理機能)
9. [AIチャットボット機能](#9-aiチャットボット機能)
10. [モバイル/デスクトップアプリ機能](#10-モバイルデスクトップアプリ機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 eShopとは

eShopは、.NET Aspireを使用したマイクロサービスベースのECサイトアプリケーションです。商品カタログの閲覧から購入、注文管理まで、ECサイトに必要な機能を網羅した本格的なショッピングシステムです。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **商品閲覧** | 商品一覧表示、商品検索、ブランド/タイプ別フィルタリング、商品詳細確認 |
| **買い物かご** | 商品追加、数量変更、商品削除、合計金額確認 |
| **注文処理** | チェックアウト、配送先住所入力、注文確定 |
| **注文管理** | 注文履歴確認、注文ステータス追跡 |
| **Webhook管理** | Webhook登録、受信メッセージ確認（管理者向け） |

### 1.3 業務フロー概要

本システムにおける購入業務は、以下の流れで進行します：

```
┌─────────────────────────────────────────────────────────────────┐
│                        購入業務フロー                            │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  【STEP 1】顧客が商品カタログを閲覧・検索                        │
│      ↓                                                          │
│  【STEP 2】顧客が気に入った商品を買い物かごに追加                │
│      ↓                                                          │
│  【STEP 3】顧客がチェックアウト画面で配送先を入力                │
│      ↓                                                          │
│  【STEP 4】顧客が注文を確定し、システムが注文を処理              │
│      ↓                                                          │
│  【STEP 5】顧客が注文履歴で注文ステータスを確認                  │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **顧客（一般ユーザー）** | 商品閲覧・検索、買い物かご操作、チェックアウト、注文履歴確認 |
| **管理者** | Webhook管理、注文ステータス管理、システム監視 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| 商品カタログ | 商品一覧の表示、検索、フィルタリング機能 | STEP 1 |
| 商品詳細 | 商品の詳細情報表示、カート追加機能 | STEP 1-2 |
| 買い物かご | カート内商品の管理、数量変更機能 | STEP 2 |
| チェックアウト | 配送先入力、注文確定機能 | STEP 3-4 |
| 注文履歴 | 過去の注文一覧、ステータス確認機能 | STEP 5 |
| Webhook | イベント通知の登録・管理機能 | 管理者向け |
| AIチャットボット | 商品検索支援、操作サポート機能 | 随時利用 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 一般ユーザー（顧客） | 商品閲覧、購入、注文履歴確認が可能なエンドユーザー |
| 管理者 | Webhook管理、システム監視が可能な管理者ユーザー |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

---

## 2. ログイン・ログアウト手順

### 2.1 ログイン方法

1. ブラウザでeShopのトップページにアクセスします
2. 画面右上の「Log in」リンクまたはユーザーアイコンをクリックします
3. Identity.APIのログイン画面が表示されます

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| メールアドレス | 登録済みのメールアドレス（例：jane@example.com） |
| パスワード | 登録済みのパスワード |

4. 「Login」ボタンをクリックします
5. 認証に成功すると、元の画面（またはカタログ画面）に戻ります

**注意事項：**
- 買い物かごへの商品追加、チェックアウト、注文履歴の確認にはログインが必要です
- 商品の閲覧はログインなしで可能です

### 2.2 ログアウト方法

1. 画面右上のユーザー名またはユーザーアイコンをクリックします
2. 表示されるメニューから「Log out」を選択します
3. ログアウト確認画面が表示されます
4. 確認後、カタログ画面（トップページ）に戻ります

### 2.3 初回同意画面について

初めてログインする際、OAuth同意画面が表示される場合があります：

1. アプリケーションが要求する権限の一覧が表示されます
2. 内容を確認し、「Yes, Allow」ボタンをクリックします
3. 同意後、元の画面に戻ります

---

## 3. トップページ（TOP画面）

### 3.1 顧客向けTOP画面（カタログ画面）

トップページは商品カタログ画面として機能します。アプリケーションのルートURL（/）にアクセスすると表示されます。

**画面構成：**

| 要素 | 説明 |
|------|------|
| ヘッダー | ロゴ、ナビゲーション、ログインリンク、カートアイコン |
| フィルタセクション | ブランド、商品タイプのフィルタリング機能 |
| 商品一覧 | 商品カード形式で9件ずつ表示 |
| ページネーション | 複数ページの商品を切り替え |

**主な機能：**
- 商品一覧の閲覧
- ブランド別フィルタリング
- 商品タイプ別フィルタリング
- ページ切り替え
- 商品詳細画面への遷移

### 3.2 画面要素の説明

**商品カード：**
- 商品画像：商品の写真
- 商品名：商品の名前
- 価格：$xx.xx形式で表示

**フィルタタグ：**
- 「All」をクリックすると全商品を表示
- 特定のブランド/タイプをクリックすると該当商品のみ表示

---

## 4. 【STEP1】商品閲覧機能（商品の検索・閲覧）

> **業務フローでの位置**: 顧客が購入を検討するために商品カタログを閲覧・検索するステップです。

### 4.1 商品一覧を閲覧する

1. トップページ（/）にアクセスします
2. 商品がカード形式で一覧表示されます
3. 各商品カードには以下の情報が表示されます：
   - 商品画像
   - 商品名
   - 価格

### 4.2 商品をフィルタリングする

**ブランドでフィルタリング：**

1. 画面上部のブランドタグセクションを確認します
2. 希望のブランド名をクリックします
3. 選択したブランドの商品のみが表示されます
4. 「All」をクリックすると全ブランドの商品を再表示します

**商品タイプでフィルタリング：**

1. 画面上部の商品タイプタグセクションを確認します
2. 希望の商品タイプをクリックします
3. 選択したタイプの商品のみが表示されます
4. 「All」をクリックすると全タイプの商品を再表示します

### 4.3 ページを切り替える

1. 画面下部のページ番号リンクを確認します
2. 希望のページ番号をクリックします
3. 該当ページの商品一覧が表示されます
4. 現在のページは強調表示されます

### 4.4 商品詳細を確認する

1. 商品一覧から詳細を確認したい商品カードをクリックします
2. 商品詳細画面（/item/{商品ID}）に遷移します
3. 以下の詳細情報を確認できます：
   - 商品画像（大サイズ）
   - 商品名
   - ブランド名
   - 商品説明
   - 価格

---

## 5. 【STEP2-3】買い物かご機能（商品の追加・管理）

> **業務フローでの位置**: 顧客が購入したい商品を買い物かごに追加し、購入内容を管理するステップです。

### 5.1 商品を買い物かごに追加する（ログイン済み）

1. 商品詳細画面（/item/{商品ID}）を開きます
2. 商品情報を確認します
3. 「Add to shopping bag」ボタンをクリックします
4. カートに商品が追加され、「{数量} in shopping bag」と表示されます
5. 続けて追加する場合は再度ボタンをクリックします（数量が増加します）

### 5.2 商品を買い物かごに追加する（未ログイン）

1. 商品詳細画面（/item/{商品ID}）を開きます
2. 「Log in to purchase」ボタンをクリックします
3. ログイン画面にリダイレクトされます
4. ログイン後、商品詳細画面に戻ります
5. 「Add to shopping bag」ボタンでカートに追加できます

### 5.3 買い物かごの内容を確認する

1. 画面右上のカートアイコンをクリック、または直接「/cart」にアクセスします
2. カート画面が表示されます
3. 以下の情報を確認できます：
   - 各商品の画像、名前、単価、数量、小計
   - カート内の合計金額
   - カート内の合計商品数

### 5.4 商品の数量を変更する

1. カート画面（/cart）を開きます
2. 変更したい商品の数量入力欄を確認します
3. 新しい数量を入力します
4. 「Update」ボタンをクリックします
5. 数量と合計金額が更新されます

### 5.5 商品をカートから削除する

1. カート画面（/cart）を開きます
2. 削除したい商品の数量入力欄に「0」を入力します
3. 「Update」ボタンをクリックします
4. 商品がカートから削除されます

### 5.6 買い物を続ける

1. カート画面で「Continue shopping」リンクをクリックします
2. カタログ画面（トップページ）に戻ります
3. 引き続き商品を閲覧・追加できます

---

## 6. 【STEP3-4】チェックアウト機能（注文の確定）

> **業務フローでの位置**: 顧客がカート内の商品を購入するため、配送先情報を入力し注文を確定するステップです。

### 6.1 チェックアウト画面に進む

1. カート画面（/cart）で商品を確認します
2. 「Check out」ボタンをクリックします
3. チェックアウト画面（/checkout）に遷移します

### 6.2 配送先住所を入力する

チェックアウト画面で以下の配送先情報を入力します：

| 項目 | 入力内容 | 必須 |
|------|---------|------|
| Address | 番地・通り | 必須 |
| City | 市区町村 | 必須 |
| State | 州/県 | 必須 |
| Zip code | 郵便番号 | 必須 |
| Country | 国 | 必須 |

**注意事項：**
- ログイン情報から住所が事前入力される場合があります
- すべての項目は必須入力です
- 未入力の場合はエラーメッセージが表示されます

### 6.3 注文を確定する

1. 配送先情報を入力・確認します
2. 「Place order」ボタンをクリックします
3. 注文処理が実行されます
4. 注文履歴画面（/user/orders）に自動的に遷移します
5. 買い物かごは自動的にクリアされます

### 6.4 カートに戻る

1. チェックアウト画面で「Back to the shopping bag」リンクをクリックします
2. カート画面に戻ります
3. 注文はまだ確定されていません

---

## 7. 【STEP4-5】注文管理機能（注文履歴・ステータス確認）

> **業務フローでの位置**: 顧客が注文履歴を確認し、注文の処理状況を追跡するステップです。

### 7.1 注文履歴を確認する

1. ログイン状態で「/user/orders」にアクセスします
2. 注文履歴画面が表示されます
3. 以下の情報を確認できます：
   - 注文番号（Number）
   - 注文日（Date）
   - 合計金額（Total）
   - 注文ステータス（Status）

### 7.2 注文ステータスについて

注文は以下のステータスを経て処理されます：

| ステータス | 説明 |
|-----------|------|
| Submitted | 注文が送信され、処理待ちの状態 |
| AwaitingValidation | 在庫確認待ちの状態 |
| StockConfirmed | 在庫が確認された状態 |
| Paid | 支払いが完了した状態 |
| Shipped | 商品が出荷された状態 |
| Cancelled | 注文がキャンセルされた状態 |

### 7.3 リアルタイム更新機能

注文履歴画面では、注文ステータスがリアルタイムで更新されます：

1. 注文履歴画面を開いたままにします
2. バックエンドで注文ステータスが変更されると、自動的に画面が更新されます
3. 最新のステータスが即座に反映されます

---

## 8. Webhook管理機能

> **対象ユーザー**: 管理者・開発者向け

### 8.1 Webhookとは

Webhookは、特定のイベント（注文完了、価格変更など）が発生した際に、登録されたURLに通知を送信する機能です。外部システムとの連携に使用されます。

### 8.2 Webhook管理画面にアクセスする

1. WebhookClient（Webhook管理アプリケーション）にアクセスします
2. ログインが必要な場合はログインします
3. ホーム画面（/）が表示されます

### 8.3 登録済みWebhookを確認する

1. ホーム画面の「Registered Webhooks」セクションを確認します
2. 登録されているWebhookの一覧が表示されます
3. 各Webhookの詳細情報を確認できます

### 8.4 新しいWebhookを登録する

1. ホーム画面で「Add Webhook」リンクをクリックします
2. Webhook追加画面（/add-webhook）が表示されます
3. 以下の情報を入力します：
   - 通知先URL
   - 対象イベント（OrderPaid等）
4. 登録ボタンをクリックします
5. 登録成功後、ホーム画面に戻ります

### 8.5 受信メッセージを確認する

1. ホーム画面の「Received Messages」セクションを確認します
2. Webhookで受信したメッセージの一覧が表示されます
3. イベント内容と受信日時を確認できます

---

## 9. AIチャットボット機能

> **注意**: この機能はオプションであり、Azure OpenAIまたはOllamaの設定が必要です。

### 9.1 チャットボットとは

AIチャットボットは、商品検索や操作支援を行うフローティングパネル機能です。自然言語で質問することで、商品の検索やカート操作のサポートを受けられます。

### 9.2 チャットボットを使用する

1. 画面右下のチャットアイコンをクリックします
2. チャットパネルが開きます
3. テキスト入力欄に質問や要望を入力します
4. 送信ボタンをクリックまたはEnterキーを押します
5. AIが回答を返します

**使用例：**
- 「青いTシャツを探して」
- 「アウトドア用品を見せて」
- 「1万円以下の商品は？」

---

## 10. モバイル/デスクトップアプリ機能

> **対象**: HybridApp（MAUI Blazor Hybridアプリ）利用者向け

### 10.1 HybridAppとは

HybridAppは、.NET MAUI Blazor Hybridを使用したモバイル/デスクトップアプリケーションです。カタログ閲覧機能を提供します。

### 10.2 カタログを閲覧する

1. HybridAppを起動します
2. カタログ画面（/）が表示されます
3. WebApp版と同様の商品一覧、フィルタリング機能が利用できます

### 10.3 商品詳細を確認する

1. カタログ画面で商品をタップ/クリックします
2. 商品詳細画面（/item/{商品ID}）に遷移します
3. 商品の詳細情報を確認できます

**注意事項：**
- HybridApp版では買い物かご機能は未実装です
- 購入処理はWebApp版をご利用ください

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
購入業務フロー概要（再掲）
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【STEP 1】顧客が商品カタログを閲覧・検索 → 4章参照
    ↓
【STEP 2】顧客が気に入った商品を買い物かごに追加 → 5章参照
    ↓
【STEP 3】顧客がチェックアウト画面で配送先を入力 → 6章参照
    ↓
【STEP 4】顧客が注文を確定し、システムが注文を処理 → 6章参照
    ↓
【STEP 5】顧客が注文履歴で注文ステータスを確認 → 7章参照
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 11.1 【顧客】STEP1: 商品の閲覧と検索

商品を購入する最初のステップとして、カタログを閲覧します。

1. トップページにアクセスします
2. フィルタ機能を使って希望の商品を探します
3. 気になる商品の詳細画面を確認します

**ポイント：**
- この段階ではログインは不要です
- ブランドやタイプで絞り込むと効率的です

### 11.2 【顧客】STEP2: 買い物かごへの追加

購入したい商品を見つけたら、買い物かごに追加します。

1. 商品詳細画面で商品を確認します
2. 購入する場合はログインします
3. 「Add to shopping bag」ボタンをクリックします
4. 複数商品を追加する場合は繰り返します

**ポイント：**
- カートアイコンで現在のカート内容を確認できます
- 数量は後からカート画面で変更できます

### 11.3 【顧客】STEP3-4: チェックアウトと注文確定

商品の選択が完了したら、注文を確定します。

1. カート画面で内容を最終確認します
2. 「Check out」ボタンでチェックアウト画面に進みます
3. 配送先住所を入力します
4. 「Place order」ボタンで注文を確定します

**ポイント：**
- すべての住所項目は必須入力です
- 注文確定後はカートが自動的にクリアされます

### 11.4 【顧客】STEP5: 注文履歴の確認

注文確定後、注文の処理状況を確認できます。

1. 注文履歴画面（/user/orders）にアクセスします
2. 注文一覧で注文番号、日付、金額、ステータスを確認します
3. ステータスが更新されると自動的に反映されます

**ポイント：**
- 注文ステータスはリアルタイムで更新されます
- 問題がある場合はサポートにお問い合わせください

---

## 12. よくある質問と対処法

### 12.1 ログインに関するQ&A

**Q: ログインできません**

A: 以下を確認してください：
1. メールアドレスが正しく入力されているか確認します
2. パスワードが正しいか確認します（大文字・小文字に注意）
3. Caps Lockがオフになっているか確認します
4. ブラウザのCookieが有効になっているか確認します

**Q: パスワードを忘れました**

A: 管理者にお問い合わせください。パスワードリセットの手続きをご案内します。

### 12.2 買い物かごに関するQ&A

**Q: カートに商品を追加できません**

A: 以下を確認してください：
1. ログインしているか確認します
2. 「Add to shopping bag」ボタンをクリックしているか確認します
3. ページを再読み込みして再度お試しください

**Q: カートの商品が消えてしまいました**

A: 以下の原因が考えられます：
1. ログアウトした場合、カート内容は保持されます
2. 長時間放置した場合、セッションが切れている可能性があります
3. 再度ログインしてカートを確認してください

### 12.3 注文に関するQ&A

**Q: 注文を確定できません**

A: 以下を確認してください：
1. カートに商品が入っているか確認します
2. 配送先の全項目が入力されているか確認します
3. エラーメッセージが表示されている場合は内容を確認します

**Q: 注文をキャンセルしたい**

A: 注文のキャンセルについては、注文ステータスにより対応が異なります：
- 「Submitted」「AwaitingValidation」の場合：管理者に連絡してキャンセル可能
- 「Paid」「Shipped」の場合：キャンセル不可（サポートにご相談ください）

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| 「Loading...」が消えない | サーバーとの通信に問題がある | ページを再読み込みするか、しばらく待ってから再度お試しください |
| 「Your cart is empty」 | カートに商品がない状態でチェックアウトしようとした | 先に商品をカートに追加してください |
| 「The {項目名} field is required.」 | 必須入力項目が未入力 | 該当の項目を入力してください |
| 「Sorry, we couldn't find any such product.」 | 指定された商品が存在しない | 商品IDが正しいか確認し、カタログ画面から再度選択してください |
| 「Not found」 | 指定されたページが見つからない | URLが正しいか確認してください |

### 13.2 よくあるトラブルと解決方法

**画面が正しく表示されない**

1. ブラウザのキャッシュをクリアします
2. ページを再読み込みします（Ctrl+F5 または Cmd+Shift+R）
3. 別のブラウザでお試しください
4. 推奨ブラウザを使用しているか確認します

**ログイン状態が維持されない**

1. ブラウザのCookie設定を確認します
2. プライベートブラウジング/シークレットモードを使用していないか確認します
3. ブラウザを更新して再度ログインします

**注文ステータスが更新されない**

1. ページを再読み込みします
2. ブラウザのJavaScriptが有効になっているか確認します
3. しばらく待ってから再度確認します

### 13.3 サポートへの連絡方法

上記の対処法で解決しない場合は、サポートにお問い合わせください。

**お問い合わせ時にご準備いただく情報：**
- 発生した問題の詳細
- エラーメッセージ（表示されている場合）
- 操作手順
- 使用しているブラウザとバージョン
- 注文番号（注文に関する問題の場合）

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-14 | 初版作成 |

---

*本マニュアルは、eShopのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
