---
generated_at: 2026-01-14 22:45:00
metrics:
  claims_total: 60
  claims_with_evidence: 54
  claims_without_evidence: 6
confidence_derived: 0.90
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：54 / 60、根拠なし：6
- 優先レビュー（高）
  1. **NFT-009（大量注文処理ストレステスト）**：具体的な負荷パラメータの根拠なし
  2. **NFT-050/051（Service Discovery/負荷分散テスト）**：スケーリング構成の詳細根拠なし
  3. **NFT-052（Redisクラスタースケーリングテスト）**：クラスター構成の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/eShop.ServiceDefaults/Extensions.cs` - ヘルスチェック、OpenTelemetry設定
- E-02: `src/eShop.ServiceDefaults/AuthenticationExtensions.cs` - JWT Bearer認証設定
- E-03: `src/eShop.AppHost/Program.cs` - サービス構成、インフラ設定
- E-04: `src/Identity.API/Program.cs` - IdentityServer設定
- E-05: `src/Identity.API/Configuration/Config.cs` - OAuth2クライアント設定
- E-06: `src/Identity.API/Quickstart/SecurityHeadersAttribute.cs` - セキュリティヘッダー設定
- E-07: `src/Basket.API/Program.cs` - gRPCサービス設定
- E-08: `src/Basket.API/appsettings.json` - HTTP/2プロトコル設定
- E-09: `src/Ordering.API/Program.cs` - 認可設定
- E-10: `src/Ordering.API/Extensions/Extensions.cs` - MediatR/FluentValidation設定
- E-11: `src/EventBusRabbitMQ/RabbitMQEventBus.cs` - メッセージング、リトライ設定
- E-12: `src/EventBusRabbitMQ/EventBusOptions.cs` - リトライ回数設定
- E-13: `playwright.config.ts` - E2Eテスト設定
- E-14: `e2e/AddItemTest.spec.ts` - カート追加E2Eテスト
- E-15: `e2e/BrowseItemTest.spec.ts` - 商品閲覧E2Eテスト
- E-16: `e2e/RemoveItemTest.spec.ts` - カート削除E2Eテスト
- E-17: `tests/Ordering.FunctionalTests/OrderingApiTests.cs` - API機能テスト
- E-18: `docs/code-to-docs/非機能要件定義書/非機能要件定義書.md` - 非機能要件定義
- E-19: `src/Catalog.API/appsettings.json` - Catalog API設定
- E-20: `src/WebApp/Extensions/Extensions.cs` - WebApp認証設定
- E-21: `.github/workflows/pr-validation.yml` - CIワークフロー設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (NFT-001) | REST API応答時間テスト（Catalog API）- 1秒以内 | E-18, E-19 | ○ |
| C-02 (NFT-002) | REST API応答時間テスト（Ordering API）- 1秒以内 | E-18, E-09 | ○ |
| C-03 (NFT-003) | gRPC API応答時間テスト（Basket API）- 500ms以内 | E-18, E-07, E-08 | ○ |
| C-04 (NFT-004) | 画面表示時間テスト（WebApp）- 3秒以内 | E-18, E-20 | ○ |
| C-05 (NFT-005) | Redisキャッシュ読み書きテスト - 100ms以内 | E-18, E-03 | ○ |
| C-06 (NFT-006) | PostgreSQLクエリ時間テスト - 500ms以内 | E-18, E-03 | ○ |
| C-07 (NFT-007) | RabbitMQメッセージング処理テスト - 10回リトライ | E-11, E-12 | ○ |
| C-08 (NFT-008) | 同時接続負荷テスト - Standard Resilience Handler | E-01 | ○ |
| C-09 (NFT-009) | 大量注文処理ストレステスト - 具体的パラメータ | **根拠なし** | △ |
| C-10 (NFT-010) | Livenessエンドポイントテスト - /alive | E-01 | ○ |
| C-11 (NFT-011) | Readinessエンドポイントテスト - /health | E-01 | ○ |
| C-12 (NFT-012) | Ordering APIヘルスチェックテスト | E-03 | ○ |
| C-13 (NFT-013) | サービス障害分離テスト | E-03, E-18 | ○ |
| C-14 (NFT-014) | RabbitMQ接続復旧テスト - 10回リトライ | E-11, E-12 | ○ |
| C-15 (NFT-015) | PostgreSQL接続復旧テスト - Execution Strategy | E-10, E-18 | ○ |
| C-16 (NFT-016) | JWT Bearer認証テスト - 401 Unauthorized | E-02 | ○ |
| C-17 (NFT-017) | アクセストークン有効期限テスト - 2時間 | E-05 | ○ |
| C-18 (NFT-018) | OpenID Connect認証フローテスト | E-05, E-04 | ○ |
| C-19 (NFT-019) | PKCE対応テスト（MAUI） | E-05 | ○ |
| C-20 (NFT-020) | スコープベース認可テスト（orders） | E-05, E-09 | ○ |
| C-21 (NFT-021) | スコープベース認可テスト（basket） | E-05, E-02 | ○ |
| C-22 (NFT-022) | スコープベース認可テスト（webhooks） | E-05 | ○ |
| C-23 (NFT-023) | X-Content-Type-Optionsヘッダーテスト | E-06 | ○ |
| C-24 (NFT-024) | X-Frame-Optionsヘッダーテスト | E-06 | ○ |
| C-25 (NFT-025) | Content-Security-Policyヘッダーテスト | E-06 | ○ |
| C-26 (NFT-026) | Referrer-Policyヘッダーテスト | E-06 | ○ |
| C-27 (NFT-027) | FluentValidationバリデーションテスト | E-10 | ○ |
| C-28 (NFT-028) | 空のx-requestidヘッダーテスト | E-17 | ○ |
| C-29 (NFT-029) | HTTP/1.1 REST API互換性テスト | E-18, E-19 | ○ |
| C-30 (NFT-030) | HTTP/2 gRPC互換性テスト | E-08 | ○ |
| C-31 (NFT-031) | WebApp認証フローテスト | E-05, E-20 | ○ |
| C-32 (NFT-032) | MAUI認証フローテスト | E-05 | ○ |
| C-33 (NFT-033) | Swagger UI認証テスト | E-05 | ○ |
| C-34 (NFT-034) | API Versioningテスト | E-09, E-17 | ○ |
| C-35 (NFT-035) | 構造化ログ出力テスト | E-01 | ○ |
| C-36 (NFT-036) | MediatRコマンドログテスト | E-10 | ○ |
| C-37 (NFT-037) | 分散トレーシングテスト | E-01 | ○ |
| C-38 (NFT-038) | RabbitMQトレーシングテスト | E-11 | ○ |
| C-39 (NFT-039) | ランタイムメトリクス収集テスト | E-01 | ○ |
| C-40 (NFT-040) | DBマイグレーション自動実行テスト | E-10, E-04 | ○ |
| C-41 (NFT-041) | Unit of Workパターンテスト | E-10, E-18 | ○ |
| C-42 (NFT-042) | TransactionBehaviorテスト | E-10 | ○ |
| C-43 (NFT-043) | HTTPクライアントリトライテスト | E-01 | ○ |
| C-44 (NFT-044) | RabbitMQリトライテスト | E-11, E-12 | ○ |
| C-45 (NFT-045) | メッセージ永続化テスト | E-11 | ○ |
| C-46 (NFT-046) | キュー永続性テスト | E-11 | ○ |
| C-47 (NFT-047) | 手動Ackテスト | E-11 | ○ |
| C-48 (NFT-048) | IntegrationEventLogテスト | E-10 | ○ |
| C-49 (NFT-049) | IdentifiedCommandHandlerテスト | E-10 | ○ |
| C-50 (NFT-050) | Service Discoveryテスト - 具体的動作 | **根拠なし** | △ |
| C-51 (NFT-051) | 負荷分散テスト - 分散動作検証 | **根拠なし** | △ |
| C-52 (NFT-052) | Redisキャッシュスケーリングテスト | **根拠なし** | △ |
| C-53 (NFT-053) | 商品閲覧E2Eテスト | E-15 | ○ |
| C-54 (NFT-054) | カート追加E2Eテスト | E-14 | ○ |
| C-55 (NFT-055) | カート削除E2Eテスト | E-16 | ○ |
| C-56 (NFT-056) | ログインE2Eテスト | E-13 | ○ |
| C-57 (NFT-057) | Playwright CIリトライテスト | E-13 | ○ |
| C-58 (NFT-058) | OTLPエクスポーターテスト | E-01 | ○ |
| C-59 (NFT-059) | 開発環境サンプリングテスト | E-01 | ○ |
| C-60 (NFT-060) | デフォルトログレベルテスト | E-19, E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- **NFT-009（大量注文処理ストレステスト）**: 具体的な負荷パラメータ（同時リクエスト数、処理件数の閾値等）がコードベースに定義されていない
  - 候補：性能テスト計画書 / 負荷テスト設計書 / SLA定義書
- **NFT-050/051（Service Discovery/負荷分散テスト）**: .NET Aspireの動的スケーリング動作の具体的検証方法がコードベースに存在しない
  - 候補：インフラ設計書 / デプロイメント設計書 / スケーリングポリシー
- **NFT-052（Redisクラスタースケーリングテスト）**: 現在のコードはシングルRedisインスタンスを想定しており、クラスター構成の設定が存在しない
  - 候補：Redisクラスター設計書 / インフラ構成図

## 5) リスクフラグ（レビュー観点）
- **リスクレベル 1（中リスク）**: NFT-009, NFT-050, NFT-051, NFT-052
  - スケーリング・負荷テストの具体的パラメータが未定義
  - 本番環境での性能要件検証に影響する可能性
- **リスクレベル 0（低リスク）**: その他のテストケース
  - ソースコードまたは既存ドキュメントから根拠を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 性能テストの合格基準値（1秒、500ms、100ms等）がビジネス要件と整合しているか確認
- [ ] セキュリティテストのスコープ（orders, basket, webhooks）が全APIをカバーしているか確認
- [ ] E2Eテストケースが主要ユーザーフローを網羅しているか確認
- [ ] リトライ回数（10回）とバックオフ設定が運用要件に適しているか確認
- [ ] 根拠なし項目（NFT-009, NFT-050, NFT-051, NFT-052）の詳細パラメータを別途定義する必要があるか検討
- [ ] 開発環境限定の設定（ヘルスチェックエンドポイント公開等）が本番テストに影響しないか確認
