---
generated_at: 2026-01-14 22:15:00
metrics:
  claims_total: 45
  claims_with_evidence: 40
  claims_without_evidence: 5
confidence_derived: 0.89
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：40 / 45、根拠なし：5
- 優先レビュー（高）
  1. **稼働率99.9%の目標値**：設定ファイルに明示的な数値なし、業界標準からの推定
  2. **レスポンスタイム目標値**：コードに明示的なSLA設定なし、一般的なガイドラインからの推定
  3. **同時接続数の具体値**：設定ファイルに明示的な制限値なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/eShop.ServiceDefaults/Extensions.cs` - サービスデフォルト設定
- E-02: `src/eShop.ServiceDefaults/AuthenticationExtensions.cs` - 認証設定
- E-03: `src/Identity.API/appsettings.json` - トークン有効期限設定
- E-04: `src/Identity.API/Configuration/Config.cs` - クライアント・スコープ設定
- E-05: `src/EventBusRabbitMQ/EventBusOptions.cs` - EventBusリトライ設定
- E-06: `src/EventBusRabbitMQ/RabbitMQEventBus.cs` - RabbitMQ実装詳細
- E-07: `src/eShop.AppHost/Program.cs` - インフラストラクチャ構成
- E-08: `src/Basket.API/appsettings.json` - Basket API設定（HTTP/2）
- E-09: `src/Ordering.API/Application/Behaviors/LoggingBehavior.cs` - ロギング実装
- E-10: `src/Ordering.API/Application/Behaviors/TransactionBehavior.cs` - トランザクション管理
- E-11: `src/Ordering.API/Application/Behaviors/ValidatorBehavior.cs` - バリデーション実装
- E-12: `src/Identity.API/Quickstart/SecurityHeadersAttribute.cs` - セキュリティヘッダー
- E-13: `src/Basket.API/Grpc/BasketService.cs` - gRPCサービス実装
- E-14: `src/eShop.ServiceDefaults/HttpClientExtensions.cs` - HTTPクライアント認証
- E-15: `src/Shared/MigrateDbContextExtensions.cs` - マイグレーション設定
- E-16: `src/eShop.ServiceDefaults/eShop.ServiceDefaults.csproj` - 依存パッケージ
- E-17: `src/WebApp/Extensions/Extensions.cs` - WebApp認証設定
- E-18: `src/Ordering.API/Extensions/Extensions.cs` - Ordering API設定
- E-19: `src/Basket.API/Extensions/Extensions.cs` - Basket API設定
- E-20: `src/Basket.API/Repositories/RedisBasketRepository.cs` - Redisリポジトリ実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | gRPC APIはHTTP/2プロトコルを使用 | E-08 | ○ |
| C-02 | Redisをバスケットキャッシュに使用 | E-07, E-19, E-20 | ○ |
| C-03 | RabbitMQリトライ回数デフォルト10回 | E-05 | ○ |
| C-04 | 指数バックオフによるリトライ間隔 | E-06 | ○ |
| C-05 | ヘルスチェックエンドポイント/health, /alive | E-01 | ○ |
| C-06 | OpenID Connect + JWT Bearer認証 | E-02, E-04, E-16 | ○ |
| C-07 | アクセストークン有効期限2時間 | E-04 | ○ |
| C-08 | 永続トークン有効期限365日 | E-03 | ○ |
| C-09 | X-Content-Type-Options: nosniff | E-12 | ○ |
| C-10 | X-Frame-Options: SAMEORIGIN | E-12 | ○ |
| C-11 | Content-Security-Policy設定 | E-12 | ○ |
| C-12 | Referrer-Policy: no-referrer | E-12 | ○ |
| C-13 | orders, basket, webhooksスコープ | E-04 | ○ |
| C-14 | Standard Resilience Handler使用 | E-01, E-16 | ○ |
| C-15 | .NET Aspire Service Discovery | E-01, E-07 | ○ |
| C-16 | PostgreSQLデータベース使用 | E-07, E-18 | ○ |
| C-17 | ログレベルデフォルトInformation | E-03, E-08 | ○ |
| C-18 | ASP.NET CoreログレベルWarning | E-03, E-08 | ○ |
| C-19 | OpenTelemetryトレーシング | E-01, E-16 | ○ |
| C-20 | OpenTelemetryメトリクス | E-01 | ○ |
| C-21 | OTLP Exporter対応 | E-01 | ○ |
| C-22 | MediatR LoggingBehavior | E-09, E-18 | ○ |
| C-23 | TransactionBehavior | E-10, E-18 | ○ |
| C-24 | Entity Framework自動マイグレーション | E-15 | ○ |
| C-25 | FluentValidation使用 | E-11, E-18 | ○ |
| C-26 | Unit of Workパターン | E-10 | ○ |
| C-27 | BrokerUnreachableException対応 | E-06 | ○ |
| C-28 | SocketException対応 | E-06 | ○ |
| C-29 | メッセージ永続配信（Persistent） | E-06 | ○ |
| C-30 | キュー永続性（durable: true） | E-06 | ○ |
| C-31 | 手動Ack方式 | E-06 | ○ |
| C-32 | PKCEサポート | E-04 | ○ |
| C-33 | Swagger UI Implicit Flow | E-04 | ○ |
| C-34 | .NET 10.0ターゲット | E-16 | ○ |
| C-35 | 開発環境でAlwaysOnSampler | E-01 | ○ |
| C-36 | RabbitMQ Persistent Lifetime | E-07 | ○ |
| C-37 | 認証トークン伝播 | E-14 | ○ |
| C-38 | gRPC認証（Unauthenticated処理） | E-13 | ○ |
| C-39 | セッションCookie有効期限60分デフォルト | E-17 | ○ |
| C-40 | AI統合（OpenAI/Ollama）オプション | E-07 | ○ |
| C-41 | 稼働率99.9%目標 | **根拠なし** | △ |
| C-42 | レスポンスタイム目標値（3秒、1秒、500ms等） | **根拠なし** | △ |
| C-43 | 同時接続数の具体的設定 | **根拠なし** | △ |
| C-44 | RTO/RPO目標値 | **根拠なし** | △ |
| C-45 | Dead Letter Exchange推奨 | E-06（コメント） | △ |

## 4) 不足情報（Unknown / Missing）
- **SLA/SLO定義ドキュメント**：稼働率、レスポンスタイム等の明示的なサービスレベル目標が設定ファイルやドキュメントに存在しない
  - 候補：運用要件定義書 / SLA合意書 / パフォーマンステスト結果
- **キャパシティプランニング資料**：同時接続数、スループット等の具体的な設計値が未定義
  - 候補：負荷テスト計画書 / キャパシティ設計書 / インフラ設計書
- **災害復旧計画**：RTO/RPOの目標値がコードベースに明示されていない
  - 候補：DR計画書 / バックアップポリシー / 運用手順書

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：認証・認可設定、ロギング・トレーシング設定、メッセージング設定
- 1（中リスク）：Dead Letter Exchangeの未実装（メッセージ消失リスク）
- 1（中リスク）：本番環境でのヘルスチェックエンドポイント公開判断
- 2（高リスク）：SLA/SLO目標値が明示されていない（運用契約リスク）
- 1（中リスク）：HTTPS強制設定が開発環境で無効化されている

## 6) レビュアーチェックリスト（最小）
- [ ] SLA/SLO目標値が組織の要件と整合しているか確認
- [ ] レスポンスタイム目標値が実際のパフォーマンステスト結果と整合するか確認
- [ ] Dead Letter Exchange実装の必要性と優先度を判断
- [ ] 本番環境でのHTTPS強制設定を確認
- [ ] ヘルスチェックエンドポイントの公開ポリシーを確認
- [ ] キャパシティ設計値（同時接続数、スループット）の妥当性を確認
- [ ] セキュリティヘッダー設定が組織のセキュリティポリシーと整合するか確認
- [ ] トークン有効期限設定がセキュリティ要件を満たしているか確認
