# 非機能要件定義書

## 概要

本ドキュメントは、eShopマイクロサービスアプリケーションの非機能要件を定義します。本システムは.NET Aspire基盤で構築されたマイクロサービスアーキテクチャを採用しており、複数のサービス（Catalog API、Basket API、Ordering API、Identity API等）で構成されています。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| 画面表示 | 3秒以内 | WebApp、WebhookClient等のフロントエンド画面 |
| REST API応答 | 1秒以内 | Catalog API、Ordering API等のHTTPエンドポイント |
| gRPC API応答 | 500ms以内 | Basket APIのgRPCサービス（HTTP/2プロトコル使用） |
| データベースクエリ | 500ms以内 | PostgreSQL（Catalog、Identity、Ordering、Webhooks）へのクエリ |
| キャッシュ読み書き | 100ms以内 | Redisキャッシュ（Basket API） |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時接続数 | システム全体として適切に負荷分散 | .NET Aspireによるサービス検出・負荷分散 |
| 秒間リクエスト数 | 各サービスで個別に設定可能 | Standard Resilience Handlerによる制御 |
| メッセージング処理 | RabbitMQキューによる非同期処理 | 最大10回のリトライ（指数バックオフ） |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | 99.9%（目標） | マイクロサービスアーキテクチャにより個別サービスの障害を分離 |
| 計画停止時間 | 最小化 | ローリングデプロイによるダウンタイム削減 |
| 障害復旧時間（RTO） | 各サービス独立して復旧可能 | ヘルスチェック機能による自動検出 |
| 目標復旧時点（RPO） | PostgreSQLのトランザクション単位 | Entity Frameworkによるトランザクション管理 |

### ヘルスチェック設定

- **Livenessエンドポイント**: `/alive` - アプリケーションの生存確認
- **Readinessエンドポイント**: `/health` - トラフィック受付準備完了確認
- **ヘルスチェック対象**: 自己診断（self）タグによる管理

## セキュリティ要件

### 認証・認可

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| 認証方式 | OpenID Connect + JWT Bearer | Identity APIがIdentityServerとして機能 |
| トークン有効期限 | アクセストークン: 2時間、永続トークン: 365日 | 設定ファイルで管理 |
| 認可方式 | スコープベース認可 | orders, basket, webhooks等のスコープ |
| クライアント認証 | PKCE対応Authorization Code Flow | maui、webapp等のクライアント設定 |

### セキュリティヘッダー

| ヘッダー | 設定値 | 目的 |
| --- | --- | --- |
| X-Content-Type-Options | nosniff | MIMEタイプスニッフィング防止 |
| X-Frame-Options | SAMEORIGIN | クリックジャッキング防止 |
| Content-Security-Policy | default-src 'self'; object-src 'none'; frame-ancestors 'none' | XSS・インジェクション防止 |
| Referrer-Policy | no-referrer | リファラー情報漏洩防止 |

### API保護スコープ

| スコープ名 | 対象サービス |
| --- | --- |
| orders | Ordering API |
| basket | Basket API |
| webhooks | Webhooks API |

## 拡張性要件

### 水平スケーリング

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| サービス検出 | .NET Aspire Service Discovery | 動的サービス登録・検出 |
| 負荷分散 | HttpClient標準レジリエンスハンドラー | 自動リトライ・サーキットブレーカー |
| メッセージング | RabbitMQ | 非同期イベント駆動によるスケーラブルな処理 |
| キャッシュ | Redis | 分散キャッシュによるステート管理 |

### インフラストラクチャ

| コンポーネント | 用途 | スケーリング方式 |
| --- | --- | --- |
| PostgreSQL | データ永続化（Catalog、Identity、Ordering、Webhooks） | 読み取りレプリカ拡張可能 |
| Redis | セッション・バスケットキャッシュ | クラスター構成可能 |
| RabbitMQ | イベントバス（Persistent Lifetime） | クラスター構成可能 |

## 保守性要件

### ロギング

| 項目 | 設定内容 | 備考 |
| --- | --- | --- |
| デフォルトログレベル | Information | 運用時のログ収集 |
| ASP.NET Coreログレベル | Warning | フレームワークログの抑制 |
| ログ形式 | 構造化ログ（フォーマット済み・スコープ含む） | OpenTelemetry対応 |
| コマンドロギング | MediatR LoggingBehavior | コマンド実行前後のログ記録 |
| トランザクションロギング | TransactionBehavior | トランザクション開始・コミットのログ記録 |

### 監視・トレーシング

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| 分散トレーシング | OpenTelemetry | ASP.NET Core、HTTP Client、gRPC対応 |
| メトリクス収集 | OpenTelemetry Metrics | ランタイムメトリクス含む |
| テレメトリエクスポート | OTLP（OpenTelemetry Protocol） | 環境変数による設定 |
| RabbitMQトレーシング | カスタムActivitySource | メッセージングスパン対応 |

### デプロイメント

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| アプリケーションホスト | .NET Aspire AppHost | 開発・本番環境の統一管理 |
| データベースマイグレーション | Entity Framework自動マイグレーション | 起動時に自動実行 |
| シード処理 | IDbSeederインターフェース | 初期データ投入 |

## 信頼性要件

### データ整合性

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| トランザクション管理 | Unit of Workパターン | OrderingContextによる実装 |
| 実行戦略 | Entity Framework Execution Strategy | リトライ可能なトランザクション |
| 統合イベント | IntegrationEventLogService | イベントのアウトボックスパターン |
| バリデーション | FluentValidation + ValidatorBehavior | コマンド実行前の検証 |

### リトライ・耐障害性

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| HTTPクライアントリトライ | Standard Resilience Handler | Polly統合による自動リトライ |
| RabbitMQリトライ回数 | デフォルト10回 | 指数バックオフ（2^n秒） |
| 対象例外 | BrokerUnreachableException, SocketException | 一時的障害への対応 |
| メッセージ配信モード | Persistent（永続） | メッセージ消失防止 |

### キュー設定

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| キュー永続性 | durable: true | RabbitMQ再起動後もキュー維持 |
| 排他性 | exclusive: false | 複数コンシューマー対応 |
| 自動削除 | autoDelete: false | コンシューマー切断後もキュー維持 |
| Ack方式 | 手動Ack（autoAck: false） | メッセージ処理完了保証 |

## 互換性要件

### プロトコル対応

| プロトコル | 用途 | 対応サービス |
| --- | --- | --- |
| HTTP/1.1 | REST API | Catalog API、Ordering API、Webhooks API |
| HTTP/2 | gRPC | Basket API |
| AMQP | メッセージング | 全サービス（RabbitMQ経由） |

### クライアント対応

| クライアント種別 | 認証フロー | 対応機能 |
| --- | --- | --- |
| WebApp | Authorization Code Flow | フルスコープアクセス |
| MAUI Mobile | Authorization Code Flow + PKCE | オフラインアクセス対応 |
| Swagger UI | Implicit Flow | 開発・テスト用 |
| Webhooks Client | Authorization Code Flow | Webhook登録・管理 |

### フレームワーク・ランタイム

| 項目 | バージョン | 備考 |
| --- | --- | --- |
| .NET | 10.0 | ターゲットフレームワーク |
| ASP.NET Core | 対応バージョン | Webアプリケーションフレームワーク |
| Entity Framework Core | 対応バージョン | データアクセス |
| .NET Aspire | 最新 | マイクロサービス基盤 |

## 備考

### 開発環境固有設定

- ヘルスチェックエンドポイントは開発環境でのみ公開（セキュリティ考慮）
- トレーシングは開発環境で全サンプリング（AlwaysOnSampler）
- HTTPS検証は開発時に無効化可能（RequireHttpsMetadata = false）

### 運用時考慮事項

- Dead Letter Exchange（DLX）の実装を推奨（現在未実装）
- Prometheusエンドポイントはコメントアウト状態（必要に応じて有効化）
- 本番環境ではHTTPS強制を推奨（upgrade-insecure-requests対応済み構造）

### AI機能統合

- OpenAI/Ollama統合オプションあり（chatModelによる設定）
- Experimental.Microsoft.Extensions.AIによるメトリクス・トレーシング対応
