# API設計書

## 概要

本ドキュメントは、Etherpad Lite のHTTP APIについて記載しています。Etherpadは、リアルタイムコラボレーションエディタであり、複数のユーザーが同時にドキュメントを編集できます。本APIは、パッド（ドキュメント）の操作、グループ管理、著者管理、セッション管理などの機能を提供します。

## 共通仕様

### ベースURL

```
/api/{version}
/rest/{version}
/api/2
```

- 最新APIバージョン: `1.3.0`
- REST API v2: `/api/2` (OpenAPI 3.0.2準拠)
- レガシーAPIは `/api/{version}` または `/rest/{version}` で利用可能

### 認証方式

Etherpadは2つの認証方式をサポートしています：

1. **API Key認証**
   - クエリパラメータ `apikey` でAPIキーを送信
   - サーバー設定の `APIKEY.txt` からキーを取得

2. **OAuth 2.0 / OpenID Connect (SSO)**
   - Bearer トークンをAuthorizationヘッダーで送信
   - 認可コードフロー・クライアントクレデンシャルフローをサポート
   - エンドポイント: `/oidc/*`

### 共通ヘッダー

| ヘッダー名 | 必須 | 説明 |
| --- | --- | --- |
| Authorization | - | Bearer トークン (SSO認証時) |
| Content-Type | - | application/json (POST/PUT/PATCH/DELETE時) |
| Accept | - | application/json |

### 共通エラーレスポンス

Etherpad APIは独自のレスポンス形式を使用します：

| code | HTTPステータス | 説明 |
| --- | --- | --- |
| 0 | 200 | 成功 (ok) |
| 1 | 200 | 一般的なAPIエラー (パラメータ不正等) |
| 2 | 500 | 内部エラー (internal error) |
| 3 | 404 | 関数が存在しない (no such function) |
| 4 | 401/403 | 認証エラー (no or wrong API key) |

**レスポンス形式：**

```json
{
  "code": 0,
  "message": "ok",
  "data": { ... }
}
```

---

## API一覧

### Group API

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| Group | /api/2/groups | POST | 新規グループを作成 |
| Group | /api/2/groups | GET | 全グループ一覧を取得 |
| Group | /api/2/groups | DELETE | グループを削除 |
| Group | /api/2/groups/createIfNotExistsFor | POST | グループが存在しない場合のみ作成 |
| Group | /api/2/groups/pads | GET | グループ内の全パッドを取得 |

### Author API

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| Author | /api/2/authors | POST | 新規著者を作成 |
| Author | /api/2/authors/createIfNotExistsFor | POST | 著者が存在しない場合のみ作成 |
| Author | /api/2/authors/pads | GET | 著者が関与した全パッドを取得 |
| Author | /api/2/authors/name | GET | 著者名を取得 |

### Session API

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| Session | /api/2/sessions | POST | 新規セッションを作成 |
| Session | /api/2/sessions | DELETE | セッションを削除 |
| Session | /api/2/sessions/info | GET | セッション情報を取得 |
| Session | /api/2/sessions/group | GET | グループの全セッションを取得 |
| Session | /api/2/sessions/author | GET | 著者の全セッションを取得 |

### Pad API

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| Pad | /api/2/pads | GET | 全パッド一覧を取得 |
| Pad | /api/2/pads | POST | 新規パッドを作成 |
| Pad | /api/2/pads | DELETE | パッドを削除 |
| Pad | /api/2/pads/text | GET | パッドのテキストを取得 |
| Pad | /api/2/pads/text | POST | パッドのテキストを設定 |
| Pad | /api/2/pads/text | PATCH | パッドにテキストを追加 |
| Pad | /api/2/pads/html | GET | パッドのHTMLを取得 |
| Pad | /api/2/pads/html | POST | パッドのHTMLを設定 |
| Pad | /api/2/pads/revisions | GET | パッドのリビジョン数を取得 |
| Pad | /api/2/pads/lastEdited | GET | 最終編集日時を取得 |
| Pad | /api/2/pads/readonly | GET | 読み取り専用IDを取得 |
| Pad | /api/2/pads/publicStatus | GET | 公開ステータスを取得 |
| Pad | /api/2/pads/publicStatus | POST | 公開ステータスを設定 |
| Pad | /api/2/pads/authors | GET | パッドの全著者を取得 |
| Pad | /api/2/pads/usersCount | GET | 現在のユーザー数を取得 |
| Pad | /api/2/pads/users | GET | 現在のユーザー一覧を取得 |
| Pad | /api/2/pads/clientsMessage | POST | 全クライアントにメッセージ送信 |
| Pad | /api/2/pads/chatHistory | GET | チャット履歴を取得 |
| Pad | /api/2/pads/chatHead | GET | 最新チャットメッセージを取得 |
| Pad | /api/2/pads/diff | POST | リビジョン間のdiffを生成 |
| Pad | /api/2/pads/attributePool | GET | 属性プールを取得 |
| Pad | /api/2/pads/revisionChangeset | GET | リビジョンのchangesetを取得 |
| Pad | /api/2/pads/copypad | POST | パッドをコピー |
| Pad | /api/2/pads/movePad | POST | パッドを移動 |
| Pad | /api/2/pads/copyWithoutHistory | POST | 履歴なしでパッドをコピー |
| Pad | /api/2/pads/group | POST | グループパッドを作成 |
| Pad | /api/2/pads/padId | POST | 読み取り専用IDからパッドIDを取得 |

### Saved Revisions API

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| SavedRevisions | /api/2/savedRevisions | GET | 保存済みリビジョン一覧を取得 |
| SavedRevisions | /api/2/savedRevisions | POST | リビジョンを保存 |
| SavedRevisions | /api/2/savedRevisions | PATCH | リビジョンを復元 |
| SavedRevisions | /api/2/savedRevisions/revisionsCount | GET | 保存済みリビジョン数を取得 |

### Chat API

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| Chat | /api/2/chats/messages | PATCH | チャットメッセージを追加 |

### Token/Stats API

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| Token | /api/2/checkToken | GET | APIトークンの検証 |
| Stats | /api/2/stats | GET | インスタンス統計情報を取得 |

### その他のエンドポイント

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| Health | /health | GET | ヘルスチェック |
| Stats | /stats | GET | 統計情報 (設定で有効化時) |
| Stats | /stats/prometheus | GET | Prometheus形式の統計 |
| API | /api | GET | 最新APIバージョンを取得 |
| API Docs | /api-docs | GET | Swagger UI |
| API Docs | /api-docs.json | GET | OpenAPI定義 |
| Export | /p/:pad/export/:type | GET | パッドをエクスポート |
| Import | /p/:pad/import | POST | パッドにインポート |
| OIDC | /oidc/* | - | OpenID Connect認証 |
| Admin | /admin/* | GET | 管理画面 |

---

## 各APIエンドポイント定義

### Group

#### 1. グループ作成

新しいグループを作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/2/groups` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**リクエストボディ**

なし

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "groupID": "g.s8oes9dhwrvt0zif"
  }
}
```

---

#### 2. グループの条件付き作成

グループが存在しない場合のみ作成します。アプリケーションのグループIDをEtherpadグループIDにマッピングする際に使用します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/2/groups/createIfNotExistsFor` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**リクエストボディ**

```json
{
  "groupMapper": "myAppGroupId123"
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| groupMapper | string | ○ | - | アプリケーション側のグループID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "groupID": "g.s8oes9dhwrvt0zif"
  }
}
```

---

#### 3. グループ削除

グループを削除します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `DELETE /api/2/groups` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**リクエストボディ**

```json
{
  "groupID": "g.s8oes9dhwrvt0zif"
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| groupID | string | ○ | - | 削除するグループID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": null
}
```

---

#### 4. 全グループ一覧取得

全てのグループを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/groups` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.1+ |

**クエリパラメータ**

なし

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "groupIDs": ["g.s8oes9dhwrvt0zif", "g.akf8finncvomlqva"]
  }
}
```

---

#### 5. グループ内パッド一覧

グループ内の全パッドを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/groups/pads` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| groupID | string | ○ | - | グループID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "padIDs": ["g.s8oes9dhwrvt0zif$test", "g.s8oes9dhwrvt0zif$doc1"]
  }
}
```

---

### Author

#### 6. 著者作成

新しい著者を作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/2/authors` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**リクエストボディ**

```json
{
  "name": "John Doe"
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| name | string | ○ | - | 著者名 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "authorID": "a.s8oes9dhwrvt0zif"
  }
}
```

---

#### 7. 著者の条件付き作成

著者が存在しない場合のみ作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/2/authors/createIfNotExistsFor` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**リクエストボディ**

```json
{
  "authorMapper": "myAppUserId123",
  "name": "John Doe"
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| authorMapper | string | ○ | - | アプリケーション側のユーザーID |
| name | string | ○ | - | 著者名 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "authorID": "a.s8oes9dhwrvt0zif"
  }
}
```

---

#### 8. 著者名取得

著者名を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/authors/name` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.1+ |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| authorID | string | ○ | - | 著者ID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "authorName": "John Doe"
  }
}
```

---

#### 9. 著者のパッド一覧

著者が関与した全パッドを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/authors/pads` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| authorID | string | ○ | - | 著者ID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "padIDs": ["test", "document1", "meeting-notes"]
  }
}
```

---

### Session

#### 10. セッション作成

新しいセッションを作成します。グループパッドへのアクセス権を付与するために使用します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/2/sessions` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**リクエストボディ**

```json
{
  "groupID": "g.s8oes9dhwrvt0zif",
  "authorID": "a.s8oes9dhwrvt0zif",
  "validUntil": "1735689600"
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| groupID | string | ○ | - | グループID |
| authorID | string | ○ | - | 著者ID |
| validUntil | string | ○ | Unixタイムスタンプ(秒) | セッション有効期限 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "sessionID": "s.s8oes9dhwrvt0zif"
  }
}
```

---

#### 11. セッション削除

セッションを削除します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `DELETE /api/2/sessions` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**リクエストボディ**

```json
{
  "sessionID": "s.s8oes9dhwrvt0zif"
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| sessionID | string | ○ | - | セッションID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": null
}
```

---

#### 12. セッション情報取得

セッションの詳細情報を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/sessions/info` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| sessionID | string | ○ | - | セッションID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "id": "s.s8oes9dhwrvt0zif",
    "groupID": "g.s8oes9dhwrvt0zif",
    "authorID": "a.s8oes9dhwrvt0zif",
    "validUntil": 1735689600
  }
}
```

---

#### 13. グループのセッション一覧

グループの全セッションを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/sessions/group` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| groupID | string | ○ | - | グループID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "sessions": [
      {
        "id": "s.s8oes9dhwrvt0zif",
        "authorID": "a.s8oes9dhwrvt0zif",
        "groupID": "g.s8oes9dhwrvt0zif",
        "validUntil": 1735689600
      }
    ]
  }
}
```

---

#### 14. 著者のセッション一覧

著者の全セッションを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/sessions/author` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| authorID | string | ○ | - | 著者ID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "sessions": [
      {
        "id": "s.s8oes9dhwrvt0zif",
        "authorID": "a.s8oes9dhwrvt0zif",
        "groupID": "g.s8oes9dhwrvt0zif",
        "validUntil": 1735689600
      }
    ]
  }
}
```

---

### Pad

#### 15. 全パッド一覧取得

全てのパッドを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/pads` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.2.1+ |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| groupID | string | - | - | 特定グループのパッドのみ取得 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "padIDs": ["test", "document1", "g.xxx$meeting"]
  }
}
```

---

#### 16. パッド作成

新しいパッドを作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/2/pads` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.3.0+ |

**リクエストボディ**

```json
{
  "padID": "myNewPad",
  "text": "Welcome to my pad!",
  "authorId": "a.xxx"
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | - | URL特殊文字不可、$不可 | パッドID |
| text | string | - | - | 初期テキスト |
| authorId | string | - | - | 作成者ID (v1.3.0+) |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": null
}
```

**レスポンス（エラー時）**

ステータスコード: `200 OK` (APIエラー)

```json
{
  "code": 1,
  "message": "padID does already exist",
  "data": null
}
```

---

#### 17. パッド削除

パッドを削除します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `DELETE /api/2/pads` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**リクエストボディ**

```json
{
  "padID": "myPad"
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": null
}
```

---

#### 18. テキスト取得

パッドのテキストを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/pads/text` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |
| rev | integer | - | 最新 | リビジョン番号 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "text": "Welcome to Etherpad!\n\nThis is a collaborative document."
  }
}
```

---

#### 19. テキスト設定

パッドのテキストを設定します（上書き）。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/2/pads/text` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.3.0+ |

**リクエストボディ**

```json
{
  "padID": "myPad",
  "text": "New content for the pad",
  "authorId": "a.xxx"
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |
| text | string | ○ | - | 設定するテキスト |
| authorId | string | ○ | - | 著者ID (v1.3.0+) |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": null
}
```

---

#### 20. テキスト追加

パッドにテキストを追加します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `PATCH /api/2/pads/text` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.3.0+ |

**リクエストボディ**

```json
{
  "padID": "myPad",
  "text": "\nAdditional content",
  "authorID": "a.xxx"
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |
| text | string | ○ | - | 追加するテキスト |
| authorID | string | ○ | - | 著者ID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": null
}
```

---

#### 21. HTML取得

パッドのHTMLを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/pads/html` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |
| rev | integer | - | 最新 | リビジョン番号 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "html": "<!DOCTYPE HTML><html><body><p>Welcome to Etherpad!</p></body></html>"
  }
}
```

---

#### 22. HTML設定

パッドのHTMLを設定します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/2/pads/html` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.3.0+ |

**リクエストボディ**

```json
{
  "padID": "myPad",
  "html": "<p>Hello <strong>World</strong></p>",
  "authorId": "a.xxx"
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |
| html | string | ○ | 有効なHTML | HTMLコンテンツ |
| authorId | string | ○ | - | 著者ID (v1.3.0+) |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": null
}
```

---

#### 23. リビジョン数取得

パッドのリビジョン数を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/pads/revisions` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "revisions": 56
  }
}
```

---

#### 24. 最終編集日時取得

パッドの最終編集日時を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/pads/lastEdited` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "lastEdited": 1340815946602
  }
}
```

---

#### 25. 読み取り専用ID取得

パッドの読み取り専用IDを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/pads/readonly` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "readOnlyID": "r.s8oes9dhwrvt0zif"
  }
}
```

---

#### 26. 公開ステータス取得

グループパッドの公開ステータスを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/pads/publicStatus` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | グループパッドのみ | パッドID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "publicStatus": true
  }
}
```

---

#### 27. 公開ステータス設定

グループパッドの公開ステータスを設定します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/2/pads/publicStatus` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**リクエストボディ**

```json
{
  "padID": "g.xxx$myPad",
  "publicStatus": true
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | グループパッドのみ | パッドID |
| publicStatus | boolean | ○ | - | 公開ステータス |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": null
}
```

---

#### 28. 著者一覧取得

パッドに貢献した全著者を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/pads/authors` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "authorIDs": ["a.s8oes9dhwrvt0zif", "a.akf8finncvomlqva"]
  }
}
```

---

#### 29. ユーザー数取得

現在パッドを編集しているユーザー数を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/pads/usersCount` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "padUsersCount": 3
  }
}
```

---

#### 30. ユーザー一覧取得

現在パッドを編集しているユーザー一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/pads/users` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.1+ |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "padUsers": [
      {
        "id": "a.xxx",
        "colorId": "#ff0000",
        "name": "John Doe",
        "timestamp": 1609459200000
      }
    ]
  }
}
```

---

#### 31. クライアントメッセージ送信

パッドの全クライアントにカスタムメッセージを送信します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/2/pads/clientsMessage` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.1+ |

**リクエストボディ**

```json
{
  "padID": "myPad",
  "msg": "custom_event"
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |
| msg | string | ○ | - | メッセージ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": null
}
```

---

#### 32. チャット履歴取得

パッドのチャット履歴を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/pads/chatHistory` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.2.7+ |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |
| start | integer | - | 0 | 開始位置 |
| end | integer | - | chatHead | 終了位置 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "messages": [
      {
        "text": "Hello!",
        "userId": "a.xxx",
        "userName": "John",
        "time": 1359199533759
      }
    ]
  }
}
```

---

#### 33. 最新チャットメッセージ取得

パッドの最新チャットメッセージを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/pads/chatHead` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.2.7+ |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "chatHead": {
      "text": "Latest message",
      "userId": "a.xxx",
      "userName": "John",
      "time": 1359199534622
    }
  }
}
```

---

#### 34. Diff生成

2つのリビジョン間のdiffを生成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/2/pads/diff` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.2.7+ |

**リクエストボディ**

```json
{
  "padID": "myPad",
  "startRev": 1,
  "endRev": 5
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| padID | string | ○ | - | パッドID |
| startRev | integer | ○ | - | 開始リビジョン |
| endRev | integer | ○ | - | 終了リビジョン |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "html": "<span class='added'>New content</span>",
    "authors": ["a.xxx", "a.yyy"]
  }
}
```

---

#### 35. パッドコピー

パッドをコピーします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/2/pads/copypad` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.2.9+ |

**リクエストボディ**

```json
{
  "sourceID": "myPad",
  "destinationID": "myPadCopy",
  "force": false
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| sourceID | string | ○ | - | コピー元パッドID |
| destinationID | string | ○ | - | コピー先パッドID |
| force | boolean | - | - | 既存を上書きするか |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": null
}
```

---

#### 36. パッド移動

パッドを移動します（コピー後に元を削除）。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /api/2/pads/movePad` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.2.9+ |

**リクエストボディ**

```json
{
  "sourceID": "myPad",
  "destinationID": "newLocation",
  "force": false
}
```

| フィールド名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| sourceID | string | ○ | - | 移動元パッドID |
| destinationID | string | ○ | - | 移動先パッドID |
| force | boolean | - | - | 既存を上書きするか |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": null
}
```

---

### Export/Import

#### 37. パッドエクスポート

パッドを指定形式でエクスポートします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /p/:pad/export/:type` |
| 認証 | パッドアクセス権が必要 |
| レート制限 | あり (設定可能) |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| pad | string | ○ | パッドID |
| type | string | ○ | エクスポート形式 |

**サポート形式**

| 形式 | 説明 | 必要条件 |
| --- | --- | --- |
| txt | プレーンテキスト | なし |
| html | HTML | なし |
| etherpad | Etherpad形式 | なし |
| pdf | PDF | Abiword/LibreOffice |
| doc | Word文書 | Abiword/LibreOffice |
| odt | OpenDocument | Abiword/LibreOffice |

**レスポンス（成功時）**

ファイルがダウンロードされます。

---

#### 38. パッドインポート

パッドにファイルをインポートします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /p/:pad/import` |
| 認証 | パッドへの編集権限が必要 |
| レート制限 | あり (設定可能) |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| pad | string | ○ | パッドID |

**リクエストボディ**

Content-Type: `multipart/form-data`

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| file | file | ○ | インポートするファイル |

---

### Health/Stats

#### 39. ヘルスチェック

サーバーの健全性を確認します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /health` |
| 認証 | 不要 |
| Content-Type | application/health+json |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "status": "pass",
  "releaseId": "2.1.0"
}
```

---

#### 40. 統計情報取得

インスタンスの統計情報を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/stats` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.2.14+ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": {
    "totalPads": 42,
    "totalSessions": 10,
    "totalActivePads": 5
  }
}
```

---

#### 41. APIトークン検証

APIトークンが有効かどうかを確認します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /api/2/checkToken` |
| 認証 | 必要 |
| 権限 | API Key または OAuth Token |
| APIバージョン | 1.2+ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "message": "ok",
  "data": null
}
```

---

## 備考

### APIバージョン履歴

| バージョン | 主な追加機能 |
| --- | --- |
| 1.0 | 基本的なGroup/Author/Session/Pad API |
| 1.1 | listAllGroups, padUsers, getAuthorName, sendClientsMessage |
| 1.2 | checkToken |
| 1.2.1 | listAllPads |
| 1.2.7 | createDiffHTML, getChatHistory, getChatHead |
| 1.2.8 | getAttributePool, getRevisionChangeset |
| 1.2.9 | copyPad, movePad |
| 1.2.10 | getPadID |
| 1.2.11 | savedRevisions API |
| 1.2.12 | appendChatMessage |
| 1.2.13 | appendText |
| 1.2.14 | getStats |
| 1.2.15 | copyPadWithoutHistory |
| 1.3.0 | authorId パラメータの追加 (setText, setHTML等) |

### 認証設定

サーバー設定ファイル（settings.json）で認証方式を選択：

```json
{
  "authenticationMethod": "apikey"
}
```

または

```json
{
  "authenticationMethod": "sso",
  "sso": {
    "issuer": "https://your-domain.com",
    "clients": [...]
  }
}
```

### OpenAPI定義

OpenAPI 3.0.2形式の定義ファイルは以下のエンドポイントで取得可能：

- `/api-docs.json` - REST API v2用
- `/api/openapi.json` - 最新バージョン用
- `/rest/openapi.json` - RESTful API用
- `/api/{version}/openapi.json` - 特定バージョン用

### Swagger UI

`/api-docs` でSwagger UIを利用してAPIを試すことができます。
